/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.atom.price.impl;

import com.ohaotian.commodity.atom.price.InitSkuPriceAtomService;
import com.ohaotian.commodity.atom.price.bo.PriceBO;
import com.ohaotian.commodity.busi.constant.Constant;
import com.ohaotian.commodity.dao.SkuPriceMapper;
import com.ohaotian.commodity.dao.po.SkuPrice;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Qualifier
public class InitSkuPriceAtomServiceImpl
implements InitSkuPriceAtomService {
    private static final Logger logger = LoggerFactory.getLogger(InitSkuPriceAtomServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SkuPriceMapper skuPriceMapper;

    public Boolean initSkuPrice(PriceBO priceBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u521d\u59cb\u5316\u5355\u54c1\u4ef7\u683c\u539f\u5b50\u670d\u52a1\u6267\u884c");
        }
        boolean success = false;
        try {
            SkuPrice skuPrice = new SkuPrice();
            BeanUtils.copyProperties((Object)priceBO, (Object)skuPrice);
            if (skuPrice.getCurrencyType() == null) {
                skuPrice.setCurrencyType(Constant.CURRENCY_TYPE_RMB);
            }
            skuPrice.setCreateTime(new Date());
            skuPrice.setIsDelete(Constant.IS_DELETE);
            this.skuPriceMapper.insert(skuPrice);
            success = true;
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u5355\u54c1\u4ef7\u683c\u539f\u5b50\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38" + e);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u521d\u59cb\u5316\u5355\u54c1\u4ef7\u683c\u539f\u5b50\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
        }
        return success;
    }
}

