/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.property.web.impl;

import com.ohaotian.commodity.busi.property.web.QueryPropGroupBusiService;
import com.ohaotian.commodity.busi.property.web.bo.PropGroupBO;
import com.ohaotian.commodity.busi.property.web.bo.PropGroupReqBO;
import com.ohaotian.commodity.busi.property.web.bo.PropGroupRspBO;
import com.ohaotian.commodity.dao.CommodityPropGrpMapper;
import com.ohaotian.commodity.dao.po.CommodityPropGrp;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="queryPropGroupBusiService")
public class QueryPropGroupBusiServiceImpl
implements QueryPropGroupBusiService {
    private static final Logger logger = LoggerFactory.getLogger(QueryPropGroupBusiServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private CommodityPropGrpMapper commodityPropGrpMapper;

    public PropGroupRspBO queryPropGroup(PropGroupReqBO propGroupReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5c5e\u6027\u7ec4\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)propGroupReqBO.toString());
        }
        PropGroupRspBO rspBO = new PropGroupRspBO();
        try {
            List<CommodityPropGrp> commodityPropGrps = this.commodityPropGrpMapper.selectByTypeChannelGroupId(propGroupReqBO.getCommodityTypeId(), propGroupReqBO.getChannelId(), propGroupReqBO.getPropGroupId());
            if (commodityPropGrps != null && commodityPropGrps.size() > 0) {
                ArrayList propGroupBOS = new ArrayList();
                commodityPropGrps.forEach(propGroup -> {
                    PropGroupBO propGroupBO = new PropGroupBO();
                    BeanUtils.copyProperties((Object)propGroup, (Object)propGroupBO);
                    propGroupBOS.add(propGroupBO);
                });
                rspBO.setPropGroup(propGroupBOS);
            } else {
                logger.info("\u67e5\u8be2\u5c5e\u6027\u7ec4\u4e1a\u52a1\u670d\u52a1\u6570\u636e\u4e3a\u7a7a");
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u67e5\u8be2\u5c5e\u6027\u7ec4\u4e1a\u52a1\u670d\u52a1\u6570\u636e\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5c5e\u6027\u7ec4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25.{}", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u5c5e\u6027\u7ec4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
        return rspBO;
    }
}

