/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.catalog.impl;

import com.ohaotian.commodity.busi.catalog.QueryCatalogInfoService;
import com.ohaotian.commodity.busi.catalog.bo.CatalogRspBO;
import com.ohaotian.commodity.busi.catalog.bo.QueryCatalogReqBO;
import com.ohaotian.commodity.dao.CommodityGuideCatalogMapper;
import com.ohaotian.commodity.dao.po.CommodityGuideCatalog;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class QueryCatalogInfoServiceImpl
implements QueryCatalogInfoService {
    private static final Logger logger = LoggerFactory.getLogger(QueryCatalogInfoServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;

    public void setCommodityGuideCatalogMapper(CommodityGuideCatalogMapper commodityGuideCatalogMapper) {
        this.commodityGuideCatalogMapper = commodityGuideCatalogMapper;
    }

    public RspPageBO<CatalogRspBO> queryCatalogInfo(QueryCatalogReqBO queryCatalogReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u7c7b\u76ee\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0\u5165\u53c2\uff1a" + queryCatalogReqBO.toString());
        }
        RspPageBO rsp = new RspPageBO();
        ArrayList<CatalogRspBO> resultList = new ArrayList<CatalogRspBO>();
        if (null == queryCatalogReqBO.getChannelId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u7c7b\u76ee\u4e1a\u52a1\u670d\u52a1\u9891\u9053ID[channelId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == queryCatalogReqBO.getUpperCatalogId() && null == queryCatalogReqBO.getCatalogLevel()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u7c7b\u76ee\u4e1a\u52a1\u670d\u52a1\u4e0a\u7ea7\u7c7b\u76ee[upperCatalogId]\u3001\u7c7b\u76ee\u7ea7\u522b[catalogLevel]\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        }
        try {
            List<Object> catalogInfos = new ArrayList();
            if (queryCatalogReqBO.getUpperCatalogId() != null) {
                catalogInfos = this.commodityGuideCatalogMapper.selectCatalogByUpperCatalogIdAndChannelId(queryCatalogReqBO.getUpperCatalogId(), queryCatalogReqBO.getChannelId());
            } else if (queryCatalogReqBO.getCatalogLevel() != null) {
                catalogInfos = this.commodityGuideCatalogMapper.selectCatalogByCatalogLevelAndChannelId(queryCatalogReqBO.getCatalogLevel(), queryCatalogReqBO.getChannelId());
            }
            for (CommodityGuideCatalog po : catalogInfos) {
                CatalogRspBO bo = new CatalogRspBO();
                BeanUtils.copyProperties((Object)po, (Object)bo);
                resultList.add(bo);
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7c7b\u76ee\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u7c7b\u76ee\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6210\u529f");
        rsp.setRows(resultList);
        rsp.setTotal(resultList.size());
        return rsp;
    }
}

