/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.impl;

import com.cgd.commodity.busi.vo.QueryParam;
import com.ohaotian.commodity.busi.SearchBarEsService;
import com.ohaotian.commodity.busi.bo.SearchBarEsReqBO;
import com.ohaotian.commodity.busi.bo.SearchBarEsRspBO;
import com.ohaotian.commodity.busi.bo.SearchBarEsRspInfo;
import com.ohaotian.commodity.custom.search.SearchEsQueryService;
import com.ohaotian.commodity.custom.search.SearchEsResultService;
import com.ohaotian.commodity.custom.search.SearchEsSQLService;
import com.ohaotian.commodity.custom.search.bo.QueryParamBO;
import com.ohaotian.commodity.custom.search.bo.SearchEsQueryRspBO;
import com.ohaotian.commodity.custom.search.bo.SearchEsResultRspBO;
import com.ohaotian.commodity.custom.search.bo.SearchEsRspInfoBO;
import com.ohaotian.commodity.custom.search.bo.SearchEsSQLReqBO;
import com.ohaotian.commodity.custom.search.bo.SearchEsSQLRspBO;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SearchBarEsServiceImpl
implements SearchBarEsService {
    private static final Logger logger = LoggerFactory.getLogger(SearchBarEsServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SearchEsSQLService searchEsSQLService;
    @Autowired
    private SearchEsQueryService searchEsQueryService;
    @Autowired
    private SearchEsResultService searchEsResultService;

    public SearchBarEsRspBO qryBySearchBar(SearchBarEsReqBO searchBarEsReqBO) {
        logger.error("SearchBarEsService---------------------------------\u5165\u53c2\uff1a" + searchBarEsReqBO.toString());
        SearchBarEsRspBO bo = new SearchBarEsRspBO();
        SearchEsSQLReqBO searchEsSQLReqBO = new SearchEsSQLReqBO();
        BeanUtils.copyProperties((Object)searchBarEsReqBO, (Object)searchEsSQLReqBO);
        List queryParams = searchBarEsReqBO.getQueryParams();
        ArrayList<QueryParamBO> queryParamBOs = new ArrayList<QueryParamBO>();
        if (queryParams != null && queryParams.size() > 0) {
            for (QueryParam queryParam : queryParams) {
                QueryParamBO queryParamBO = new QueryParamBO();
                BeanUtils.copyProperties((Object)queryParam, (Object)queryParamBO);
                queryParamBOs.add(queryParamBO);
            }
        }
        searchEsSQLReqBO.setQueryParams(queryParamBOs);
        logger.error("searchEsSQLReqBO\u503c\u4e3a---------------------------------\uff1a" + searchEsSQLReqBO.toString());
        SearchEsSQLRspBO builderSQL = this.searchEsSQLService.buildSQL(searchEsSQLReqBO);
        logger.error("SearchEsSQLService\u8fd4\u56de\u67e5\u8be2\u6761\u4ef6---------------------------------\uff1a" + builderSQL.toString());
        SearchEsQueryRspBO executeSQL = this.searchEsQueryService.executeSQL(builderSQL);
        logger.error("searchEsQueryService\u8fd4\u56de\u67e5\u8be2\u7ed3\u679c---------------------------------\uff1a" + executeSQL);
        SearchEsResultRspBO result = this.searchEsResultService.searchResult(executeSQL);
        List hiddenParamsForRsp = builderSQL.getHiddenParamsForRsp();
        SearchResponse searchResponse = executeSQL.getSearchResponse();
        bo.setQueryStr(searchBarEsReqBO.getQueryStr());
        bo.setCategoryId(searchBarEsReqBO.getCategoryId());
        bo.setSupplierId(searchBarEsReqBO.getSupplierId());
        bo.setQueryLocation(searchBarEsReqBO.getQueryLocation());
        bo.setPageNo(searchBarEsReqBO.getPageNo());
        bo.setTotalCount(result.getTotalCount());
        logger.error("\u67e5\u8be2\u4e2a\u6570---------------------------------\uff1a" + result.getTotalCount());
        List list = null;
        if (null != result) {
            list = result.getResult();
        }
        logger.error("\u67e5\u8be2\u4e2a\u6570result---------------------------------\uff1a" + list.size());
        ArrayList<SearchBarEsRspInfo> rspInfos = new ArrayList<SearchBarEsRspInfo>();
        for (SearchEsRspInfoBO searchBarEsRspInfoBO : list) {
            SearchBarEsRspInfo searchBarEsRspInfo = new SearchBarEsRspInfo();
            BeanUtils.copyProperties((Object)searchBarEsRspInfoBO, (Object)searchBarEsRspInfo);
            rspInfos.add(searchBarEsRspInfo);
        }
        bo.setResult(rspInfos);
        if (searchBarEsReqBO.getUserId() != null) {
            bo.setIsLogin(Boolean.valueOf(true));
        } else {
            bo.setIsLogin(Boolean.valueOf(false));
        }
        LinkedList<QueryParam> testParams = new LinkedList<QueryParam>();
        LinkedList supplierValue = new LinkedList();
        LinkedList brandValue = new LinkedList();
        LinkedList category3Value = new LinkedList();
        System.out.println("group_by_supplier_id");
        Terms groupBySupplierId = (Terms)searchResponse.getAggregations().get("group_by_supplier_id_name");
        QueryParam supplierQP = new QueryParam();
        supplierQP.setFilterId("supplier_id_name");
        supplierQP.setFilterName("\u4f9b\u5e94\u5546");
        groupBySupplierId.getBuckets().forEach(bucket -> {
            supplierValue.add(bucket.getKey().toString());
            supplierQP.setFilterValues(supplierValue);
        });
        if (supplierValue != null && supplierValue.size() > 0 && !hiddenParamsForRsp.contains("supplier_id_name")) {
            testParams.add(supplierQP);
        }
        System.out.println("group_by_brand_id");
        Terms groupByBrandId = (Terms)searchResponse.getAggregations().get("group_by_brand_id_name");
        QueryParam brandQP = new QueryParam();
        brandQP.setFilterId("brand_id_name");
        brandQP.setFilterName("\u54c1\u724c");
        groupByBrandId.getBuckets().forEach(bucket -> {
            brandValue.add(bucket.getKey().toString());
            brandQP.setFilterValues(brandValue);
        });
        if (brandValue != null && brandValue.size() > 0 && !hiddenParamsForRsp.contains("brand_id_name")) {
            testParams.add(brandQP);
        }
        Terms groupByCategory3Id = (Terms)searchResponse.getAggregations().get("group_by_l3_category_id_name");
        QueryParam category3IdQP = new QueryParam();
        category3IdQP.setFilterId("l3_category_id_name");
        category3IdQP.setFilterName("\u5206\u7c7b");
        groupByCategory3Id.getBuckets().forEach(bucket -> {
            String value = bucket.getKey().toString();
            if (searchBarEsReqBO.getQueryLocation() != null && value != null && value != "" && value.contains("*~~") && value.endsWith(String.valueOf(searchBarEsReqBO.getQueryLocation()))) {
                String[] values = value.split("\\*~~");
                if (values.length > 2) {
                    value = values[0] + "*~~" + values[1];
                }
                category3Value.add(value);
                category3IdQP.setFilterValues(category3Value);
            }
        });
        if (category3Value != null && category3Value.size() > 0 && !hiddenParamsForRsp.contains("l3_category_id_name")) {
            testParams.add(category3IdQP);
        }
        bo.setQueryParams(testParams);
        return bo;
    }
}

