/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.intfce.handshow.impl;

import com.cgd.commodity.util.HttpRequestUtils;
import com.cgd.common.exception.BusinessException;
import com.ohaotian.commodity.busi.sku.QuerySkuDetailBusiService;
import com.ohaotian.commodity.busi.sku.bo.QuerySkuDetailReqBO;
import com.ohaotian.commodity.busi.sku.bo.QuerySkuDetailRspBO;
import com.ohaotian.commodity.intfce.handshow.ElectronicPricePushBusiService;
import com.ohaotian.commodity.intfce.handshow.bo.HandShowGoodBO;
import com.ohaotian.plugin.base.bo.RspBaseBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="electronicPricePushBusiService")
public class ElectronicPricePushBusiServiceImpl
implements ElectronicPricePushBusiService {
    private static final Logger logger = LoggerFactory.getLogger(ElectronicPricePushBusiServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private Properties prop;
    @Autowired
    private QuerySkuDetailBusiService querySkuDetailBusiService;

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    public RspBaseBO electronicPricePush(List<QuerySkuDetailRspBO> skuList) {
        RspBaseBO result = new RspBaseBO();
        if (this.isDebugEnabled) {
            logger.error("\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u5bf9\u63a5\u6761\u6570\uff1a" + skuList.size());
        }
        try {
            HashMap supplierMap = new HashMap();
            for (QuerySkuDetailRspBO querySkuDetailRspBO : skuList) {
                HandShowGoodBO good = this.skuToGood(querySkuDetailRspBO);
                good.setQrCode(this.prop.getProperty("qrcode.prefix") + "supplierId=" + querySkuDetailRspBO.getSupplierId() + "&skuId=" + querySkuDetailRspBO.getSkuId());
                if (supplierMap.containsKey(querySkuDetailRspBO.getSupplierId())) {
                    ((List)supplierMap.get(querySkuDetailRspBO.getSupplierId())).add(good);
                    continue;
                }
                ArrayList<HandShowGoodBO> list = new ArrayList<HandShowGoodBO>();
                list.add(good);
                supplierMap.put(querySkuDetailRspBO.getSupplierId(), list);
            }
            logger.error("\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u5bf9\u63a5\u95e8\u5e97\uff1a" + supplierMap);
            for (Map.Entry entry : supplierMap.entrySet()) {
                List items = (List)entry.getValue();
                if (null == items || items.size() <= 0) continue;
                int pointsDataLimit = 10000;
                Integer size = items.size();
                if (pointsDataLimit < size) {
                    int part = size / pointsDataLimit;
                    logger.error("\u95e8\u5e97" + entry.getKey() + "\u5171\u6709 \uff1a " + size + "\u6761\uff0c\uff01" + " \u5206\u4e3a \uff1a" + part + "\u6279");
                    for (int i = 0; i < part; ++i) {
                        List<HandShowGoodBO> listPage = items.subList(0, pointsDataLimit);
                        JSONObject rsp = this.integration((Long)entry.getKey(), listPage);
                        if (null == rsp || !"0".equals(rsp.getString("resultCode"))) {
                            logger.error("\u95e8\u5e97" + entry.getKey() + "\u7b2c" + i + "\u6279\u540c\u6b65\u5931\u8d25");
                            throw new BusinessException("\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u51fa\u9519" + rsp);
                        }
                        logger.error("\u95e8\u5e97" + entry.getKey() + "\u7b2c" + i + "\u6279\u540c\u6b65\u6210\u529f");
                        items.subList(0, pointsDataLimit).clear();
                    }
                    if (items.isEmpty()) continue;
                    JSONObject rsp = this.integration((Long)entry.getKey(), items);
                    if (null != rsp && "0".equals(rsp.getString("resultCode"))) {
                        logger.error("\u95e8\u5e97" + entry.getKey() + "\u6279\u540c\u6b65\u6210\u529f");
                        continue;
                    }
                    logger.error("\u95e8\u5e97" + entry.getKey() + "\u6279\u540c\u6b65\u5931\u8d25");
                    throw new BusinessException("\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u51fa\u9519" + rsp);
                }
                JSONObject rsp = this.integration((Long)entry.getKey(), items);
                if (null != rsp && "0".equals(rsp.getString("resultCode"))) {
                    logger.error("\u95e8\u5e97" + entry.getKey() + "\u6279\u540c\u6b65\u6210\u529f");
                    continue;
                }
                logger.error("\u95e8\u5e97" + entry.getKey() + "\u6279\u540c\u6b65\u5931\u8d25");
                throw new BusinessException("\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u51fa\u9519" + rsp);
            }
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u51fa\u9519" + e);
            throw new BusinessException("\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u51fa\u9519", (Throwable)e);
        }
        result.setCode("0000");
        result.setMessage("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public JSONObject integration(Long supplierId, List<HandShowGoodBO> goodList) {
        JSONObject rspJson = new JSONObject();
        try {
            logger.error("\u8c03\u7528\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u5f00\u59cb");
            JSONObject param = new JSONObject();
            param.put((Object)"storeCode", (Object)supplierId);
            param.put((Object)"customerStoreCode", (Object)supplierId);
            param.put((Object)"batchSize", (Object)goodList.size());
            String batchNo = "newretail" + System.currentTimeMillis() + (int)((Math.random() * 9.0 + 1.0) * 10000.0);
            param.put((Object)"batchNo", (Object)batchNo);
            JSONArray array = JSONArray.fromObject(goodList);
            param.put((Object)"items", (Object)array);
            String postUrl = this.prop.getProperty("electronic.price.integration");
            logger.error("\u8c03\u7528\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3url:" + postUrl);
            logger.error("\u8c03\u7528\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3param:" + param.toString());
            String postStr = HttpRequestUtils.httpPost(postUrl.toString(), param);
            logger.error("\u8c03\u7528\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u8fd4\u56de:" + postStr);
            rspJson = JSONObject.fromObject((Object)postStr.toString());
        }
        catch (Exception e) {
            throw new BusinessException("\u8c03\u7528\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u9519\u8bef", (Throwable)e);
        }
        return rspJson;
    }

    private HandShowGoodBO skuToGood(QuerySkuDetailRspBO sku) {
        HandShowGoodBO good = new HandShowGoodBO();
        good.setSku(String.valueOf(sku.getSkuId()));
        good.setCustomerStoreCode(String.valueOf(sku.getSupplierId()));
        good.setItemName(sku.getSkuLongName());
        if (null != sku.getPrice()) {
            good.setPrice1(sku.getPrice().getSalePrice());
            good.setPrice3(sku.getPrice().getMemberPrice());
            good.setPrice3Description("\u4f1a\u5458\u4ef7");
            good.setPrice4(sku.getPrice().getAgreementPrice());
            good.setPrice4Description("\u534f\u8bae\u4ef7");
            good.setPrice5(sku.getPrice().getMarketPrice());
            good.setPrice5Description("\u5e02\u573a\u4ef7");
        }
        good.setItemShortName(sku.getSkuName());
        good.setEan(String.valueOf(sku.getSkuId()));
        good.setBrand(sku.getBrandName());
        good.setDescription(sku.getRemark());
        good.setSupprlierCode(String.valueOf(sku.getVendorId()));
        good.setSupplierName(sku.getVendorName());
        good.setRsrvTxt1(sku.getPriceTagTemp());
        return good;
    }

    public RspBaseBO puhSku(QuerySkuDetailReqBO reqBO) {
        RspBaseBO result = new RspBaseBO();
        logger.error("\u6839\u636e\u6761\u4ef6\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u5165\u53c2\uff1a" + reqBO.toString());
        if (null == reqBO.getSkuId() || null == reqBO.getSupplierId()) {
            throw new BusinessException("\u6839\u636e\u6761\u4ef6\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u7f3a\u5c11\u5165\u53c2\uff1askuId\u6216supplierId");
        }
        try {
            ArrayList<QuerySkuDetailRspBO> detailList = new ArrayList<QuerySkuDetailRspBO>();
            QuerySkuDetailRspBO detailBo = this.querySkuDetailBusiService.querySkuDetail(reqBO);
            if (null != detailBo) {
                detailList.add(detailBo);
            }
            if (detailList.size() <= 0) {
                result.setCode("0001");
                result.setMessage("\u67e5\u8be2sku\u8be6\u60c5\u51fa\u9519");
                return result;
            }
            logger.error("\u6839\u636e\u6761\u4ef6\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u5f00\u59cb\u63a8\u9001");
            this.electronicPricePush(detailList);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u6761\u4ef6\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519\uff1a" + e.getMessage());
            throw new BusinessException("\u6839\u636e\u6761\u4ef6\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519\uff1a", (Throwable)e);
        }
        result.setCode("0000");
        result.setMessage("\u64cd\u4f5c\u6210\u529f");
        return result;
    }
}

