/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.cgd.commodity.busi.SkuRecoOnShelfService;
import com.cgd.commodity.busi.bo.SkuRecoOnShelfReqBO;
import com.cgd.commodity.busi.bo.SkuRecoOnShelfRspBO;
import com.cgd.commodity.constant.Constant;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.intfce.bo.ApproveSkuStateUpConReqBO;
import com.cgd.commodity.intfce.bo.CreateApproveConsumerReqBO;
import com.cgd.commodity.intfce.bo.SkuStatuChangeLogConsumerReqBO;
import com.cgd.commodity.intfce.vo.CreateApproveConsumerReqVO;
import com.cgd.commodity.intfce.vo.SkuStatuChangeLogConsumerVO;
import com.cgd.commodity.po.Sku;
import com.cgd.commodity.util.RandomGUIDUtil;
import com.ohaotian.commodity.config.TopicConfig;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkuRecoOnShelfServiceImpl
implements SkuRecoOnShelfService {
    private static final Logger logger = LoggerFactory.getLogger(SkuRecoOnShelfServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;
    @Resource
    TopicConfig topicConfig;
    @Resource(name="createApproveLogProducer")
    private ProxyMessageProducer createApproveLogProducer;
    @Resource(name="skuStateChangeLogProducer")
    private ProxyMessageProducer skuStateChangeLogProducer;
    @Resource(name="approveLogSkuUpdateProducer")
    private ProxyMessageProducer approveLogSkuUpdateProducer;

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public SkuRecoOnShelfRspBO skuRecoOnShelf(SkuRecoOnShelfReqBO skuRecoOnShelfReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u6062\u590d\u4e0a\u67b6\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + skuRecoOnShelfReqBO.toString());
        }
        if (null == skuRecoOnShelfReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u6062\u590d\u4e0a\u67b6\u4e1a\u52a1\u670d\u52a1\u4f9b\u5e94\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == skuRecoOnShelfReqBO.getSkuId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u6062\u590d\u4e0a\u67b6\u4e1a\u52a1\u670d\u52a1\u5546\u54c1id[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == skuRecoOnShelfReqBO.getApproveId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u6062\u590d\u4e0a\u67b6\u4e1a\u52a1\u670d\u52a1\u5ba1\u6279id[approveId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Boolean result = this.isMatchState(skuRecoOnShelfReqBO);
        if (!result.booleanValue()) {
            throw new BusinessException("RSP_CODE_SKU_STATE_ERROR", "\u6240\u9009\u5546\u54c1\u4e0d\u5b58\u5728\u6216\u8005\u72b6\u6001\u4e0d\u6b63\u786e");
        }
        try {
            Sku sku = new Sku();
            sku.setSkuId(skuRecoOnShelfReqBO.getSkuId());
            sku.setSupplierId(skuRecoOnShelfReqBO.getSupplierId());
            sku.setSkuStatus(Constant.SKU_STATUS_SHELVED);
            sku.setUpdateLoginId(skuRecoOnShelfReqBO.getUserId());
            sku.setUpdateTime(new Date());
            int updateResult = this.skuMapper.updateByPrimaryKeySelective(sku, skuRecoOnShelfReqBO.getSupplierId());
            if (1 == updateResult) {
                this.sendMsg(skuRecoOnShelfReqBO, Constant.SKU_STATUS_SHELVED, true);
            } else {
                this.sendMsg(skuRecoOnShelfReqBO, Constant.SKU_STATUS_SUPPLIER_RACK, false);
            }
            SkuRecoOnShelfRspBO skuRecoOnShelfRspBO = new SkuRecoOnShelfRspBO();
            skuRecoOnShelfRspBO.setIsSuccess(Boolean.valueOf(true));
            return skuRecoOnShelfRspBO;
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u6062\u590d\u4e0a\u67b6\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            this.sendMsg(skuRecoOnShelfReqBO, Constant.SKU_STATUS_SUPPLIER_RACK, false);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u6062\u590d\u4e0a\u67b6\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private Boolean isMatchState(SkuRecoOnShelfReqBO skuRecoOnShelfReqBO) {
        try {
            Sku sku = this.skuMapper.selDetByIdASupIdALoc(skuRecoOnShelfReqBO.getSkuId(), skuRecoOnShelfReqBO.getSupplierId(), 2);
            if (Constant.SKU_STATUS_SUPPLIER_RACK.equals(sku.getSkuStatus())) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u6062\u590d\u4e0a\u67b6\u4e1a\u52a1\u670d\u52a1\u67e5\u8be2sku\u72b6\u6001\u5931\u8d25:" + e);
            return false;
        }
        return false;
    }

    private void sendMsg(SkuRecoOnShelfReqBO skuRecoOnShelfReqBO, Integer skuState, Boolean flag) {
        ArrayList<Long> skuIds;
        try {
            SkuStatuChangeLogConsumerReqBO skuStatuChangeLogConsumerReqBO = new SkuStatuChangeLogConsumerReqBO();
            skuStatuChangeLogConsumerReqBO.setOperatorId(skuRecoOnShelfReqBO.getUserId());
            skuStatuChangeLogConsumerReqBO.setPreState(Constant.SKU_STATUS_SUPPLIER_RACK);
            skuStatuChangeLogConsumerReqBO.setRandomStr(RandomGUIDUtil.getRandomGUID());
            if (flag.booleanValue()) {
                skuStatuChangeLogConsumerReqBO.setPostState(skuState);
                skuStatuChangeLogConsumerReqBO.setApproveComments("\u66f4\u65b0\u6210\u529f");
            } else {
                skuStatuChangeLogConsumerReqBO.setPostState(Constant.SKU_STATUS_SUPPLIER_RACK);
                skuStatuChangeLogConsumerReqBO.setApproveComments("\u66f4\u65b0\u5931\u8d25");
            }
            SkuStatuChangeLogConsumerVO skuStatuChangeLogConsumerVO = new SkuStatuChangeLogConsumerVO();
            skuIds = new ArrayList<Long>();
            skuIds.add(skuRecoOnShelfReqBO.getSkuId());
            skuStatuChangeLogConsumerVO.setSkuIds(skuIds);
            skuStatuChangeLogConsumerVO.setSupplierId(skuRecoOnShelfReqBO.getSupplierId());
            skuStatuChangeLogConsumerReqBO.setSku(skuStatuChangeLogConsumerVO);
            this.skuStateChangeLogProducer.sendOneway(new ProxyMessage(this.topicConfig.getSkuStateUpdateTopicName(), this.topicConfig.getSkuStateUpdateTagName(), JSONObject.toJSONString((Object)skuStatuChangeLogConsumerReqBO)));
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u6062\u590d\u4e0a\u67b6\u4e1a\u52a1\u670d\u52a1\u53d1\u9001sku\u72b6\u6001\u53d8\u66f4\u6d88\u606f\u5931\u8d25" + e);
        }
        try {
            ApproveSkuStateUpConReqBO approveSkuStateUpConReqBO = new ApproveSkuStateUpConReqBO();
            approveSkuStateUpConReqBO.setApproveId(skuRecoOnShelfReqBO.getApproveId());
            approveSkuStateUpConReqBO.setApproveSkuState(Constant.SKU_STATUS_SHELVED);
            approveSkuStateUpConReqBO.setSkuId(skuRecoOnShelfReqBO.getSkuId());
            approveSkuStateUpConReqBO.setSupplierId(skuRecoOnShelfReqBO.getSupplierId());
            approveSkuStateUpConReqBO.setUpdateLoginId(skuRecoOnShelfReqBO.getUserId());
            this.approveLogSkuUpdateProducer.sendOneway(new ProxyMessage(this.topicConfig.getApproveSkuStateUpdateTopicName(), this.topicConfig.getApproveSkuStateUpdateTagName(), JSONObject.toJSONString((Object)approveSkuStateUpConReqBO)));
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u6062\u590d\u4e0a\u67b6\u4e1a\u52a1\u670d\u52a1\u53d1\u9001\u6279\u65e5\u5fd7\u5546\u54c1\u72b6\u6001\u53d8\u66f4\u6d88\u606f\u5931\u8d25" + e);
        }
        try {
            CreateApproveConsumerReqBO createApproveConsumerReqBO = new CreateApproveConsumerReqBO();
            createApproveConsumerReqBO.setOperatorId(skuRecoOnShelfReqBO.getUserId());
            createApproveConsumerReqBO.setOperateType(Integer.valueOf(0));
            createApproveConsumerReqBO.setApproveSkuState(Constant.SKU_STATUS_SHELVED);
            CreateApproveConsumerReqVO createApproveConsumerReqVO = new CreateApproveConsumerReqVO();
            skuIds = new ArrayList();
            skuIds.add(skuRecoOnShelfReqBO.getSkuId());
            createApproveConsumerReqVO.setSkuIds(skuIds);
            createApproveConsumerReqVO.setSupplierId(skuRecoOnShelfReqBO.getSupplierId());
            createApproveConsumerReqBO.setSku(createApproveConsumerReqVO);
            createApproveConsumerReqBO.setOperatorName(skuRecoOnShelfReqBO.getUserName());
            createApproveConsumerReqBO.setRandomStr(RandomGUIDUtil.getRandomGUID());
            if (flag.booleanValue()) {
                createApproveConsumerReqBO.setSuccess(Integer.valueOf(1));
            } else {
                createApproveConsumerReqBO.setSuccess(Integer.valueOf(0));
            }
            this.createApproveLogProducer.sendOneway(new ProxyMessage(this.topicConfig.getSkuApproveTopicName(), this.topicConfig.getSkuApproveTagName(), JSONObject.toJSONString((Object)createApproveConsumerReqBO)));
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u6062\u590d\u4e0a\u67b6\u4e1a\u52a1\u670d\u52a1\u53d1\u9001\u5ba1\u6279\u65e5\u5fd7\u65b0\u589e\u6d88\u606f\u5931\u8d25" + e);
        }
    }
}

