/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryOffShelfSkuLogService;
import com.cgd.commodity.busi.bo.QryOffShelfSkuLogReqBO;
import com.cgd.commodity.busi.bo.QryOffShelfSkuLogRspBO;
import com.cgd.commodity.busi.vo.supply.QryOffShelfSkuLogRspVO;
import com.cgd.commodity.dao.CatalogCommodityTypeMapper;
import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SkuOffShelveLogMapper;
import com.cgd.commodity.po.CatalogCommodityType;
import com.cgd.commodity.po.SkuOffShelveLog;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class QryOffShelfSkuLogServiceImpl
implements QryOffShelfSkuLogService {
    private static final Logger logger = LoggerFactory.getLogger(QryOffShelfSkuLogServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;
    private CatalogCommodityTypeMapper catalogCommodityTypeMapper;
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;
    @Autowired
    private SkuOffShelveLogMapper skuOffShelveLogMapper;

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setCatalogCommodityTypeMapper(CatalogCommodityTypeMapper catalogCommodityTypeMapper) {
        this.catalogCommodityTypeMapper = catalogCommodityTypeMapper;
    }

    public void setCommodityGuideCatalogMapper(CommodityGuideCatalogMapper commodityGuideCatalogMapper) {
        this.commodityGuideCatalogMapper = commodityGuideCatalogMapper;
    }

    public RspPageBO<QryOffShelfSkuLogRspBO> qryOffShelfSkuLog(QryOffShelfSkuLogReqBO qryOffShelfSkuLogReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5546\u54c1\u4e0b\u67b6\u8bb0\u5f55\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryOffShelfSkuLogReqBO.toString());
        }
        if (null == qryOffShelfSkuLogReqBO.getUserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7528\u6237ID[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            int indexOf;
            String skuName;
            LinkedList<Long> commodityTypeIds = new LinkedList<Long>();
            if (null != qryOffShelfSkuLogReqBO.getCatalogId()) {
                List<CatalogCommodityType> catalogs = this.catalogCommodityTypeMapper.selectByCatalogId(qryOffShelfSkuLogReqBO.getCatalogId());
                for (CatalogCommodityType catalogCommodityType : catalogs) {
                    commodityTypeIds.add(catalogCommodityType.getCommodityTypeId());
                }
            }
            if ((skuName = qryOffShelfSkuLogReqBO.getSkuName()) != null && !"".equals(skuName) && (indexOf = skuName.indexOf(92)) != -1) {
                String name = skuName.replaceAll("\\\\", "\\\\\\\\");
                qryOffShelfSkuLogReqBO.setSkuName(name);
            }
            Page page = new Page(qryOffShelfSkuLogReqBO.getPageNo(), qryOffShelfSkuLogReqBO.getPageSize());
            List<QryOffShelfSkuLogRspVO> qryOffShelfSkuLogVOs = this.skuMapper.qrySkuByConditions((Page<QryOffShelfSkuLogReqBO>)page, qryOffShelfSkuLogReqBO, commodityTypeIds);
            List<QryOffShelfSkuLogRspBO> qryOffShelfSkuLogRspBOs = this.resolveRsp(qryOffShelfSkuLogVOs, qryOffShelfSkuLogReqBO);
            RspPageBO rspPageBO = new RspPageBO();
            rspPageBO.setRecordsTotal(page.getTotalCount());
            rspPageBO.setTotal(page.getTotalPages());
            rspPageBO.setPageNo(qryOffShelfSkuLogReqBO.getPageNo());
            rspPageBO.setRows(qryOffShelfSkuLogRspBOs);
            return rspPageBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5546\u54c1\u4e0b\u67b6\u8bb0\u5f55\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u5546\u54c1\u4e0b\u67b6\u8bb0\u5f55\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private List<QryOffShelfSkuLogRspBO> resolveRsp(List<QryOffShelfSkuLogRspVO> qryOffShelfSkuLogVOs, QryOffShelfSkuLogReqBO qryOffShelfSkuLogReqBO) {
        try {
            HashMap<Long, String> skuMaps = new HashMap<Long, String>();
            ArrayList<QryOffShelfSkuLogRspBO> qryOffShelfSkuLogRspBOs = new ArrayList<QryOffShelfSkuLogRspBO>();
            if (!qryOffShelfSkuLogVOs.isEmpty()) {
                LinkedList<Long> commodityTypeIds = new LinkedList<Long>();
                LinkedList<Long> skuIds = new LinkedList<Long>();
                for (QryOffShelfSkuLogRspVO qryOffShelfSkuLogRspVO : qryOffShelfSkuLogVOs) {
                    commodityTypeIds.add(qryOffShelfSkuLogRspVO.getCommodityTypeId());
                    skuIds.add(qryOffShelfSkuLogRspVO.getSkuId());
                }
                List<Map<String, Object>> catalogMaps = this.commodityGuideCatalogMapper.selectCatalogNameBatByTypeIdAndLocation(commodityTypeIds);
                List<SkuOffShelveLog> SkuOffShelveLogs = this.skuOffShelveLogMapper.selectBySkuIds(skuIds, qryOffShelfSkuLogReqBO.getSupplierId(), qryOffShelfSkuLogReqBO.getAgreementId());
                for (QryOffShelfSkuLogRspVO qryOffShelfSkuLogRspVO : qryOffShelfSkuLogVOs) {
                    QryOffShelfSkuLogRspBO qryOffShelfSkuLogRspBO = new QryOffShelfSkuLogRspBO();
                    qryOffShelfSkuLogRspBO = this.getQryOffShelfSkuLogRspBO(qryOffShelfSkuLogRspBO, qryOffShelfSkuLogRspVO);
                    if (!catalogMaps.isEmpty()) {
                        for (Map<String, Object> map : catalogMaps) {
                            if (!map.get("commodityTypeId").equals(qryOffShelfSkuLogRspVO.getCommodityTypeId())) continue;
                            qryOffShelfSkuLogRspBO.setFirstCatalogName((String)map.get("firstCatalogName"));
                            qryOffShelfSkuLogRspBO.setSecondCatalogName((String)map.get("secondCatalogName"));
                            qryOffShelfSkuLogRspBO.setThirdCatalogName((String)map.get("thirdCatalogName"));
                        }
                    }
                    qryOffShelfSkuLogRspBOs.add(qryOffShelfSkuLogRspBO);
                }
                for (SkuOffShelveLog skuOffShelveLog : SkuOffShelveLogs) {
                    skuMaps.put(skuOffShelveLog.getSkuId(), skuOffShelveLog.getSoldOutReason());
                }
                for (QryOffShelfSkuLogRspBO qryOffShelfSkuLogRspBO : qryOffShelfSkuLogRspBOs) {
                    qryOffShelfSkuLogRspBO.setSoldOutReason((String)skuMaps.get(qryOffShelfSkuLogRspBO.getSkuId()));
                }
            }
            return qryOffShelfSkuLogRspBOs;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5546\u54c1\u4e0b\u67b6\u8bb0\u5f55\u4e1a\u52a1\u670d\u52a1\u67e5\u8be2\u5546\u54c1\u7c7b\u76ee\u540d\u79f0\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u67e5\u8be2\u5546\u54c1\u7c7b\u76ee\u540d\u79f0\u5931\u8d25");
        }
    }

    private QryOffShelfSkuLogRspBO getQryOffShelfSkuLogRspBO(QryOffShelfSkuLogRspBO qryOffShelfSkuLogRspBO, QryOffShelfSkuLogRspVO qryOffShelfSkuLogRspVO) throws Exception {
        qryOffShelfSkuLogRspBO.setAgreementId(qryOffShelfSkuLogRspVO.getAgreementId());
        qryOffShelfSkuLogRspBO.setAgreementSkuId(qryOffShelfSkuLogRspVO.getAgreementSkuId());
        qryOffShelfSkuLogRspBO.setBrandName(qryOffShelfSkuLogRspVO.getBrandName());
        qryOffShelfSkuLogRspBO.setMarketPrice(MoneyUtils.Long2BigDecimal((Long)qryOffShelfSkuLogRspVO.getMarketPrice()));
        qryOffShelfSkuLogRspBO.setSkuId(qryOffShelfSkuLogRspVO.getSkuId());
        qryOffShelfSkuLogRspBO.setSkuName(qryOffShelfSkuLogRspVO.getSkuName());
        qryOffShelfSkuLogRspBO.setSupplierId(qryOffShelfSkuLogRspVO.getSupplierId());
        qryOffShelfSkuLogRspBO.setSupplierName(qryOffShelfSkuLogRspVO.getSupplierName());
        qryOffShelfSkuLogRspBO.setCreateTime(qryOffShelfSkuLogRspVO.getCreateTime());
        qryOffShelfSkuLogRspBO.setVendorId(qryOffShelfSkuLogRspVO.getVendorId());
        qryOffShelfSkuLogRspBO.setVendorName(qryOffShelfSkuLogRspVO.getVendorName());
        qryOffShelfSkuLogRspBO.setProcInstlId(qryOffShelfSkuLogRspVO.getProcInstlId());
        return qryOffShelfSkuLogRspBO;
    }
}

