/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.impl;

import com.cgd.commodity.constant.SupplyConstant;
import com.ohaotian.commodity.busi.bo.SkuApprTaskBO;
import com.ohaotian.commodity.busi.intfce.SkuApproveTaskService;
import com.ohaotian.commodity.dao.SkuChangeApprTaskMapper;
import com.ohaotian.commodity.dao.SkuOffShelveApprTaskMapper;
import com.ohaotian.commodity.dao.SkuOnShelveApprTaskMapper;
import com.ohaotian.commodity.dao.SkuRegainOnShelveApprTaskMapper;
import com.ohaotian.commodity.dao.po.SkuChangeApprTask;
import com.ohaotian.commodity.dao.po.SkuOffShelveApprTask;
import com.ohaotian.commodity.dao.po.SkuOnShelveApprTask;
import com.ohaotian.commodity.dao.po.SkuRegainOnShelveApprTask;
import com.ohaotian.plugin.base.bo.RspBusiBaseBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SkuApproveTaskServiceImpl
implements SkuApproveTaskService {
    private static final Logger logger = LoggerFactory.getLogger(SkuApproveTaskServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SkuOnShelveApprTaskMapper skuOnShelveApprTaskMapper;
    @Autowired
    private SkuOffShelveApprTaskMapper skuOffShelveApprTaskMapper;
    @Autowired
    private SkuChangeApprTaskMapper skuChangeApprTaskMapper;
    @Autowired
    private SkuRegainOnShelveApprTaskMapper skuRegainOnShelveApprTaskMapper;

    public RspBusiBaseBO addSkuApproveTask(SkuApprTaskBO skuApprTaskBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5546\u54c1\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u5165\u53c2 \uff1a" + skuApprTaskBO.toString());
        }
        RspBusiBaseBO rspBusiBaseBO = new RspBusiBaseBO();
        String errorStr = this.checkMustParams(skuApprTaskBO);
        if (errorStr.length() > 0) {
            logger.error("\u5546\u54c1\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u51fa\u9519\uff1a" + errorStr + "\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5ba1\u6838\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u4e1a\u52a1\u670d\u52a1[skuApprTaskBO]\u4e2d" + errorStr + "\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date nowDate = new Date();
        skuApprTaskBO.setTaskStatus(SupplyConstant.APPROVE_SUB_TYPE);
        skuApprTaskBO.setCreateTime(nowDate);
        skuApprTaskBO.setCreateLoginId(skuApprTaskBO.getUserId());
        skuApprTaskBO.setUpdateTime(nowDate);
        skuApprTaskBO.setUpdateLoginId(skuApprTaskBO.getUserId());
        skuApprTaskBO.setIsDelete(Byte.valueOf((byte)0));
        StringBuilder acceptIds = new StringBuilder();
        for (String acceptId : skuApprTaskBO.getAcceptIdList()) {
            if (acceptIds.length() == 0) {
                acceptIds.append(acceptId);
                continue;
            }
            acceptIds.append(",").append(acceptId);
        }
        skuApprTaskBO.setAcceptId(acceptIds.toString());
        try {
            if (skuApprTaskBO.getApproveType().equals("10")) {
                SkuOnShelveApprTask skuOnShelveApprTask = new SkuOnShelveApprTask();
                BeanUtils.copyProperties((Object)skuApprTaskBO, (Object)skuOnShelveApprTask);
                this.skuOnShelveApprTaskMapper.insertSelective(skuOnShelveApprTask);
            } else if (skuApprTaskBO.getApproveType().equals("11")) {
                SkuOffShelveApprTask skuOffShelveApprTask = new SkuOffShelveApprTask();
                BeanUtils.copyProperties((Object)skuApprTaskBO, (Object)skuOffShelveApprTask);
                this.skuOffShelveApprTaskMapper.insertSelective(skuOffShelveApprTask);
            } else if (skuApprTaskBO.getApproveType().equals("12")) {
                SkuRegainOnShelveApprTask skuRegainOnShelveApprTask = new SkuRegainOnShelveApprTask();
                BeanUtils.copyProperties((Object)skuApprTaskBO, (Object)skuRegainOnShelveApprTask);
                this.skuRegainOnShelveApprTaskMapper.insertSelective(skuRegainOnShelveApprTask);
            } else {
                SkuChangeApprTask skuChangeApprTask = new SkuChangeApprTask();
                BeanUtils.copyProperties((Object)skuApprTaskBO, (Object)skuChangeApprTask);
                this.skuChangeApprTaskMapper.insertSelective(skuChangeApprTask);
            }
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u5546\u54c1\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return rspBusiBaseBO;
    }

    private String checkMustParams(SkuApprTaskBO skuApprTaskBO) {
        StringBuffer errorStr = new StringBuffer();
        if (skuApprTaskBO.getAgreementId() == null) {
            errorStr.append("\u534f\u8baeID[agreementId]");
        }
        if (null == skuApprTaskBO.getSupplierId()) {
            errorStr.append("\u94fa\u8d27\u5355\u4f4dID[supplierId]");
        }
        if (null == skuApprTaskBO.getSkuId()) {
            errorStr.append("\u5546\u54c1ID[skuId]");
        }
        if (null == skuApprTaskBO.getApproveType()) {
            errorStr.append("\u5ba1\u6279\u7c7b\u578b[approveType]");
        }
        if (skuApprTaskBO.getAcceptIdList() == null || skuApprTaskBO.getAcceptIdList().size() == 0) {
            errorStr.append("\u5f85\u529e\u4eba[acceptId]");
        }
        if (StringUtils.isBlank((CharSequence)skuApprTaskBO.getTaskId())) {
            errorStr.append("\u5de5\u4f5c\u6d41\u4efb\u52a1ID[taskId]");
        }
        if (StringUtils.isBlank((CharSequence)skuApprTaskBO.getTaskNode())) {
            errorStr.append("\u5de5\u4f5c\u6d41\u8282\u70b9[taskNode]");
        }
        if (StringUtils.isBlank((CharSequence)skuApprTaskBO.getProcInstId())) {
            errorStr.append("\u5de5\u4f5c\u6d41\u5b9e\u4f8bID[procInstlId]");
        }
        if (skuApprTaskBO.getUserId() == null) {
            errorStr.append("\u5f53\u524d\u767b\u9646\u4ebaID[userId]");
        }
        if (StringUtils.isBlank((CharSequence)skuApprTaskBO.getUserName())) {
            errorStr.append("\u5f53\u524d\u767b\u9646\u4ebaID[userName]");
        }
        if (skuApprTaskBO.getAgrLocation() == null) {
            errorStr.append("\u534f\u8bae\u4f4d\u7f6e[agrLocation]");
        }
        return errorStr.toString();
    }
}

