/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.manage.market.impl;

import com.ohaotian.base.common.util.MoneyUtil;
import com.ohaotian.commodity.busi.manage.market.extend.QueryCatalogNameService;
import com.ohaotian.commodity.busi.manage.market.impl.ElecSkuStartWorkFlowServiceImpl;
import com.ohaotian.commodity.busi.manage.market.web.QueryElecSkuDetailService;
import com.ohaotian.commodity.busi.manage.market.web.bo.CelecSkuApproveLogBO;
import com.ohaotian.commodity.busi.manage.market.web.bo.QueryElecSkuDetailReqBO;
import com.ohaotian.commodity.busi.manage.market.web.bo.QueryElecSkuDetailRspBO;
import com.ohaotian.commodity.common.exception.BusinessException;
import com.ohaotian.commodity.dao.ElecSkuApproveLogMapper;
import com.ohaotian.commodity.dao.SkuMapper;
import com.ohaotian.commodity.dao.SkuPriceMapper;
import com.ohaotian.commodity.dao.po.ElecSkuApproveLogPO;
import com.ohaotian.commodity.dao.po.Sku;
import com.ohaotian.commodity.dao.po.SkuPrice;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="queryElecSkuDetailService")
public class QueryElecSkuDetailServiceImpl
implements QueryElecSkuDetailService {
    private static final Logger logger = LoggerFactory.getLogger(ElecSkuStartWorkFlowServiceImpl.class);
    private final boolean isDebugEnablled = logger.isDebugEnabled();
    @Autowired
    private ElecSkuApproveLogMapper celecSkuApproveLogMapper;
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private QueryCatalogNameService queryCatalogNameService;
    @Autowired
    private SkuPriceMapper skuPriceMapper;

    public QueryElecSkuDetailRspBO queryElecSkuDetail(QueryElecSkuDetailReqBO queryElecSkuDetailReqBO) {
        if (this.isDebugEnablled) {
            logger.debug("\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u4fe1\u606f\u5165\u53c2queryElecSkuDetailReqBO\uff1a" + queryElecSkuDetailReqBO.toString());
        }
        if (null == queryElecSkuDetailReqBO.getSkuId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5355\u54c1Id[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == queryElecSkuDetailReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4f9b\u5e94\u5546Id[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryElecSkuDetailRspBO queryElecSkuDetailRspBO = new QueryElecSkuDetailRspBO();
        try {
            Sku sku = this.skuMapper.selectBySkuIdAndSupplier(queryElecSkuDetailReqBO.getSkuId(), queryElecSkuDetailReqBO.getSupplierId());
            List<SkuPrice> skuPrice = this.skuPriceMapper.selectBySkuId(queryElecSkuDetailReqBO.getSkuId(), queryElecSkuDetailReqBO.getSupplierId());
            BigDecimal marketPrice = MoneyUtil.Long2BigDecimal((Long)skuPrice.get(0).getMarketPrice());
            BigDecimal agreementPrice = MoneyUtil.Long2BigDecimal((Long)skuPrice.get(0).getAgreementPrice());
            Float discountRate = Float.valueOf(marketPrice.subtract(agreementPrice).multiply(BigDecimal.valueOf(100L)).divide(marketPrice, 2, 1).floatValue());
            BeanUtils.copyProperties((Object)sku, (Object)queryElecSkuDetailRspBO);
            HashMap<String, Object> map = new HashMap<String, Object>();
            ArrayList<CelecSkuApproveLogBO> listBO = new ArrayList<CelecSkuApproveLogBO>();
            map.put("skuId", queryElecSkuDetailReqBO.getSkuId());
            map.put("supplierId", queryElecSkuDetailReqBO.getSupplierId());
            ArrayList<Long> commodityTypeIds = new ArrayList<Long>();
            commodityTypeIds.add(sku.getCommodityId());
            Map<Long, String> rspMap = null;
            if (commodityTypeIds != null) {
                rspMap = this.queryCatalogNameService.queryMdmCatalogMapByCommodityTypeId(commodityTypeIds);
            }
            List<ElecSkuApproveLogPO> list = this.celecSkuApproveLogMapper.selectListByParam(map);
            for (ElecSkuApproveLogPO logPo : list) {
                CelecSkuApproveLogBO logBO = new CelecSkuApproveLogBO();
                if (logPo.getApproveType() == 0) continue;
                BeanUtils.copyProperties((Object)logPo, (Object)logBO);
                listBO.add(logBO);
            }
            queryElecSkuDetailRspBO.setOffApproveTime(sku.getUpdateTime());
            queryElecSkuDetailRspBO.setOnApproveTime(sku.getOnShelveTime());
            queryElecSkuDetailRspBO.setDiscountRate(discountRate);
            queryElecSkuDetailRspBO.setCommodityTypeName(rspMap.get(sku.getCommodityId()));
            queryElecSkuDetailRspBO.setLogBOs(listBO);
            queryElecSkuDetailRspBO.setRespCode("0000");
            queryElecSkuDetailRspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException(null, "\u7535\u5b50\u8d85\u5e02\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u670d\u52a1\u51fa\u9519");
        }
        return queryElecSkuDetailRspBO;
    }
}

