/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.base.file.FileProcessing;
import com.cgd.commodity.busi.QryAgrDetailService;
import com.cgd.commodity.busi.bo.AgrAttach;
import com.cgd.commodity.busi.bo.agreement.QryAgrDetailReqBO;
import com.cgd.commodity.busi.bo.agreement.QryAgrDetailRspBO;
import com.cgd.commodity.busi.impl.QryAgrChangeDetailServiceImpl;
import com.cgd.commodity.busi.vo.agreement.AgreementScopeVO;
import com.cgd.commodity.dao.AgreementMajorChangeMapper;
import com.cgd.commodity.dao.AgreementScopeMapper;
import com.cgd.commodity.dao.SupplierAgreementAttachMapper;
import com.cgd.commodity.dao.SupplierAgreementMapper;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class QryAgrDetailServiceImpl
implements QryAgrDetailService {
    private static final Logger logger = LoggerFactory.getLogger(QryAgrChangeDetailServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SupplierAgreementMapper supplierAgreementMapper;
    private SupplierAgreementAttachMapper supplierAgreementAttachMapper;
    private AgreementScopeMapper agreementScopeMapper;
    private AgreementMajorChangeMapper agreementMajorChangeMapper;
    @Autowired
    private CacheClient cacheClient;

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public void setSupplierAgreementAttachMapper(SupplierAgreementAttachMapper supplierAgreementAttachMapper) {
        this.supplierAgreementAttachMapper = supplierAgreementAttachMapper;
    }

    public void setAgreementScopeMapper(AgreementScopeMapper agreementScopeMapper) {
        this.agreementScopeMapper = agreementScopeMapper;
    }

    public void setAgreementMajorChangeMapper(AgreementMajorChangeMapper agreementMajorChangeMapper) {
        this.agreementMajorChangeMapper = agreementMajorChangeMapper;
    }

    public QryAgrDetailRspBO qryAgrDetailRspBO(QryAgrDetailReqBO qryAgrDetailReqBO) {
        QryAgrDetailRspBO qryAgrDetailRspBO = new QryAgrDetailRspBO();
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u534f\u8bae\u4e3b\u4f53\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryAgrDetailRspBO.toString());
        }
        try {
            qryAgrDetailRspBO = this.supplierAgreementMapper.qryAgrDetail(qryAgrDetailReqBO.getAgrId(), qryAgrDetailReqBO.getSupplierId());
            List<AgrAttach> agrAttachs = this.supplierAgreementAttachMapper.qryAgrContractAttach(qryAgrDetailReqBO.getAgrId(), qryAgrDetailReqBO.getSupplierId());
            for (AgrAttach agrAttach : agrAttachs) {
                agrAttach.setAttachmentAddr(this.accessoryUrlSign(agrAttach.getAttachmentAddr()));
            }
            qryAgrDetailRspBO.setAgrAttachs(agrAttachs);
            List<AgrAttach> agrOtherAttachs = this.supplierAgreementAttachMapper.qryAgrContractAttach(qryAgrDetailReqBO.getAgrId(), qryAgrDetailReqBO.getSupplierId());
            for (AgrAttach agrAttach : agrOtherAttachs) {
                agrAttach.setAttachmentAddr(this.accessoryUrlSign(agrAttach.getAttachmentAddr()));
            }
            qryAgrDetailRspBO.setAgrAttachs(agrOtherAttachs);
            List<AgreementScopeVO> list = this.agreementScopeMapper.selectById(qryAgrDetailReqBO.getAgrId(), qryAgrDetailReqBO.getSupplierId(), qryAgrDetailRspBO.getScopeType());
            qryAgrDetailRspBO.setAgreementScopeVOs(list);
            qryAgrDetailRspBO = this.agreementMajorChangeMapper.qryAgrDetailById(qryAgrDetailReqBO.getAgrId(), qryAgrDetailReqBO.getSupplierId());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u534f\u8bae\u4e3b\u4f53\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u534f\u8bae\u4e3b\u4f53\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        qryAgrDetailRspBO.setRespCode("0000");
        qryAgrDetailRspBO.setRespDesc("\u6210\u529f");
        return qryAgrDetailRspBO;
    }

    private String accessoryUrlSign(String origUrl) {
        String signedUrl = (String)this.cacheClient.get(origUrl, String.class);
        if (signedUrl == null) {
            int attUrlSignExpire = 1800;
            signedUrl = FileProcessing.generatePresignedUrl((String)origUrl, (long)attUrlSignExpire);
            this.cacheClient.put(origUrl, (Object)signedUrl, attUrlSignExpire);
        }
        return signedUrl;
    }
}

