/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.base.file.FileProcessing;
import com.cgd.commodity.busi.QryAgrInfoService;
import com.cgd.commodity.busi.bo.AgrAttach;
import com.cgd.commodity.busi.bo.QryAgrInfoReqBO;
import com.cgd.commodity.busi.bo.QryAgrInfoRspBO;
import com.cgd.commodity.busi.vo.agreement.QryAgrAddPricePropRspVO;
import com.cgd.commodity.dao.AgreementAddPricePropMapper;
import com.cgd.commodity.dao.SupplierAgreementAttachMapper;
import com.cgd.commodity.dao.SupplierAgreementMapper;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class QryAgrInfoServiceImpl
implements QryAgrInfoService {
    private static final Logger logger = LoggerFactory.getLogger(QryAgrInfoServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SupplierAgreementMapper supplierAgreementMapper;
    private SupplierAgreementAttachMapper supplierAgreementAttachMapper;
    private AgreementAddPricePropMapper agreementAddPricePropMapper;
    @Autowired
    private CacheClient cacheClient;

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public void setSupplierAgreementAttachMapper(SupplierAgreementAttachMapper supplierAgreementAttachMapper) {
        this.supplierAgreementAttachMapper = supplierAgreementAttachMapper;
    }

    public void setAgreementAddPricePropMapper(AgreementAddPricePropMapper agreementAddPricePropMapper) {
        this.agreementAddPricePropMapper = agreementAddPricePropMapper;
    }

    public QryAgrInfoRspBO qryAgrInfo(QryAgrInfoReqBO qryAgrInfoReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u534f\u8bae\u4e3b\u4f53\u5185\u5bb9\u548c\u9644\u4ef6\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryAgrInfoReqBO.toString());
        }
        QryAgrInfoRspBO qryAgrInfoRspBO = new QryAgrInfoRspBO();
        try {
            qryAgrInfoRspBO = this.supplierAgreementMapper.getAgreementInfo(qryAgrInfoReqBO.getAgrId(), qryAgrInfoReqBO.getSupplierId());
            List<AgrAttach> agrAttachs = this.supplierAgreementAttachMapper.qryAgrAttach(qryAgrInfoReqBO.getAgrId(), qryAgrInfoReqBO.getSupplierId());
            for (AgrAttach agrAttach : agrAttachs) {
                agrAttach.setAttachmentAddr(this.accessoryUrlSign(agrAttach.getAttachmentAddr()));
            }
            qryAgrInfoRspBO.setAgrAttach(agrAttachs);
            List<QryAgrAddPricePropRspVO> agrAddPriceProps = this.agreementAddPricePropMapper.selectAddPriceDetailById(qryAgrInfoReqBO.getAgrId(), qryAgrInfoReqBO.getSupplierId());
            qryAgrInfoRspBO.setAgrAddPriceProps(agrAddPriceProps);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u534f\u8bae\u4e3b\u4f53\u5185\u5bb9\u548c\u9644\u4ef6\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u534f\u8bae\u4e3b\u4f53\u5185\u5bb9\u548c\u9644\u4ef6\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return qryAgrInfoRspBO;
    }

    private String accessoryUrlSign(String origUrl) {
        String signedUrl = (String)this.cacheClient.get(origUrl, String.class);
        if (signedUrl == null) {
            int attUrlSignExpire = 1800;
            signedUrl = FileProcessing.generatePresignedUrl((String)origUrl, (long)attUrlSignExpire);
            this.cacheClient.put(origUrl, (Object)signedUrl, attUrlSignExpire);
        }
        return signedUrl;
    }
}

