/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryExtSkuIdIsExistService;
import com.cgd.commodity.busi.bo.QryExtSkuIdReqBO;
import com.cgd.commodity.busi.bo.QryExtSkuIdRspBO;
import com.cgd.commodity.busi.bo.QrySkuInfoRspBO;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.po.Sku;
import com.gd.commodity.busi.vo.agreement.QryAgrSkusByAgrIdRspVO;
import com.gd.commodity.dao.CommodityMeasureMapper;
import com.gd.commodity.dao.SupplierAgreementSkuMapper;
import com.gd.commodity.po.CommodityMeasure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="qryExtSkuIdIsExistService")
public class QryExtSkuIdIsExistServiceImpl
implements QryExtSkuIdIsExistService {
    private static final Logger logger = LoggerFactory.getLogger(QryExtSkuIdIsExistServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private SupplierAgreementSkuMapper supplierAgreementSkuMapper;
    @Autowired
    private CommodityMeasureMapper commodityMeasureMapper;

    public QryExtSkuIdRspBO qryExtSkuId(QryExtSkuIdReqBO qryExtSkuIdReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5165\u53c2" + qryExtSkuIdReqBO.toString());
        }
        QryExtSkuIdRspBO qryExtSkuIdRspBO = new QryExtSkuIdRspBO();
        HashMap<String, QrySkuInfoRspBO> map = new HashMap<String, QrySkuInfoRspBO>();
        HashMap<Long, String> idMap = new HashMap<Long, String>();
        HashMap<Long, Integer> commodityMeasureMap = new HashMap<Long, Integer>();
        ArrayList<Long> skuIds = new ArrayList<Long>();
        ArrayList<Long> measureIds = new ArrayList<Long>();
        List<Object> Skus = new ArrayList();
        try {
            List<QryAgrSkusByAgrIdRspVO> qryAgrSkusByAgrIdRspVOs;
            if (qryExtSkuIdReqBO.getExtSkuIds() != null && qryExtSkuIdReqBO.getExtSkuIds().size() > 0) {
                Skus = this.skuMapper.selectByExtSkuId(qryExtSkuIdReqBO);
            } else if (qryExtSkuIdReqBO.getSkuIds() != null && qryExtSkuIdReqBO.getSkuIds().size() > 0) {
                Skus = this.skuMapper.selectBySkuId(qryExtSkuIdReqBO);
            } else {
                logger.error("\u5165\u53c2\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                qryExtSkuIdRspBO.setRespDesc("\u5931\u8d25");
                qryExtSkuIdRspBO.setRespCode("\u5165\u53c2\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            logger.debug("Skus" + Skus.toString());
            if (Skus != null && Skus.size() > 0) {
                for (Sku sku : Skus) {
                    QrySkuInfoRspBO qrySkuInfoRspBO = new QrySkuInfoRspBO();
                    BeanUtils.copyProperties((Object)sku, (Object)qrySkuInfoRspBO);
                    skuIds.add(sku.getSkuId());
                    measureIds.add(sku.getMeasureId());
                    qrySkuInfoRspBO.setSkuState(sku.getSkuStatus());
                    map.put(qrySkuInfoRspBO.getSkuId().toString(), qrySkuInfoRspBO);
                    map.put(sku.getExtSkuId(), qrySkuInfoRspBO);
                    idMap.put(sku.getSkuId(), sku.getExtSkuId());
                }
            }
            if (measureIds != null && measureIds.size() > 0) {
                List<CommodityMeasure> commodityMeasures = this.commodityMeasureMapper.selectByMeasureIds(measureIds);
                for (CommodityMeasure commodityMeasure : commodityMeasures) {
                    logger.debug("commodityMeasures\u51fa\u53c2" + commodityMeasure);
                    commodityMeasureMap.put(commodityMeasure.getMeasureId(), commodityMeasure.getMeasureType());
                }
            }
            if (skuIds != null && skuIds.size() > 0 && (qryAgrSkusByAgrIdRspVOs = this.supplierAgreementSkuMapper.selectAgrSkuId(skuIds)) != null && qryAgrSkusByAgrIdRspVOs.size() > 0) {
                for (QryAgrSkusByAgrIdRspVO qryAgrSkusByAgrIdRspVO : qryAgrSkusByAgrIdRspVOs) {
                    logger.debug("commodityMeasures\u51fa\u53c2" + qryAgrSkusByAgrIdRspVO.toString());
                    QrySkuInfoRspBO qrySkuInfoRspBO = (QrySkuInfoRspBO)map.get(qryAgrSkusByAgrIdRspVO.getSkuId().toString());
                    String extId = (String)idMap.get(qryAgrSkusByAgrIdRspVO.getSkuId());
                    QrySkuInfoRspBO qrySkuInfoExtRspBO = (QrySkuInfoRspBO)map.get(extId);
                    if (qrySkuInfoRspBO != null) {
                        qrySkuInfoRspBO.setIsAddPrice(qryAgrSkusByAgrIdRspVO.getIsAddPrice());
                        qrySkuInfoRspBO.setAgreementId(qryAgrSkusByAgrIdRspVO.getAgreementId());
                        qrySkuInfoExtRspBO.setIsAddPrice(qryAgrSkusByAgrIdRspVO.getIsAddPrice());
                        qrySkuInfoExtRspBO.setAgreementId(qryAgrSkusByAgrIdRspVO.getAgreementId());
                    }
                    qrySkuInfoExtRspBO.setMeasureType((Integer)commodityMeasureMap.get(qrySkuInfoRspBO.getMeasureId()));
                    qrySkuInfoRspBO.setMeasureType((Integer)commodityMeasureMap.get(qrySkuInfoRspBO.getMeasureId()));
                }
            }
            logger.debug("\u51fa\u53c2" + map);
            qryExtSkuIdRspBO.setQrySkuInfoRspBOMap(map);
            qryExtSkuIdRspBO.setRespDesc("\u6210\u529f");
            qryExtSkuIdRspBO.setRespCode("0000");
        }
        catch (Exception e) {
            logger.error("\u6839\u636eEXT_SKU_ID\u67e5\u8be2\u5546\u54c1\u662f\u5426\u4e0a\u67b6\u670d\u52a1", (Throwable)e);
            qryExtSkuIdRspBO.setRespDesc("\u5931\u8d25");
            qryExtSkuIdRspBO.setRespCode("8888");
        }
        return qryExtSkuIdRspBO;
    }
}

