/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QrySkusByAgrIdService;
import com.cgd.commodity.busi.bo.agreement.QrySkusByAgrIdRspBO;
import com.cgd.commodity.busi.bo.agreement.QrySkusByAgrIdrReqBO;
import com.cgd.commodity.busi.vo.agreement.QryAgrAddPricePropRspVO;
import com.cgd.commodity.busi.vo.agreement.QrySkusByAgrIdRspVO;
import com.cgd.commodity.busi.vo.agreement.SkusByAgrIdRspVO;
import com.cgd.commodity.dao.AgreementAddPricePropMapper;
import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.cgd.commodity.dao.CommodityMeasureMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SupplierAgreementSkuMapper;
import com.cgd.commodity.po.CommodityMeasure;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class QrySkusByAgrIdServiceImpl
implements QrySkusByAgrIdService {
    private static final Logger logger = LoggerFactory.getLogger(QrySkusByAgrIdServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SupplierAgreementSkuMapper supplierAgreementSkuMapper;
    private SkuMapper skuMapper;
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;
    private AgreementAddPricePropMapper agreementAddPricePropMapper;
    @Autowired
    private CommodityMeasureMapper commodityMeasureMapper;

    public void setAgreementAddPricePropMapper(AgreementAddPricePropMapper agreementAddPricePropMapper) {
        this.agreementAddPricePropMapper = agreementAddPricePropMapper;
    }

    public void setSupplierAgreementSkuMapper(SupplierAgreementSkuMapper supplierAgreementSkuMapper) {
        this.supplierAgreementSkuMapper = supplierAgreementSkuMapper;
    }

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setCommodityGuideCatalogMapper(CommodityGuideCatalogMapper commodityGuideCatalogMapper) {
        this.commodityGuideCatalogMapper = commodityGuideCatalogMapper;
    }

    public QrySkusByAgrIdRspBO qrySkusByAgrId(QrySkusByAgrIdrReqBO qrySkusByAgrIdrReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u6839\u636e\u534f\u8baeID\u67e5\u8be2\u534f\u8bae\u8be6\u60c5\u670d\u52a1\u5165\u53c2\uff1a" + qrySkusByAgrIdrReqBO.toString());
        }
        try {
            Page page;
            List<QrySkusByAgrIdRspVO> qrySkusByAgrIdRspVOs;
            List<Long> agreemetSkuIds = this.supplierAgreementSkuMapper.qryAgrSkuIdsByAgrIdAndMaterialName(qrySkusByAgrIdrReqBO.getAgreementId(), qrySkusByAgrIdrReqBO.getSupplierId(), qrySkusByAgrIdrReqBO.getMaterialId(), qrySkusByAgrIdrReqBO.getModel(), qrySkusByAgrIdrReqBO.getFigure(), qrySkusByAgrIdrReqBO.getSpec());
            RspPageBO rspPageBO = new RspPageBO();
            QrySkusByAgrIdRspBO qrySkusByAgrIdRspBO = new QrySkusByAgrIdRspBO();
            if (!agreemetSkuIds.isEmpty() && !(qrySkusByAgrIdRspVOs = this.skuMapper.qrySkuSByAgrSkuIdsAndNameStatus((Page<QrySkusByAgrIdrReqBO>)(page = new Page(qrySkusByAgrIdrReqBO.getPageNo(), qrySkusByAgrIdrReqBO.getPageSize())), agreemetSkuIds, qrySkusByAgrIdrReqBO)).isEmpty()) {
                ArrayList<Long> commodityTypeIds = new ArrayList<Long>();
                ArrayList<Long> measureIds = new ArrayList<Long>();
                for (QrySkusByAgrIdRspVO qrySkusByAgrIdRspVO : qrySkusByAgrIdRspVOs) {
                    commodityTypeIds.add(qrySkusByAgrIdRspVO.getCommodityTypeId());
                    measureIds.add(qrySkusByAgrIdRspVO.getMeasureId());
                }
                List<Map<String, Object>> catalogMaps = this.commodityGuideCatalogMapper.selectCatalogNameBatByTypeIdAndLocation(commodityTypeIds);
                List<CommodityMeasure> commodityMeasures = this.commodityMeasureMapper.selectByMeasureIds(measureIds);
                HashMap<Long, CommodityMeasure> commodityMeasureMap = new HashMap<Long, CommodityMeasure>();
                for (CommodityMeasure commodityMeasure : commodityMeasures) {
                    commodityMeasureMap.put(commodityMeasure.getMeasureId(), commodityMeasure);
                }
                List<QryAgrAddPricePropRspVO> agrAddPriceProps = this.agreementAddPricePropMapper.selectAddPriceDetailById(qrySkusByAgrIdrReqBO.getAgreementId(), qrySkusByAgrIdrReqBO.getSupplierId());
                List<SkusByAgrIdRspVO> results = this.resolveResult(qrySkusByAgrIdRspVOs, catalogMaps, commodityMeasureMap);
                rspPageBO.setRecordsTotal(page.getTotalCount());
                rspPageBO.setTotal(page.getTotalPages());
                rspPageBO.setPageNo(qrySkusByAgrIdrReqBO.getPageNo());
                rspPageBO.setRows(results);
                qrySkusByAgrIdRspBO.setAgrAddPriceProps(agrAddPriceProps);
                qrySkusByAgrIdRspBO.setSkusByAgrIdRspVOs(rspPageBO);
                return qrySkusByAgrIdRspBO;
            }
            rspPageBO.setRecordsTotal(0);
            rspPageBO.setTotal(0);
            rspPageBO.setRows(new ArrayList());
            rspPageBO.setPageNo(qrySkusByAgrIdrReqBO.getPageNo());
            qrySkusByAgrIdRspBO.setSkusByAgrIdRspVOs(rspPageBO);
            return qrySkusByAgrIdRspBO;
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u534f\u8baeID\u67e5\u8be2\u5355\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)((Object)e)).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)((Object)e)).getMsgCode();
                throw new BusinessException(resultCode, "\u6839\u636e\u534f\u8baeID\u67e5\u8be2\u5355\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1:" + e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u534f\u8baeID\u67e5\u8be2\u5355\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private List<SkusByAgrIdRspVO> resolveResult(List<QrySkusByAgrIdRspVO> qrySkusByAgrIdRspVOs, List<Map<String, Object>> catalogMaps, Map<Long, CommodityMeasure> commodityMeasureMap) {
        try {
            ArrayList<SkusByAgrIdRspVO> skusByAgrIdRspVOs = new ArrayList<SkusByAgrIdRspVO>();
            for (QrySkusByAgrIdRspVO qrySkusByAgrIdRspVO : qrySkusByAgrIdRspVOs) {
                SkusByAgrIdRspVO skusByAgrIdRspVO = new SkusByAgrIdRspVO();
                if (!catalogMaps.isEmpty()) {
                    for (Map<String, Object> map : catalogMaps) {
                        if (!map.get("commodityTypeId").equals(qrySkusByAgrIdRspVO.getCommodityTypeId())) continue;
                        skusByAgrIdRspVO.setFirstCatalogName((String)map.get("firstCatalogName"));
                        skusByAgrIdRspVO.setSecondCatalogName((String)map.get("secondCatalogName"));
                        skusByAgrIdRspVO.setThirdCatalogName((String)map.get("thirdCatalogName"));
                    }
                }
                skusByAgrIdRspVO.setMaterialId(qrySkusByAgrIdRspVO.getMaterialId());
                if (null != qrySkusByAgrIdRspVO.getSalePrice()) {
                    skusByAgrIdRspVO.setSalePrice(MoneyUtils.Long2BigDecimal((Long)qrySkusByAgrIdRspVO.getSalePrice()));
                }
                skusByAgrIdRspVO.setSkuId(qrySkusByAgrIdRspVO.getSkuId());
                skusByAgrIdRspVO.setSkuMainPicUrl(qrySkusByAgrIdRspVO.getSkuMainPicUrl());
                skusByAgrIdRspVO.setSkuName(qrySkusByAgrIdRspVO.getSkuName());
                skusByAgrIdRspVO.setSupplierId(qrySkusByAgrIdRspVO.getSupplierId());
                skusByAgrIdRspVO.setVendorId(qrySkusByAgrIdRspVO.getVendorId());
                skusByAgrIdRspVO.setModel(qrySkusByAgrIdRspVO.getModel());
                skusByAgrIdRspVO.setFigure(qrySkusByAgrIdRspVO.getFigure());
                skusByAgrIdRspVO.setSpec(qrySkusByAgrIdRspVO.getSpec());
                skusByAgrIdRspVO.setSupplyCycle(qrySkusByAgrIdRspVO.getSupplyCycle());
                skusByAgrIdRspVO.setMeasureName(qrySkusByAgrIdRspVO.getMeasureName());
                skusByAgrIdRspVO.setMeasureType(commodityMeasureMap.get(qrySkusByAgrIdRspVO.getMeasureId()).getMeasureType());
                if (2 == qrySkusByAgrIdRspVO.getSkuStatus()) {
                    skusByAgrIdRspVO.setSkuStatus(Integer.valueOf(1));
                }
                if (4 == qrySkusByAgrIdRspVO.getSkuStatus() || 5 == qrySkusByAgrIdRspVO.getSkuStatus() || 9 == qrySkusByAgrIdRspVO.getSkuStatus()) {
                    skusByAgrIdRspVO.setSkuStatus(Integer.valueOf(2));
                }
                skusByAgrIdRspVOs.add(skusByAgrIdRspVO);
            }
            return skusByAgrIdRspVOs;
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u534f\u8baeID\u67e5\u8be2\u5355\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5c01\u88c5\u54cd\u5e94\u6570\u636e\u5931\u8d25" + e);
            throw new BusinessException(null, "\u5c01\u88c5\u54cd\u5e94\u6570\u636e\u5931\u8d25");
        }
    }
}

