/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.SkuOffShelfService;
import com.cgd.commodity.busi.bo.SkuOffShelfReqBO;
import com.cgd.commodity.busi.bo.SkuOffShelfRspBO;
import com.cgd.commodity.busi.vo.SkuHandOffShelfVO;
import com.cgd.commodity.constant.Constant;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SkuOffShelveLogMapper;
import com.cgd.commodity.dao.SkuOnShelveLogMapper;
import com.cgd.commodity.po.Sku;
import com.cgd.commodity.po.SkuOffShelveLog;
import com.cgd.workflow.bo.BpmStartBatchReqBO;
import com.cgd.workflow.bo.BpmStartBatchRspBO;
import com.cgd.workflow.bo.BpmStartBatchVO;
import com.cgd.workflow.bo.BpmStartReqBO;
import com.cgd.workflow.busin.service.BpmStartBatchBusinService;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class SkuOffShelfServiceImpl
implements SkuOffShelfService {
    private static final Logger logger = LoggerFactory.getLogger(SkuOffShelfServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private BpmStartBatchBusinService bpmStartBatchBusinService;
    @Autowired
    private SkuOffShelveLogMapper skuOffShelveLogMapper;
    @Autowired
    private SkuOnShelveLogMapper skuOnShelveLogMapper;

    public SkuOffShelfRspBO skuoffShelf(SkuOffShelfReqBO skuOffShelfReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5546\u54c1\u4e0b\u67b6\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + skuOffShelfReqBO.toString());
        }
        if (null == skuOffShelfReqBO.getUserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u4e0b\u67b6\u4e1a\u52a1\u670d\u52a1\u7528\u6237ID[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SkuOffShelfRspBO rsp = new SkuOffShelfRspBO();
        try {
            List skuIdList = skuOffShelfReqBO.getSkuIdList();
            LinkedList<BpmStartReqBO> bpmStartReqBOS = new LinkedList<BpmStartReqBO>();
            BpmStartReqBO bpmStartReqBO = null;
            HashMap<String, Object> variables = null;
            HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
            Map<String, Object> resultMap = null;
            Sku sku = null;
            HashMap<Long, Sku> skuIdAndSkuMap = new HashMap<Long, Sku>();
            if (skuIdList != null && skuIdList.size() > 0) {
                for (Long skuId : skuIdList) {
                    sku = this.skuMapper.selectBySkuIdAndSupplier(skuId, skuOffShelfReqBO.getSupplierId());
                    if (sku == null) {
                        throw new BusinessException(null, "\u5546\u54c1[" + skuId + "]\u4e0d\u5b58\u5728");
                    }
                    if (this.skuOnShelveLogMapper.checkSkuApproveOnWay(skuId, skuOffShelfReqBO.getSupplierId()) > 0) {
                        throw new BusinessException(null, "\u5546\u54c1[" + skuId + "]\u72b6\u6001\u6b63\u5904\u4e8e\u5ba1\u6838\u4e2d\uff0c\u8bf7\u7b49\u5f85\u5ba1\u6838\u7ed3\u679c");
                    }
                    if (sku.getSkuStatus() != null && sku.getSkuStatus() != 2) {
                        throw new BusinessException(null, "\u6240\u9009\u5546\u54c1[" + skuId + "]\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u8bf7\u8fd4\u56de\u91cd\u65b0\u9009\u62e9");
                    }
                    skuIdAndSkuMap.put(skuId, sku);
                    bpmStartReqBO = new BpmStartReqBO();
                    variables = new HashMap<String, Object>();
                    bpmStartReqBO.setApplyerId(skuOffShelfReqBO.getUserId());
                    bpmStartReqBO.setBusinessTitle("\u4e0b\u67b6");
                    bpmStartReqBO.setBusinessType("11");
                    bpmStartReqBO.setBusinessId(String.valueOf(skuId));
                    bpmStartReqBO.setDetailUrl("11");
                    bpmStartReqBO.setStartFlag("1");
                    variables.put("supplierId", skuOffShelfReqBO.getSupplierId());
                    variables.put("userId", skuOffShelfReqBO.getUserId());
                    variables.put("skuId", skuId);
                    variables.put("approveType", "11");
                    variables.put("agreementId", skuOffShelfReqBO.getAgreementId());
                    variables.put("agrLocation", sku.getSkuLocation());
                    variables.put("userName", skuOffShelfReqBO.getUserName());
                    resultMap = this.skuMapper.selectById(skuId, skuOffShelfReqBO.getSupplierId());
                    variables.put("agreementSkuId", resultMap.get("AGREEMENT_SKU_ID"));
                    bpmStartReqBO.setVariables(variables);
                    bpmStartReqBOS.add(bpmStartReqBO);
                    resultMap.put("SUPPLIER_ID", skuOffShelfReqBO.getSupplierId());
                    map.put(String.valueOf(skuId), resultMap);
                }
            } else {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u4fe1\u606f\u96c6\u5408[skus]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bpmStartReqBOS.size() > 0) {
                BpmStartBatchReqBO bpmStartBatchReqBO = new BpmStartBatchReqBO();
                bpmStartBatchReqBO.setBpmStartReqBOS(bpmStartReqBOS);
                bpmStartBatchReqBO.setUserId(skuOffShelfReqBO.getUserId());
                BpmStartBatchRspBO bpmStartBatchRspBO = this.bpmStartBatchBusinService.bpmStartBatch(bpmStartBatchReqBO);
                if (bpmStartBatchRspBO == null) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8c03\u7528\u6279\u91cf\u542f\u52a8\u5de5\u4f5c\u6d41\u4e1a\u52a1\u670d\u52a1\u3010BpmStartBatchBusinService\u3011\u51fa\u9519:\u65e0\u5e94\u7b54\uff01");
                }
                if (!"0000".equals(bpmStartBatchRspBO.getRespCode())) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8c03\u7528\u6279\u91cf\u542f\u52a8\u5de5\u4f5c\u6d41\u4e1a\u52a1\u670d\u52a1\u3010BpmStartBatchBusinService\u3011\u51fa\u9519:" + bpmStartBatchRspBO.getRespDesc());
                }
                List bpmStartBatchVOs = bpmStartBatchRspBO.getBpmStartBatchVOs();
                if (bpmStartBatchVOs.size() > 0) {
                    ArrayList<SkuOffShelveLog> logs = new ArrayList<SkuOffShelveLog>();
                    SkuOffShelveLog skuOffShelveLog = null;
                    Byte approveType = 1;
                    Byte isDelete = 0;
                    Date createTime = new Date();
                    Map resMap = null;
                    Long agreementId = 0L;
                    Long agreementSkuId = 0L;
                    Long supplierId = 0L;
                    SkuHandOffShelfVO skuHandOffShelfVO = new SkuHandOffShelfVO();
                    ArrayList<Long> skuIds = new ArrayList<Long>();
                    for (BpmStartBatchVO resvo : bpmStartBatchVOs) {
                        Long businessId = resvo.getBusinessId();
                        String procinstId = resvo.getProcinstId();
                        skuOffShelveLog = new SkuOffShelveLog();
                        skuOffShelveLog.setProcInstlId(procinstId);
                        skuOffShelveLog.setSkuId(businessId);
                        skuOffShelveLog.setApproveType(approveType);
                        skuOffShelveLog.setIsDelete(isDelete);
                        resMap = (Map)map.get(String.valueOf(businessId));
                        if (resMap != null) {
                            if (null != resMap.get("AGREEMENT_ID")) {
                                agreementId = (Long)resMap.get("AGREEMENT_ID");
                            }
                            if (null != resMap.get("AGREEMENT_SKU_ID")) {
                                agreementSkuId = (Long)resMap.get("AGREEMENT_SKU_ID");
                            }
                            supplierId = (Long)resMap.get("SUPPLIER_ID");
                        }
                        skuOffShelveLog.setAgreementId(agreementId);
                        skuOffShelveLog.setAgreementSkuId(agreementSkuId);
                        skuOffShelveLog.setSupplierId(supplierId);
                        skuOffShelveLog.setCreateLoginId(skuOffShelfReqBO.getUserId());
                        skuOffShelveLog.setCreateLoginName(skuOffShelfReqBO.getUserName());
                        skuOffShelveLog.setCreateTime(createTime);
                        skuOffShelveLog.setSoldOutReason(skuOffShelfReqBO.getSoldOutReason());
                        skuOffShelveLog.setSkuLocation(Byte.valueOf(((Sku)skuIdAndSkuMap.get(businessId)).getSkuLocation().toString()));
                        logs.add(skuOffShelveLog);
                        skuIds.add(businessId);
                    }
                    skuHandOffShelfVO.setSupplierId(supplierId);
                    skuHandOffShelfVO.setSkuIds(skuIds);
                    this.skuMapper.updateSkuStateOffShelfBySkuId(Constant.SKU_STATUS_FROZEN, skuOffShelfReqBO.getUserId(), skuHandOffShelfVO);
                    this.skuOffShelveLogMapper.batchSkuOffShelveLog(logs);
                } else if (bpmStartBatchVOs == null || bpmStartBatchVOs != null && bpmStartBatchVOs.size() == 0) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8c03\u7528\u6279\u91cf\u542f\u52a8\u5de5\u4f5c\u6d41\u4e1a\u52a1\u670d\u52a1\u3010BpmStartBatchBusinService\u3011\u672a\u8fd4\u56de\u6d41\u7a0b\u5b9e\u4f8b\u4fe1\u606f\uff01");
                }
            }
            rsp.setFailCount(Integer.valueOf(0));
            rsp.setRespDesc("\u4e0b\u67b6\u6210\u529f");
            rsp.setSuccessCount(Integer.valueOf(skuIdList.size()));
            rsp.setTotalCount(Integer.valueOf(skuIdList.size()));
            return rsp;
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u4e0b\u67b6\u4e1a\u52a1\u670d\u52a1\u51fa\u9519\uff1a" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)((Object)e)).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)((Object)e)).getMsgCode();
                throw new BusinessException(resultCode, e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u4e0b\u67b6\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }
}

