/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.util;

import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.cgd.commodity.dao.CommodityTypeMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SkuPriceMapper;
import com.cgd.commodity.dao.SkuSpecMapper;
import com.cgd.commodity.po.CommodityGuideCatalog;
import com.cgd.commodity.po.CommodityType;
import com.cgd.commodity.po.Sku;
import com.cgd.commodity.po.SkuPrice;
import com.cgd.commodity.po.SkuSpec;
import com.cgd.commodity.util.SpringContextUtil;
import com.ohaotian.plugin.es.builder.batch.BatchInsertRequestBuilderAdapter;
import com.ohaotian.plugin.es.builder.insert.InsertBuilder;
import com.ohaotian.plugin.es.builder.insert.InsertBuilderItem;
import com.ohaotian.plugin.es.builder.insert.InsertRequestBuilder;
import com.ohaotian.plugin.es.builder.insert.InsertRequestBuilderAdapter;
import com.ohaotian.plugin.es.builder.schema.Nested;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class TriggerInsertOsSkuThread
extends Thread {
    @Autowired
    InsertRequestBuilderAdapter insertRequestBuilderAdapter;
    public List<String> skuIds;

    public List<String> getSkuIds() {
        return this.skuIds;
    }

    public void setSkuIds(List<String> skuIds) {
        this.skuIds = skuIds;
    }

    @Override
    public void run() {
        InsertRequestBuilderAdapter insertAdapter = (InsertRequestBuilderAdapter)SpringContextUtil.getBean("insertRequestBuilderAdapter");
        BatchInsertRequestBuilderAdapter batchAdapter = (BatchInsertRequestBuilderAdapter)SpringContextUtil.getBean("batchInsertRequestBuilderAdapter");
        SkuMapper skuMapper = (SkuMapper)SpringContextUtil.getBean("skuMapper");
        SkuPriceMapper skuPriceMapper = (SkuPriceMapper)SpringContextUtil.getBean("skuPriceMapper");
        CommodityTypeMapper comTypeMapper = (CommodityTypeMapper)SpringContextUtil.getBean("commodityTypeMapper");
        CommodityGuideCatalogMapper comGuideCatMapper = (CommodityGuideCatalogMapper)SpringContextUtil.getBean("commodityGuideCatalogMapper");
        SkuSpecMapper skuSpecMapper = (SkuSpecMapper)SpringContextUtil.getBean("skuSpecMapper");
        List<String> skuIds = this.skuIds;
        System.out.println(skuIds.get(0));
        LinkedList<InsertBuilderItem> skusForOS = new LinkedList<InsertBuilderItem>();
        for (int i = 0; i < skuIds.size(); ++i) {
            Long catelogId;
            CommodityGuideCatalog singleComGuideCatl3;
            Long comTypeId;
            CommodityType singleComType;
            SkuPrice singleSkuPrice;
            Long singleSkuId = Long.valueOf(skuIds.get(i));
            Sku singleSku = skuMapper.selectByPrimaryKey(singleSkuId);
            if (singleSku == null || (singleSkuPrice = skuPriceMapper.selectBySkuId(singleSkuId, 1L).get(0)) == null || (singleComType = comTypeMapper.selectByPrimaryKey(comTypeId = singleSku.getCommodityTypeId())) == null || (singleComGuideCatl3 = comGuideCatMapper.selectByPrimaryKey(catelogId = singleComType.getCatalogId())) == null) continue;
            String l3CatCode = singleComGuideCatl3.getCatalogCode();
            CommodityGuideCatalog singleComGuideCatl2 = comGuideCatMapper.selectByPrimaryKey(singleComGuideCatl3.getUpperCatalogId());
            if (singleComGuideCatl2 == null) continue;
            String l2CatCode = singleComGuideCatl2.getCatalogCode();
            Long supplierId = singleSku.getSupplierId();
            Long comId = singleSku.getCommodityId();
            List<SkuSpec> skuSpecs = skuSpecMapper.selectBySkuIdAndSupplierIdAndCommodityId(singleSkuId, comId, supplierId);
            Nested nst = Nested.newNested();
            String nstStr = "";
            for (int j = 0; j < skuSpecs.size(); ++j) {
                SkuSpec singleSpec = skuSpecs.get(j);
                String id = String.valueOf(singleSpec.getCommoditySpecId());
                String name = singleSpec.getPropName().split("-")[1];
                String value = singleSpec.getPropValue();
                nst.addRow(id + "-" + name + "-" + value);
                nstStr = nstStr + id + "-" + name + "-" + value;
            }
            InsertBuilder insertBuilder = InsertBuilder.newBuilder((InsertRequestBuilder)insertAdapter.requestBuilder(), (String)"d_sku", (String)String.valueOf(i + 1));
            insertBuilder.columnValueBuilder().addField("sku_id", singleSku.getSkuId()).addField("sku_name", singleSku.getSkuName()).addField("brand_id", singleSku.getBrandId()).addField("brand_name", singleSku.getBrandName()).addField("supplier_id", singleSku.getSupplierId()).addField("supplier_name", singleSku.getSupplierName()).addField("commodity_id", singleSku.getCommodityId()).addField("picture_url", singleSku.getSkuMainPicUrl()).addField("ext_sku_id", singleSku.getExtSkuId()).addField("sku_location", singleSku.getSkuLocation()).addField("sale_area", "0").addField("type_id", singleSku.getCommodityTypeId()).addField("type_name", singleComType.getCommodityTypeName()).addField("upc", singleSku.getUpcCode()).addField("sku_status", singleSku.getSkuStatus()).addField("l2_category_id", l3CatCode).addField("l3_category_id", l2CatCode).addField("discount_rate", Long.valueOf(singleSkuPrice.getMarketPrice() == 0L ? 0L : singleSkuPrice.getSalePrice() / singleSkuPrice.getMarketPrice())).addField("sale_price", singleSkuPrice.getSalePrice()).addField("market_price", singleSkuPrice.getMarketPrice()).addField("agreement_price", singleSkuPrice.getAgreementPrice()).addField("member_price", singleSkuPrice.getMemberPrice()).addField("properties", nst).addField("description", nstStr);
            InsertBuilderItem singleSKUInfoForOS = insertBuilder.build();
            skusForOS.add(singleSKUInfoForOS);
            if (i % 500 != 0 || i == 0) continue;
            System.out.println(i * 500);
            batchAdapter.requestBuilder().bulk(skusForOS);
        }
    }
}

