/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.BatchMdmQryCatalogNameService;
import com.cgd.commodity.busi.bo.MdmQryCatalogNameReqBO;
import com.cgd.commodity.busi.bo.MdmQryCatalogNameRspBO;
import com.cgd.commodity.busi.impl.MdmQryCatalogNameServiceImpl;
import com.cgd.commodity.busi.vo.MdmQryCatalogNameRspVO;
import com.cgd.commodity.dao.MdmCatalogMapper;
import com.cgd.commodity.po.MdmCatalogPO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class BatchMdmQryCatalogNameServiceImpl
implements BatchMdmQryCatalogNameService {
    private static final Logger logger = LoggerFactory.getLogger(MdmQryCatalogNameServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private MdmCatalogMapper mdmCatalogMapper;
    private CacheClient cacheClient;

    public MdmQryCatalogNameRspBO batchQryCatalogName(MdmQryCatalogNameReqBO mdmQryCatalogNameReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u4e3b\u6570\u636e\u5206\u7c7b\u540d\u79f0\u67e5\u8be2\u670d\u52a1\u5165\u53c2\uff1a" + mdmQryCatalogNameReqBO.toString());
        }
        MdmQryCatalogNameRspBO rspBO = new MdmQryCatalogNameRspBO();
        MdmQryCatalogNameRspVO rspVO = new MdmQryCatalogNameRspVO();
        try {
            List<Integer> catalogLevels = BatchMdmQryCatalogNameServiceImpl.initCataLevels(mdmQryCatalogNameReqBO.getIds());
            for (Integer catalogLevel : catalogLevels) {
                if (catalogLevel >= 0) continue;
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5206\u7c7b\u7f16\u7801\u4e0d\u5408\u6cd5");
                return rspBO;
            }
            MdmQryCatalogNameRspVO cacheRspVO = null;
            if (this.cacheClient.get("IDS" + mdmQryCatalogNameReqBO.getIds()) != null) {
                cacheRspVO = (MdmQryCatalogNameRspVO)this.cacheClient.get("IDS" + mdmQryCatalogNameReqBO.getIds());
            }
            if (null == cacheRspVO) {
                List<MdmCatalogPO> catalogPOs = this.mdmCatalogMapper.selectByCatalogIds(mdmQryCatalogNameReqBO.getIds());
                ArrayList<MdmQryCatalogNameRspVO> mdmQryCatalogNameRspVOs = new ArrayList<MdmQryCatalogNameRspVO>();
                for (MdmCatalogPO mdmCatalogPO : catalogPOs) {
                    MdmQryCatalogNameRspVO vo = new MdmQryCatalogNameRspVO();
                    BeanUtils.copyProperties((Object)mdmCatalogPO, (Object)vo);
                    mdmQryCatalogNameRspVOs.add(vo);
                }
                rspBO.setMdmQryCatalogNameRspVOs(mdmQryCatalogNameRspVOs);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
            } else {
                rspBO.setMdmQryCatalogNameRspVO(cacheRspVO);
            }
            return rspBO;
        }
        catch (Exception e) {
            rspBO.setRespDesc("\u4e3b\u6570\u636e\u5206\u7c7b\u540d\u79f0\u67e5\u8be2\u670d\u52a1\u51fa\u9519");
            rspBO.setRespCode("8888");
            logger.error("\u4e3b\u6570\u636e\u5206\u7c7b\u540d\u79f0\u67e5\u8be2\u670d\u52a1\u51fa\u9519", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e3b\u6570\u636e\u5206\u7c7b\u540d\u79f0\u67e5\u8be2\u670d\u52a1\u51fa\u9519");
        }
    }

    private static List<Integer> initCataLevels(List<Long> Ids) {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        for (Long id : Ids) {
            int catalogIdLength = String.valueOf(id).length();
            switch (catalogIdLength) {
                case 2: {
                    intList.add(1);
                }
                case 4: {
                    intList.add(2);
                }
                case 6: {
                    intList.add(3);
                }
                case 9: {
                    intList.add(4);
                }
            }
            intList.add(-1);
        }
        return intList;
    }

    public void setMdmCatalogMapper(MdmCatalogMapper mdmCatalogMapper) {
        this.mdmCatalogMapper = mdmCatalogMapper;
    }

    public void setCacheClient(CacheClient cacheClient) {
        this.cacheClient = cacheClient;
    }
}

