/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QrySkuApproveLogAgrService;
import com.cgd.commodity.busi.bo.supply.QrySkuApproveLogAgrReqBO;
import com.cgd.commodity.busi.bo.supply.QrySkuApproveLogAgrRspBO;
import com.cgd.commodity.dao.AgreementScopeMapper;
import com.cgd.commodity.dao.SupplierAgreementMapper;
import com.cgd.common.loader.perms.DataPermissionBean;
import com.cgd.common.loader.perms.PermissionCacheService;
import com.cgd.user.userInfo.busi.CheckoutUserAuthorityService;
import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdAndCompIdBusiService;
import com.cgd.user.userInfo.busi.bo.CheckoutUserAuthorityReqBO;
import com.cgd.user.userInfo.busi.bo.CheckoutUserAuthorityRspBO;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdAndCompIdReqBO;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdAndCompIdRspBO;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class QrySkuApproveLogAgrServiceImpl
implements QrySkuApproveLogAgrService {
    private static final Logger logger = LoggerFactory.getLogger(QrySkuApproveLogAgrServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SupplierAgreementMapper supplierAgreementMapper;
    @Autowired
    private SelectUserInfoByUserIdAndCompIdBusiService selectUserInfoByUserIdAndCompIdBusiService;
    @Autowired
    private AgreementScopeMapper agreementScopeMapper;
    @Autowired
    private CheckoutUserAuthorityService checkoutUserAuthorityService;
    @Autowired
    private PermissionCacheService permissionCacheService;
    @Value(value="${DISTRIBUTION_MANAGER_RODE_ID}")
    private Long DISTRIBUTION_MANAGER_RODE_ID;

    public RspPageBO<QrySkuApproveLogAgrRspBO> qrySkuApproveLogAgr(QrySkuApproveLogAgrReqBO qrySkuApproveLogAgrReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u6709\u5546\u54c1\u5ba1\u6279\u8bb0\u5f55\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qrySkuApproveLogAgrReqBO.toString());
        }
        RspPageBO rsp = new RspPageBO();
        try {
            Set authorisedOrgIds;
            DataPermissionBean dataPermission;
            CheckoutUserAuthorityReqBO checkoutUserAuthorityReqBO = new CheckoutUserAuthorityReqBO();
            checkoutUserAuthorityReqBO.setUserId(qrySkuApproveLogAgrReqBO.getUserId());
            checkoutUserAuthorityReqBO.setRoleId(this.DISTRIBUTION_MANAGER_RODE_ID);
            CheckoutUserAuthorityRspBO checkoutUserAuthorityRspBO = this.checkoutUserAuthorityService.checkoutUserAuthority(checkoutUserAuthorityReqBO);
            Long supplierId = null;
            if ("0".equals(qrySkuApproveLogAgrReqBO.getIsprofess())) {
                supplierId = qrySkuApproveLogAgrReqBO.getCompanyId();
            }
            if ((dataPermission = this.permissionCacheService.getDataPermission(PermissionCacheService.ResrcCode.skuAuditing, qrySkuApproveLogAgrReqBO.getUserId())) != null && (authorisedOrgIds = dataPermission.getAuthorisedOrgIds()) != null && !authorisedOrgIds.isEmpty()) {
                ArrayList deptIds = new ArrayList(authorisedOrgIds);
                qrySkuApproveLogAgrReqBO.setVendorDepartmentIds(deptIds);
            }
            List<Long> agreementIds = this.getAgreementIds(supplierId, qrySkuApproveLogAgrReqBO.getUserId());
            Page page = new Page(qrySkuApproveLogAgrReqBO.getPageNo(), qrySkuApproveLogAgrReqBO.getPageSize());
            if (!agreementIds.isEmpty()) {
                List<QrySkuApproveLogAgrRspBO> results = this.supplierAgreementMapper.qryAgrListByIds((Page<QrySkuApproveLogAgrReqBO>)page, qrySkuApproveLogAgrReqBO, agreementIds, supplierId);
                rsp.setRecordsTotal(page.getTotalCount());
                rsp.setTotal(page.getTotalPages());
                rsp.setRows(results);
                return rsp;
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6709\u5546\u54c1\u5ba1\u6279\u8bb0\u5f55\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u6709\u5546\u54c1\u5ba1\u6279\u8bb0\u5f55\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
        return rsp;
    }

    private List<Long> getAgreementIds(Long supplierId, Long userId) {
        try {
            ArrayList<Long> agreementIds = new ArrayList();
            agreementIds = this.supplierAgreementMapper.qryAgrIdBySupplierId(supplierId);
            return agreementIds;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6709\u5546\u54c1\u5ba1\u6279\u8bb0\u5f55\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u6839\u636e\u94fa\u8d27\u5546ID\u83b7\u53d6\u534f\u8baeID\u96c6\u5408\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u6839\u636e\u94fa\u8d27\u5546ID\u83b7\u53d6\u534f\u8baeID\u96c6\u5408\u5931\u8d25");
        }
    }

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public void setSelectUserInfoByUserIdAndCompIdBusiService(SelectUserInfoByUserIdAndCompIdBusiService selectUserInfoByUserIdAndCompIdBusiService) {
        this.selectUserInfoByUserIdAndCompIdBusiService = selectUserInfoByUserIdAndCompIdBusiService;
    }

    public void setAgreementScopeMapper(AgreementScopeMapper agreementScopeMapper) {
        this.agreementScopeMapper = agreementScopeMapper;
    }

    private SelectUserInfoByUserIdAndCompIdRspBO getUserSupplierId(Long userId) {
        try {
            SelectUserInfoByUserIdAndCompIdReqBO selectUserInfoAndCompIdReqBO = new SelectUserInfoByUserIdAndCompIdReqBO();
            selectUserInfoAndCompIdReqBO.setUserId(userId);
            SelectUserInfoByUserIdAndCompIdRspBO selectUserInfoByUserIdAndCompIdRspBO = this.selectUserInfoByUserIdAndCompIdBusiService.selectUserInfoByUserIdAndCompId(selectUserInfoAndCompIdReqBO);
            if ("0000".equals(selectUserInfoByUserIdAndCompIdRspBO.getRespCode())) {
                return selectUserInfoByUserIdAndCompIdRspBO;
            }
            return null;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u542f\u7528\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u6839\u636e\u7528\u6237\u67e5\u94fa\u8d27\u5355\u4f4d\u4fe1\u606f\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u6839\u636e\u7528\u6237\u67e5\u94fa\u8d27\u5355\u4f4d\u4fe1\u606f\u5931\u8d25");
        }
    }
}

