/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.cgd.commodity.atom.GenerateSkuPicSeqService;
import com.cgd.commodity.atom.bo.GenerateSkuPicSeqRspBO;
import com.cgd.commodity.busi.UpdateSupplySkuInfoService;
import com.cgd.commodity.busi.bo.supply.UpdateSupplySkuInfoReqBO;
import com.cgd.commodity.busi.bo.supply.UpdateSupplySkuInfoRspBO;
import com.cgd.commodity.busi.vo.supply.UpdateSupplySkuPicReqVO;
import com.cgd.commodity.constant.Constant;
import com.cgd.commodity.constant.SupplyConstant;
import com.cgd.commodity.dao.ExtSkuConversionMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SkuOnShelveLogMapper;
import com.cgd.commodity.dao.SkuPicMapper;
import com.cgd.commodity.dao.SkuPriceMapper;
import com.cgd.commodity.dao.SupplierAgreementSkuMapper;
import com.cgd.commodity.po.ExtSkuConversion;
import com.cgd.commodity.po.Sku;
import com.cgd.commodity.po.SkuOnShelveLog;
import com.cgd.commodity.po.SkuPic;
import com.cgd.commodity.po.SkuPrice;
import com.cgd.commodity.po.SupplierAgreementSku;
import com.cgd.workflow.bo.BpmStartReqBO;
import com.cgd.workflow.bo.BpmStartRspBO;
import com.cgd.workflow.busin.service.BpmStartBusinService;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.StringUtils;

public class UpdateSupplySkuInfoServiceImpl
implements UpdateSupplySkuInfoService {
    private static final Logger logger = LoggerFactory.getLogger(UpdateSupplySkuInfoServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;
    private GenerateSkuPicSeqService generateSkuPicSeqService;
    private SkuPicMapper skuPicMapper;
    private BpmStartBusinService bpmStartBusinService;
    private SkuPriceMapper skuPriceMapper;
    private SkuOnShelveLogMapper skuOnShelveLogMapper;
    @Resource(name="transactionManager")
    private DataSourceTransactionManager transactionManager;
    @Autowired
    private ExtSkuConversionMapper extSkuConversionMapper;
    @Autowired
    private SupplierAgreementSkuMapper supplierAgreementSkuMapper;

    public void setSkuOnShelveLogMapper(SkuOnShelveLogMapper skuOnShelveLogMapper) {
        this.skuOnShelveLogMapper = skuOnShelveLogMapper;
    }

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setGenerateSkuPicSeqService(GenerateSkuPicSeqService generateSkuPicSeqService) {
        this.generateSkuPicSeqService = generateSkuPicSeqService;
    }

    public void setSkuPicMapper(SkuPicMapper skuPicMapper) {
        this.skuPicMapper = skuPicMapper;
    }

    public void setBpmStartBusinService(BpmStartBusinService bpmStartBusinService) {
        this.bpmStartBusinService = bpmStartBusinService;
    }

    public void setSkuPriceMapper(SkuPriceMapper skuPriceMapper) {
        this.skuPriceMapper = skuPriceMapper;
    }

    public UpdateSupplySkuInfoRspBO updateSupplySkuInfo(UpdateSupplySkuInfoReqBO updateSupplySkuInfoReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5546\u54c1\u66f4\u65b0\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + updateSupplySkuInfoReqBO.toString());
        }
        try {
            Sku oldSku = this.skuMapper.selectBySkuIdAndSupplierId(updateSupplySkuInfoReqBO.getSkuId(), updateSupplySkuInfoReqBO.getSupplierId());
            if (null != oldSku) {
                this.updateSku(updateSupplySkuInfoReqBO, oldSku);
                this.updateSkuPic(updateSupplySkuInfoReqBO, oldSku);
                this.updateSkuPrice(updateSupplySkuInfoReqBO, oldSku);
                DefaultTransactionDefinition def = new DefaultTransactionDefinition();
                def.setPropagationBehavior(3);
                TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
                try {
                    this.updateSkuConversion(oldSku, updateSupplySkuInfoReqBO);
                    this.transactionManager.commit(status);
                }
                catch (Exception e) {
                    this.transactionManager.rollback(status);
                    throw new BusinessException("RSP_CODE_THREE_DATA_NULL", "\u6cb9\u54c1\u6570\u636e\u65b0\u589e\u5931\u8d25\uff0c", (Throwable)e);
                }
                if (0 == updateSupplySkuInfoReqBO.getOperateType().intValue()) {
                    this.skuOnShelveApprove(updateSupplySkuInfoReqBO, oldSku.getSkuId(), oldSku);
                }
                UpdateSupplySkuInfoRspBO updateSupplySkuInfoRspBO = new UpdateSupplySkuInfoRspBO();
                updateSupplySkuInfoRspBO.setIsSuccess(Boolean.valueOf(true));
                updateSupplySkuInfoRspBO.setResltMsg("\u66f4\u65b0\u6210\u529f");
                updateSupplySkuInfoRspBO.setSkuId(updateSupplySkuInfoReqBO.getSkuId());
                updateSupplySkuInfoRspBO.setSupplierId(updateSupplySkuInfoReqBO.getSupplierId());
                return updateSupplySkuInfoRspBO;
            }
            if (this.isDebugEnabled) {
                logger.debug("\u5546\u54c1\u66f4\u65b0\u4e1a\u52a1\u670d\u52a1\u6839\u636eSKUID\u67e5\u8be2SKU\u4e0d\u5b58\u5728");
            }
            throw new BusinessException("RSP_CODE_SKU_NOT_EXIST", "\u6839\u636eSKUID\u67e5\u8be2SKU\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u66f4\u65b0\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)((Object)e)).getMsgCode()) ? "CREATE_SKU_SERVICE_RSP_FAIL" : ((BusinessException)((Object)e)).getMsgCode();
                throw new BusinessException(resultCode, "\u5546\u54c1\u66f4\u65b0\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u66f4\u65b0\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private void updateSkuConversion(Sku oldSku, UpdateSupplySkuInfoReqBO updateSupplySkuInfoReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u63d2\u5165\u6cb9\u54c1\u5b57\u6bb5\u670d\u52a1\u5165\u53c2\uff1a" + updateSupplySkuInfoReqBO.toString() + "sku==" + oldSku.toString());
        }
        try {
            ExtSkuConversion extSkuConversion = this.extSkuConversionMapper.selectBySkuId(oldSku.getSkuId());
            ExtSkuConversion sc = new ExtSkuConversion();
            sc.setSkuId(oldSku.getSkuId());
            sc.setSupplierId(oldSku.getSupplierId());
            sc.setSaleunit(updateSupplySkuInfoReqBO.getSaleunit());
            sc.setSettlerate(updateSupplySkuInfoReqBO.getSettlerate());
            sc.setSettleunit(updateSupplySkuInfoReqBO.getSettleunit());
            sc.setWarenum(updateSupplySkuInfoReqBO.getWarenum());
            sc.setUpdateTime(new Date());
            if (updateSupplySkuInfoReqBO.getIsShowSpec() == 1) {
                sc.setIsShowSpec((byte)1);
            } else {
                sc.setIsShowSpec((byte)0);
            }
            sc.setUpdateLoginId(updateSupplySkuInfoReqBO.getUserId());
            logger.debug("\u63d2\u5165\u6cb9\u54c1\u5b57\u6bb5\u670d\u52a1\u5165\u53c2\uff1a" + sc.toString());
            if (extSkuConversion != null) {
                if (updateSupplySkuInfoReqBO.getIsShowSpec() == 1) {
                    sc.setConversionId(extSkuConversion.getConversionId());
                    this.extSkuConversionMapper.updateByPrimaryKeySelective(sc);
                } else {
                    this.extSkuConversionMapper.deleteByPrimaryKey(extSkuConversion.getConversionId());
                }
            } else if (updateSupplySkuInfoReqBO.getIsShowSpec() == 1) {
                sc.setType(0L);
                this.extSkuConversionMapper.insertSelective(sc);
            }
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u6cb9\u54c1\u5b57\u6bb5\u5931\u8d25", (Throwable)e);
            throw new BusinessException(null, "\u66f4\u65b0\u5b57\u6bb5\u5931\u8d25");
        }
    }

    private void updateSku(UpdateSupplySkuInfoReqBO updateSupplySkuInfoReqBO, Sku oldSku) {
        try {
            Sku sku = new Sku();
            sku.setSkuId(oldSku.getSkuId());
            sku.setSupplierId(oldSku.getSupplierId());
            Boolean updateFlag = false;
            if (!StringUtils.isEmpty((Object)oldSku.getSkuName()) && !oldSku.getSkuName().equals(updateSupplySkuInfoReqBO.getSkuName())) {
                sku.setSkuName(updateSupplySkuInfoReqBO.getSkuName());
                updateFlag = true;
            }
            String picUrl = null;
            if (!updateSupplySkuInfoReqBO.getSkuPics().isEmpty()) {
                for (UpdateSupplySkuPicReqVO updateSupplySkuPicReqVO : updateSupplySkuInfoReqBO.getSkuPics()) {
                    if (null == updateSupplySkuPicReqVO.getIsPrimary() || 1 != updateSupplySkuPicReqVO.getIsPrimary().intValue()) continue;
                    picUrl = updateSupplySkuPicReqVO.getSkuPicUrl();
                    break;
                }
            }
            if (!StringUtils.isEmpty((Object)oldSku.getSkuMainPicUrl())) {
                if (!oldSku.getSkuMainPicUrl().equals(picUrl)) {
                    sku.setSkuMainPicUrl(picUrl);
                    updateFlag = true;
                }
            } else {
                sku.setSkuMainPicUrl(picUrl);
                updateFlag = true;
            }
            if (!StringUtils.isEmpty((Object)oldSku.getSkuDetail()) && !oldSku.getSkuDetail().equals(updateSupplySkuInfoReqBO.getSkuDetail())) {
                sku.setSkuDetail(updateSupplySkuInfoReqBO.getSkuDetail());
                updateFlag = true;
            }
            String packageParam = this.initPackageParam(updateSupplySkuInfoReqBO);
            if (!StringUtils.isEmpty((Object)oldSku.getPackParam())) {
                if (!oldSku.getPackParam().equals(packageParam)) {
                    sku.setPackParam(packageParam);
                    updateFlag = true;
                }
            } else {
                sku.setPackParam(packageParam);
                updateFlag = true;
            }
            if (null != oldSku.getOnShelveWay() && updateSupplySkuInfoReqBO.getOnShelveWay().byteValue() != oldSku.getOnShelveWay().byteValue()) {
                sku.setOnShelveWay(updateSupplySkuInfoReqBO.getOnShelveWay().intValue());
                updateFlag = true;
            }
            if (null != oldSku.getPreOnShelveDay() && updateSupplySkuInfoReqBO.getPreOnShelveDay() != oldSku.getPreOnShelveDay()) {
                sku.setPreOnShelveDay(updateSupplySkuInfoReqBO.getPreOnShelveDay());
                updateFlag = true;
            }
            if (null != oldSku.getOnShelveTime() && updateSupplySkuInfoReqBO.getOnShelveTime() != oldSku.getOnShelveTime()) {
                sku.setOnShelveTime(updateSupplySkuInfoReqBO.getOnShelveTime());
                updateFlag = true;
            }
            if (0 == updateSupplySkuInfoReqBO.getOperateType().intValue()) {
                sku.setSkuStatus(Constant.SKU_STATUS_PUSHING);
                updateFlag = true;
            }
            if (1 == updateSupplySkuInfoReqBO.getOperateType().intValue()) {
                sku.setSkuStatus(Constant.SKU_STATUS_DRAFT);
                updateFlag = true;
            }
            if (updateFlag.booleanValue()) {
                sku.setUpdateLoginId(updateSupplySkuInfoReqBO.getUserId());
                sku.setUpdateTime(new Date());
                this.skuMapper.updateByPrimaryKeySelective(sku, oldSku.getSupplierId());
            }
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u66f4\u65b0\u4e1a\u52a1\u670d\u52a1\u5546\u54c1\u4fe1\u606f\u66f4\u65b0\u5931\u8d25:", (Throwable)e);
            throw new BusinessException(null, "\u5546\u54c1\u4fe1\u606f\u66f4\u65b0\u5931\u8d25");
        }
    }

    private String initPackageParam(UpdateSupplySkuInfoReqBO updateSupplySkuInfoReqBO) {
        JSONObject json = new JSONObject();
        if (!StringUtils.isEmpty((Object)updateSupplySkuInfoReqBO.getPackParamLong())) {
            json.put("packParamLong", (Object)updateSupplySkuInfoReqBO.getPackParamLong());
        } else {
            json.put("packParamLong", null);
        }
        if (!StringUtils.isEmpty((Object)updateSupplySkuInfoReqBO.getPackParamWide())) {
            json.put("packParamWide", (Object)updateSupplySkuInfoReqBO.getPackParamWide());
        } else {
            json.put("packParamWide", null);
        }
        if (!StringUtils.isEmpty((Object)updateSupplySkuInfoReqBO.getPackParamHigh())) {
            json.put("packParamHigh", (Object)updateSupplySkuInfoReqBO.getPackParamHigh());
        } else {
            json.put("packParamHigh", null);
        }
        if (!StringUtils.isEmpty((Object)updateSupplySkuInfoReqBO.getPackParamWeight())) {
            json.put("packParamWeight", (Object)updateSupplySkuInfoReqBO.getPackParamWeight());
        } else {
            json.put("packParamWeight", null);
        }
        if (!StringUtils.isEmpty((Object)updateSupplySkuInfoReqBO.getPackParamList())) {
            json.put("packParamList", (Object)updateSupplySkuInfoReqBO.getPackParamList());
        } else {
            json.put("packParamList", null);
        }
        return json.toJSONString();
    }

    private void updateSkuPic(UpdateSupplySkuInfoReqBO updateSupplySkuInfoReqBO, Sku oldSku) {
        try {
            List<SkuPic> oldSkuPics;
            ArrayList<Long> skuPicIds = new ArrayList<Long>();
            ArrayList<SkuPic> skuPics = new ArrayList<SkuPic>();
            if (!updateSupplySkuInfoReqBO.getSkuPics().isEmpty()) {
                for (UpdateSupplySkuPicReqVO updateSupplySkuPicReqVO : updateSupplySkuInfoReqBO.getSkuPics()) {
                    skuPicIds.add(updateSupplySkuPicReqVO.getSkuPicId());
                    GenerateSkuPicSeqRspBO generateSkuPicSeqRspBO = this.generateSkuPicSeqService.generateSkuPicSeq();
                    SkuPic skuPic = new SkuPic();
                    skuPic.setSkuPicId(generateSkuPicSeqRspBO.getSkuPicId());
                    skuPic.setCommodityId(oldSku.getCommodityId());
                    skuPic.setSkuId(oldSku.getSkuId());
                    skuPic.setSkuPicUrl(updateSupplySkuPicReqVO.getSkuPicUrl());
                    skuPic.setSupplierId(updateSupplySkuInfoReqBO.getSupplierId());
                    skuPic.setCreateLoginId(updateSupplySkuInfoReqBO.getUserId());
                    skuPic.setCreateTime(new Date());
                    skuPic.setUpdateLoginId(updateSupplySkuInfoReqBO.getUserId());
                    skuPic.setUpdateTime(new Date());
                    skuPic.setIsDelete(Constant.IS_DELETE);
                    if (null != updateSupplySkuPicReqVO.getPicOrder()) {
                        skuPic.setPicOrder(updateSupplySkuPicReqVO.getPicOrder().intValue());
                    }
                    if (null != updateSupplySkuPicReqVO.getIsPrimary()) {
                        skuPic.setIsPrimary(updateSupplySkuPicReqVO.getIsPrimary().intValue());
                    }
                    skuPics.add(skuPic);
                }
            }
            if (!(oldSkuPics = this.skuPicMapper.selectBySkuIdAndSupplierId(oldSku.getSkuId(), updateSupplySkuInfoReqBO.getSupplierId())).isEmpty()) {
                for (SkuPic oldSkuPic : oldSkuPics) {
                    skuPicIds.add(oldSkuPic.getSkuPicId());
                }
                this.skuPicMapper.deleteSkuPicBatch(skuPicIds, updateSupplySkuInfoReqBO.getSupplierId());
            }
            if (!skuPics.isEmpty()) {
                this.skuPicMapper.insertSkuPicBatch(skuPics);
            }
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u66f4\u65b0\u4e1a\u52a1\u670d\u52a1\u5546\u54c1\u56fe\u7247\u66f4\u65b0\u5931\u8d25:", (Throwable)e);
            throw new BusinessException(null, "\u5546\u54c1\u56fe\u7247\u66f4\u65b0\u5931\u8d25");
        }
    }

    private void updateSkuPrice(UpdateSupplySkuInfoReqBO updateSupplySkuInfoReqBO, Sku oldSku) {
        if (this.isDebugEnabled) {
            logger.debug("\u5546\u54c1\u4ef7\u683c\u53d8\u66f4\u5165\u53c2\uff1a" + updateSupplySkuInfoReqBO.toString() + "sku==" + oldSku.toString());
        }
        try {
            List<SkuPrice> skuPrices = this.skuPriceMapper.selectBySkuId(oldSku.getSkuId(), updateSupplySkuInfoReqBO.getSupplierId());
            Boolean updateFlag = false;
            logger.debug("\u5546\u54c1\u5217\u8868skuPrices\uff1a" + skuPrices.toString());
            ArrayList<SkuPrice> newSkuPrices = new ArrayList<SkuPrice>();
            if (!skuPrices.isEmpty()) {
                if (null != updateSupplySkuInfoReqBO.getMarketPrice()) {
                    SkuPrice newSkuPrice;
                    if (skuPrices.get(0).getMarketPrice() != null) {
                        if (updateSupplySkuInfoReqBO.getMarketPrice().longValue() != skuPrices.get(0).getMarketPrice().longValue()) {
                            updateFlag = true;
                            for (SkuPrice skuPrice : skuPrices) {
                                newSkuPrice = new SkuPrice();
                                newSkuPrice.setSkuPriceId(skuPrice.getSkuPriceId());
                                newSkuPrice.setSupplierId(updateSupplySkuInfoReqBO.getSupplierId());
                                newSkuPrice.setMarketPrice(MoneyUtils.BigDecimal2Long((BigDecimal)updateSupplySkuInfoReqBO.getMarketPrice()));
                                newSkuPrices.add(newSkuPrice);
                            }
                        }
                    } else {
                        updateFlag = true;
                        for (SkuPrice skuPrice : skuPrices) {
                            newSkuPrice = new SkuPrice();
                            newSkuPrice.setSkuPriceId(skuPrice.getSkuPriceId());
                            newSkuPrice.setSupplierId(updateSupplySkuInfoReqBO.getSupplierId());
                            newSkuPrice.setMarketPrice(MoneyUtils.BigDecimal2Long((BigDecimal)updateSupplySkuInfoReqBO.getMarketPrice()));
                            newSkuPrices.add(newSkuPrice);
                        }
                    }
                }
                for (SkuPrice skuPrice : skuPrices) {
                    updateFlag = true;
                    SupplierAgreementSku supplierAgreementSku = this.supplierAgreementSkuMapper.selectById(skuPrice.getAgreementSkuId(), skuPrice.getSupplierId());
                    if (updateSupplySkuInfoReqBO.getIsShowSpec() == 1) {
                        skuPrice.setAgreementPrice(MoneyUtils.BigDecimal2Long((BigDecimal)updateSupplySkuInfoReqBO.getBuyPrice()));
                        skuPrice.setSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)updateSupplySkuInfoReqBO.getSalePrice()));
                        skuPrice.setMemberPrice(MoneyUtils.BigDecimal2Long((BigDecimal)updateSupplySkuInfoReqBO.getSalePrice()));
                    } else {
                        skuPrice.setAgreementPrice(supplierAgreementSku.getBuyPrice());
                        skuPrice.setSalePrice(supplierAgreementSku.getSalePrice());
                        skuPrice.setMemberPrice(supplierAgreementSku.getSalePrice());
                    }
                    newSkuPrices.add(skuPrice);
                }
            }
            logger.debug("\u5546\u54c1\u5217\u8868\uff1a" + ((Object)newSkuPrices).toString() + updateFlag);
            if (updateFlag.booleanValue() && !newSkuPrices.isEmpty()) {
                this.skuPriceMapper.updateMarketPriceBatch(newSkuPrices);
            }
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u66f4\u65b0\u4e1a\u52a1\u670d\u52a1\u5546\u54c1\u4ef7\u683c\u66f4\u65b0\u5931\u8d25:", (Throwable)e);
            throw new BusinessException(null, "\u5546\u54c1\u4ef7\u683c\u66f4\u65b0\u5931\u8d25");
        }
    }

    private void skuOnShelveApprove(UpdateSupplySkuInfoReqBO updateSupplySkuInfoReqBO, Long skuId, Sku oldSku) {
        try {
            SkuOnShelveLog skuOnShelveLog;
            ArrayList<SkuOnShelveLog> skuOnShelveLogs;
            List<SkuPrice> skuPrices = this.skuPriceMapper.selectBySkuId(skuId, updateSupplySkuInfoReqBO.getSupplierId());
            BpmStartReqBO bpmStartReqBO = new BpmStartReqBO();
            bpmStartReqBO.setBusinessTitle("\u5546\u54c1\u4fe1\u606f\u66f4\u65b0\u5e76\u63d0\u4ea4\u4e0a\u67b6\u5ba1\u6838");
            bpmStartReqBO.setBusinessType("10");
            bpmStartReqBO.setBusinessId(String.valueOf(skuId));
            bpmStartReqBO.setDetailUrl("\u5546\u54c1\u4fe1\u606f\u66f4\u65b0\u4e0a\u67b6\u5ba1\u6838");
            bpmStartReqBO.setApplyerId(updateSupplySkuInfoReqBO.getUserId());
            bpmStartReqBO.setStartFlag("1");
            bpmStartReqBO.setUserId(updateSupplySkuInfoReqBO.getUserId());
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("supplierId", updateSupplySkuInfoReqBO.getSupplierId());
            variables.put("userId", updateSupplySkuInfoReqBO.getUserId());
            variables.put("skuId", skuId);
            variables.put("approveType", "10");
            if (skuPrices != null && !skuPrices.isEmpty()) {
                variables.put("agreementId", skuPrices.get(0).getAgreementId());
                variables.put("agreementSkuId", skuPrices.get(0).getAgreementSkuId());
            } else {
                variables.put("agreementId", updateSupplySkuInfoReqBO.getAgreementId());
            }
            variables.put("agrLocation", Byte.valueOf(oldSku.getSkuLocation().toString()));
            variables.put("userName", updateSupplySkuInfoReqBO.getUserName());
            bpmStartReqBO.setVariables(variables);
            BpmStartRspBO bpmStart = this.bpmStartBusinService.bpmStart(bpmStartReqBO);
            if ("0000".equals(bpmStart.getRespCode())) {
                skuOnShelveLogs = new ArrayList<SkuOnShelveLog>();
                skuOnShelveLog = new SkuOnShelveLog();
                skuOnShelveLog.setProcInstlId(bpmStart.getProcInstId());
                skuOnShelveLog.setSkuId(skuId);
                if (!skuPrices.isEmpty()) {
                    skuOnShelveLog.setAgreementId(skuPrices.get(0).getAgreementId());
                    skuOnShelveLog.setAgreementSkuId(skuPrices.get(0).getAgreementSkuId());
                }
            } else {
                logger.info("\u5546\u54c1\u66f4\u65b0\u4e1a\u52a1\u670d\u52a1" + bpmStart.getRespDesc());
                throw new Exception(bpmStart.getRespDesc());
            }
            skuOnShelveLog.setSupplierId(updateSupplySkuInfoReqBO.getSupplierId());
            skuOnShelveLog.setSkuLocation(Byte.valueOf(oldSku.getSkuLocation().toString()));
            skuOnShelveLog.setApproveType(SupplyConstant.APPROVE_ON_SHELF_TYPE);
            skuOnShelveLog.setApproveStatus(SupplyConstant.APPROVE_STATUS_START);
            skuOnShelveLog.setApproveResult(SupplyConstant.APPROVE_SUB_TYPE);
            skuOnShelveLog.setCreateLoginId(updateSupplySkuInfoReqBO.getUserId());
            skuOnShelveLog.setCreateLoginName(updateSupplySkuInfoReqBO.getUserName());
            skuOnShelveLog.setCreateTime(new Date());
            skuOnShelveLog.setIsDelete(Constant.IS_DELETE.byteValue());
            skuOnShelveLogs.add(skuOnShelveLog);
            this.skuOnShelveLogMapper.batchSkuOnShelveLog(skuOnShelveLogs);
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u66f4\u65b0\u4e1a\u52a1\u670d\u52a1\u542f\u52a8\u5de5\u4f5c\u6d41\u5931\u8d25", (Throwable)e);
            throw new BusinessException(null, "\u542f\u52a8\u5de5\u4f5c\u6d41\u5931\u8d25");
        }
    }
}

