/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.distribute.impl;

import com.alibaba.fastjson.JSONObject;
import com.cgd.commodity.busi.QryWaitAgrSkuService;
import com.cgd.commodity.busi.bo.SkuConversionReqBO;
import com.cgd.commodity.dao.ExtSkuConversionMapper;
import com.cgd.commodity.intfce.bo.PropValueListConsumerBO;
import com.ohaotian.commodity.atom.GenerateCommoditySeqBatchService;
import com.ohaotian.commodity.atom.GenerateCommoditySeqService;
import com.ohaotian.commodity.atom.GeneratePASkuSeqBatchService;
import com.ohaotian.commodity.atom.GeneratePASkuSeqService;
import com.ohaotian.commodity.atom.GeneratePropValueListSeqService;
import com.ohaotian.commodity.atom.GenerateSkuSpecSeqBatchService;
import com.ohaotian.commodity.atom.GenerateSkuSpecSeqService;
import com.ohaotian.commodity.atom.bo.GeneratePropValueListSeqRspBO;
import com.ohaotian.commodity.busi.constant.Constant;
import com.ohaotian.commodity.busi.distribute.web.CreatePASkuFromExcelService;
import com.ohaotian.commodity.busi.distribute.web.bo.AgrDetailBO;
import com.ohaotian.commodity.busi.distribute.web.bo.CreatePASkuFromExcelReqBO;
import com.ohaotian.commodity.busi.distribute.web.bo.CreatePASkuFromExcelRspBO;
import com.ohaotian.commodity.busi.distribute.web.bo.FailMaterialBO;
import com.ohaotian.commodity.common.exception.BusinessException;
import com.ohaotian.commodity.config.TopicConfig;
import com.ohaotian.commodity.dao.CommodityMapper;
import com.ohaotian.commodity.dao.CommodityPropDefMapper;
import com.ohaotian.commodity.dao.CommodityPropGrpMapper;
import com.ohaotian.commodity.dao.CommodityTypeMapper;
import com.ohaotian.commodity.dao.EMdmMaterialMapper;
import com.ohaotian.commodity.dao.PropValueListMapper;
import com.ohaotian.commodity.dao.SkuMapper;
import com.ohaotian.commodity.dao.SkuPriceMapper;
import com.ohaotian.commodity.dao.SkuSpecMapper;
import com.ohaotian.commodity.dao.SupplierAgreementMapper;
import com.ohaotian.commodity.dao.SupplierAgreementSkuMapper;
import com.ohaotian.commodity.dao.po.Commodity;
import com.ohaotian.commodity.dao.po.CommodityPropDef;
import com.ohaotian.commodity.dao.po.CommodityPropGrp;
import com.ohaotian.commodity.dao.po.CommodityType;
import com.ohaotian.commodity.dao.po.EMdmMaterial;
import com.ohaotian.commodity.dao.po.EMdmProp;
import com.ohaotian.commodity.dao.po.PropValueList;
import com.ohaotian.commodity.dao.po.Sku;
import com.ohaotian.commodity.dao.po.SkuPrice;
import com.ohaotian.commodity.dao.po.SkuSpec;
import com.ohaotian.commodity.dao.po.SkuSyncExceptionLog;
import com.ohaotian.commodity.dao.po.SupplierAgreement;
import com.ohaotian.commodity.dao.po.SupplierAgreementSku;
import com.ohaotian.commodity.intfce.bo.SkuSyncExceptionLogBO;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.StringUtils;

@Service(value="createPASkuFromExcelService")
public class CreatePASkuFromExcelServiceImpl
implements CreatePASkuFromExcelService {
    private static final Logger logger = LoggerFactory.getLogger(CreatePASkuFromExcelServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private Long wltime = 0L;
    private Long xytime = 0L;
    private Long paskuseqtime = 0L;
    private Long commodityseqtime = 0L;
    private Long emtime = 0L;
    private Long commoditytime = 0L;
    private Long proptime = 0L;
    private Long grptime = 0L;
    private Long deftime = 0L;
    private Long propinitTime = 0L;
    private Long skutime = 0L;
    private Long sputime = 0L;
    private Long pricetime = 0L;
    private Long spectime = 0L;
    private Long propvaluelistTime = 0L;
    private Long propvaluelistseqTime = 0L;
    private Long propvaluelistmqTime = 0L;
    private Long fortime = 0L;
    private Long priceSqltime = 0L;
    private Long specSqltime = 0L;
    private Long skuSqltime = 0L;
    @Autowired
    QryWaitAgrSkuService qryWaitAgrSkuService;
    @Autowired
    private GeneratePASkuSeqService generatePASkuSeqService;
    @Autowired
    private GeneratePASkuSeqBatchService generatePASkuSeqBatchService;
    @Autowired
    private SupplierAgreementMapper supplierAgreementMapper;
    @Autowired
    private SupplierAgreementSkuMapper supplierAgreementSkuMapper;
    @Autowired
    private EMdmMaterialMapper eMdmMaterialMapperC;
    @Autowired
    private GenerateCommoditySeqService generateCommoditySeqService;
    @Autowired
    private GenerateCommoditySeqBatchService generateCommoditySeqBatchService;
    @Autowired
    private GenerateSkuSpecSeqService generateSkuSpecSeqService;
    @Autowired
    private GenerateSkuSpecSeqBatchService generateSkuSpecSeqBatchService;
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private CommodityMapper commodityMapper;
    @Autowired
    private SkuSpecMapper skuSpecMapper;
    @Autowired
    private SkuPriceMapper skuPriceMapper;
    @Autowired
    private CommodityTypeMapper commodityTypeMapper;
    @Autowired
    private CommodityPropGrpMapper commodityPropGrpMapper;
    @Autowired
    private CommodityPropDefMapper commodityPropDefMapper;
    @Autowired
    private PropValueListMapper propValueListMapper;
    @Autowired
    private GeneratePropValueListSeqService generatePropValueListSeqService;
    @Resource(name="skuSyncExceptionLogInstProducer")
    private ProxyMessageProducer skuSyncExceptionLogInstProducer;
    @Resource
    private TopicConfig topicConfig;
    @Resource(name="propValueListInstServiceProducer")
    private ProxyMessageProducer propValueListInstServiceProducer;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private ExtSkuConversionMapper extSkuConversionMapper;
    @Resource(name="transactionManager")
    private DataSourceTransactionManager transactionManager;

    public CreatePASkuFromExcelRspBO createPASkuFromExcel(CreatePASkuFromExcelReqBO createPASkuFromExcelReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("SKU\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + createPASkuFromExcelReqBO.toString());
        }
        CreatePASkuFromExcelRspBO rspBO = new CreatePASkuFromExcelRspBO();
        ArrayList<FailMaterialBO> failMaterialBOS = new ArrayList<FailMaterialBO>();
        ArrayList<Long> skuIds = new ArrayList<Long>();
        if (null != createPASkuFromExcelReqBO) {
            if (null == createPASkuFromExcelReqBO.getAgreementId() || null == createPASkuFromExcelReqBO.getSupplierId() || null == createPASkuFromExcelReqBO.getAgrDetails()) {
                rspBO.setRespCode("7777");
                rspBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25");
                return rspBO;
            }
        } else {
            rspBO.setRespCode("7777");
            rspBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25");
            return rspBO;
        }
        if (this.cacheClient.get("IS_CREATE_FLAG_" + createPASkuFromExcelReqBO.getAgreementId()) != null) {
            rspBO.setRespCode("CREATE_SKU_SERVICE_RSP_FAIL");
            rspBO.setRespDesc("\u5f53\u524d\u534f\u8bae\u5b58\u5728\u6279\u91cf\u53d1\u5e03\u5546\u54c1\u64cd\u4f5c\uff0c\u8bf7\u7b49\u5f85\u64cd\u4f5c\u5b8c\u6210");
            return rspBO;
        }
        this.cacheClient.set("IS_CREATE_FLAG_" + createPASkuFromExcelReqBO.getAgreementId(), (Object)"true");
        try {
            Boolean failFlag = false;
            long startTime = System.currentTimeMillis();
            Page page = new Page(1, 1000);
            List<SupplierAgreementSku> supplierAgreementSkus = this.supplierAgreementSkuMapper.selectWaitAgrSkuBySkuIds((Page<Map<String, Object>>)page, createPASkuFromExcelReqBO.getAgreementId(), createPASkuFromExcelReqBO.getSupplierId(), createPASkuFromExcelReqBO.getAgreementSkuIds());
            HashMap<Long, SupplierAgreementSku> agreementSkuIdsMap = new HashMap<Long, SupplierAgreementSku>();
            ArrayList<Long> materialIds = new ArrayList<Long>();
            for (SupplierAgreementSku supplierAgreementSku : supplierAgreementSkus) {
                agreementSkuIdsMap.put(supplierAgreementSku.getAgreementSkuId(), supplierAgreementSku);
                materialIds.add(Long.valueOf(supplierAgreementSku.getMaterialId()));
            }
            for (AgrDetailBO agrDetailBO : createPASkuFromExcelReqBO.getAgrDetails()) {
                if (materialIds.contains(agrDetailBO.getMaterialId()) && null != agreementSkuIdsMap.get(agrDetailBO.getAgreementSkuId())) continue;
                FailMaterialBO failBO = new FailMaterialBO();
                failBO.setFailDesc("\u8be5\u534f\u8bae\u4e0d\u5b58\u5728\u6b64\u7269\u6599\u7f16\u7801\u6216\u4e0d\u5b58\u5728\u6b64\u534f\u8bae\u660e\u7ec6");
                failBO.setMaterialId(agrDetailBO.getMaterialId());
                failMaterialBOS.add(failBO);
                failFlag = true;
            }
            if (failFlag.booleanValue()) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5931\u8d25");
                rspBO.setTotalCount(createPASkuFromExcelReqBO.getAgrDetails().size());
                rspBO.setFailMaterials(failMaterialBOS);
                this.cacheClient.delete("IS_CREATE_FLAG_" + createPASkuFromExcelReqBO.getAgreementId());
                Iterator<SupplierAgreementSku> iterator = rspBO;
                return iterator;
            }
            long endTime1 = System.currentTimeMillis();
            this.wltime = this.wltime + (endTime1 - startTime);
            SupplierAgreement supplierAgreement = this.supplierAgreementMapper.selectById(createPASkuFromExcelReqBO.getAgreementId(), createPASkuFromExcelReqBO.getSupplierId());
            long xytime1 = System.currentTimeMillis();
            this.xytime = xytime1 - endTime1;
            if (null == supplierAgreement) {
                throw new BusinessException(null, "\u534f\u8bae\u4e0d\u5b58\u5728");
            }
            Long creatStartTime = System.currentTimeMillis();
            ArrayList<Sku> skus = new ArrayList<Sku>();
            ArrayList skuSpecs = new ArrayList();
            ArrayList<SkuPrice> skuPrices = new ArrayList<SkuPrice>();
            ArrayList commoditys = new ArrayList();
            ArrayList<SkuConversionReqBO> extSkuConversions = new ArrayList<SkuConversionReqBO>();
            List<Long> paSkuSeqs = this.generatePASkuSeqBatchService.generatePASkuSeqBatch(createPASkuFromExcelReqBO.getAgrDetails().size());
            if (paSkuSeqs.size() != createPASkuFromExcelReqBO.getAgrDetails().size()) {
                throw new BusinessException(null, "\u5355\u54c1\u6279\u91cf\u751f\u6210\u5e8f\u5217\u9519\u8bef");
            }
            long paskuseqtime1 = System.currentTimeMillis();
            this.paskuseqtime = paskuseqtime1 - xytime1;
            List<Long> commoditySeqs = this.generateCommoditySeqBatchService.generateCommoditySeqBatch(createPASkuFromExcelReqBO.getAgrDetails().size());
            if (commoditySeqs.size() != createPASkuFromExcelReqBO.getAgrDetails().size()) {
                throw new BusinessException(null, "\u5546\u54c1\u6279\u91cf\u751f\u6210\u5e8f\u5217\u9519\u8bef");
            }
            long commodityseqtime1 = System.currentTimeMillis();
            this.commodityseqtime = commodityseqtime1 - paskuseqtime1;
            List<EMdmMaterial> eMdmMaterialList = this.eMdmMaterialMapperC.selectMaterialListByMaterialCode(materialIds);
            HashMap<Long, EMdmMaterial> emMap = new HashMap<Long, EMdmMaterial>();
            ArrayList<Long> catalogIds = new ArrayList<Long>();
            ArrayList<Long> sysIds = new ArrayList<Long>();
            for (EMdmMaterial em : eMdmMaterialList) {
                emMap.put(em.getMaterialCode(), em);
                catalogIds.add(em.getCatalogId());
                sysIds.add(em.getSysId());
            }
            long emTime2 = System.currentTimeMillis();
            this.emtime = this.emtime + (emTime2 - commodityseqtime1);
            List<CommodityType> commodityTypes = this.commodityTypeMapper.selectCommodityTypesByCatalogIds(catalogIds);
            HashMap<Long, CommodityType> commodityTypeMap = new HashMap<Long, CommodityType>();
            ArrayList<Long> commodityTypeIds = new ArrayList<Long>();
            for (CommodityType commodityType : commodityTypes) {
                commodityTypeMap.put(commodityType.getCatalogId(), commodityType);
                commodityTypeIds.add(commodityType.getCommodityTypeId());
            }
            List<Commodity> commodityLists = this.commodityMapper.selectCommoditysByTypeIdsAndSupplierId(commodityTypeIds, supplierAgreement.getSupplierId());
            HashMap<Long, Commodity> commodityMap = new HashMap<Long, Commodity>();
            for (Commodity commodity : commodityLists) {
                commodityMap.put(commodity.getCommodityTypeId(), commodity);
            }
            long commodityTime2 = System.currentTimeMillis();
            this.commoditytime = commodityTime2 - emTime2;
            HashMap<Long, List> propMaps = new HashMap<Long, List>();
            ArrayList<EMdmProp> materialIdPropList = new ArrayList<EMdmProp>();
            List<EMdmProp> propList = this.eMdmMaterialMapperC.qryPropNameAndValueByIn(materialIds);
            for (int p = 0; p < propList.size(); ++p) {
                Long preMaterialId = null;
                Long curMaterialId = null;
                if (p == 0) {
                    preMaterialId = propList.get(p).getMaterialId();
                    curMaterialId = propList.get(p).getMaterialId();
                    materialIdPropList.add(propList.get(p));
                } else {
                    preMaterialId = propList.get(p - 1).getMaterialId();
                    curMaterialId = propList.get(p).getMaterialId();
                    if (preMaterialId.toString().equals(curMaterialId.toString())) {
                        materialIdPropList.add(propList.get(p));
                    } else {
                        propMaps.put(preMaterialId, materialIdPropList);
                        materialIdPropList = new ArrayList();
                        materialIdPropList.add(propList.get(p));
                    }
                }
                if (p != propList.size() - 1) continue;
                propMaps.put(curMaterialId, materialIdPropList);
            }
            long propTime2 = System.currentTimeMillis();
            this.proptime = propTime2 - commodityTime2;
            HashMap<Long, List> grpMap = new HashMap<Long, List>();
            ArrayList<CommodityPropGrp> grpList = new ArrayList<CommodityPropGrp>();
            List<CommodityPropGrp> commodityPropGrpListAll = this.commodityPropGrpMapper.qryPowerListByTypeIds(commodityTypeIds);
            for (int m = 0; m < commodityPropGrpListAll.size(); ++m) {
                Long preCommodityTypeId = null;
                Long curCommodityTypeId = null;
                if (m == 0) {
                    preCommodityTypeId = commodityPropGrpListAll.get(m).getCommodityTypeId();
                    curCommodityTypeId = commodityPropGrpListAll.get(m).getCommodityTypeId();
                    grpList.add(commodityPropGrpListAll.get(m));
                } else {
                    preCommodityTypeId = commodityPropGrpListAll.get(m - 1).getCommodityTypeId();
                    curCommodityTypeId = commodityPropGrpListAll.get(m).getCommodityTypeId();
                    if (preCommodityTypeId.toString().equals(curCommodityTypeId.toString())) {
                        grpList.add(commodityPropGrpListAll.get(m));
                    } else {
                        grpMap.put(preCommodityTypeId, grpList);
                        grpList = new ArrayList();
                        grpList.add(commodityPropGrpListAll.get(m));
                    }
                }
                if (m != commodityPropGrpListAll.size() - 1) continue;
                grpMap.put(curCommodityTypeId, grpList);
            }
            long grpTime2 = System.currentTimeMillis();
            this.grptime = grpTime2 - propTime2;
            List<CommodityPropDef> commodityPropDefList = this.commodityPropDefMapper.selectPropDefs();
            HashMap<String, Long> commodityPropDefMap = new HashMap<String, Long>();
            for (CommodityPropDef def : commodityPropDefList) {
                commodityPropDefMap.put(def.getPropName(), def.getCommodityPropDefId());
            }
            long defTime2 = System.currentTimeMillis();
            this.deftime = defTime2 - grpTime2;
            for (int a = 0; a < createPASkuFromExcelReqBO.getAgrDetails().size(); ++a) {
                AgrDetailBO agrDetailBO = (AgrDetailBO)createPASkuFromExcelReqBO.getAgrDetails().get(a);
                Map<String, List> singleMap = this.creatPASkuInit(a, paSkuSeqs, commoditySeqs, emMap, commodityTypeMap, commodityMap, propMaps, grpMap, commodityPropDefMap, agrDetailBO, createPASkuFromExcelReqBO, supplierAgreement, (SupplierAgreementSku)agreementSkuIdsMap.get(agrDetailBO.getAgreementSkuId()));
                skus.addAll(singleMap.get("skus"));
                skuSpecs.addAll(singleMap.get("skuSpecs"));
                skuPrices.addAll(singleMap.get("skuPrices"));
                commoditys.addAll(singleMap.get("commoditys"));
                extSkuConversions.addAll(singleMap.get("extSkuConversions"));
            }
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(3);
            TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
            try {
                if (extSkuConversions != null && extSkuConversions.size() > 0) {
                    this.extSkuConversionMapper.insertBatch(extSkuConversions);
                }
                this.transactionManager.commit(status);
            }
            catch (Exception e) {
                this.transactionManager.rollback(status);
                throw new BusinessException("RSP_CODE_THREE_DATA_NULL", "\u6cb9\u54c1\u6570\u636e\u65b0\u589e\u5931\u8d25\uff0c" + e.getMessage());
            }
            long forTime2 = System.currentTimeMillis();
            this.fortime = forTime2 - defTime2;
            for (Sku sku : skus) {
                skuIds.add(sku.getSkuId());
            }
            if (skuPrices != null && skuPrices.size() > 0) {
                this.skuPriceMapper.insertSkuPriceBatch(skuPrices);
            }
            long priceSqlTime = System.currentTimeMillis();
            this.priceSqltime = priceSqlTime - forTime2;
            if (skuSpecs != null && skuSpecs.size() > 0) {
                ArrayList<SkuSpec> skuSpecList = new ArrayList<SkuSpec>();
                List<Long> specSeqList = this.generateSkuSpecSeqBatchService.generateSkuSpecSeqBatch(skuSpecs.size());
                if (specSeqList.size() != skuSpecs.size()) {
                    throw new BusinessException(null, "\u5355\u54c1\u89c4\u683c\u6279\u91cf\u751f\u6210\u5e8f\u5217\u9519\u8bef");
                }
                for (int s = 0; s < skuSpecs.size(); ++s) {
                    SkuSpec ss = (SkuSpec)skuSpecs.get(s);
                    ss.setSkuSpecId(specSeqList.get(s));
                    skuSpecList.add(ss);
                }
                this.skuSpecMapper.insertSkuSpecBatch(skuSpecList);
            }
            long specSqlTime = System.currentTimeMillis();
            this.specSqltime = specSqlTime - priceSqlTime;
            this.skuMapper.insertBtatchSelective(skus);
            long skuSqlTime = System.currentTimeMillis();
            this.skuSqltime = skuSqlTime - specSqlTime;
            logger.error("wuliao  time\uff1a " + this.wltime + "ms");
            logger.error("xytime  time\uff1a " + this.xytime + "ms");
            logger.error("paskuseqtime  time\uff1a " + this.paskuseqtime + "ms");
            logger.error("commodityseqtime  time\uff1a " + this.commodityseqtime + "ms");
            logger.error("emtime  time\uff1a " + this.emtime + "ms");
            logger.error("commodityTime  time\uff1a " + this.commoditytime + "ms");
            logger.error("proptime  time\uff1a " + this.proptime + "ms");
            logger.error("grptime  time\uff1a " + this.grptime + "ms");
            logger.error("deftime  time\uff1a " + this.deftime + "ms");
            logger.error("********************for start");
            logger.error("propinitTime  time\uff1a " + this.propinitTime + "ms");
            logger.error("sku  time\uff1a " + this.skutime + "ms");
            logger.error("sputime  time\uff1a " + this.sputime + "ms");
            logger.error("price  time\uff1a " + this.pricetime + "ms");
            logger.error("spec  time\uff1a " + this.spectime + "ms");
            logger.error("propvaluelistTime  time\uff1a " + this.propvaluelistTime + "ms");
            logger.error("propvaluelistseqTime  time\uff1a " + this.propvaluelistseqTime + "ms");
            logger.error("propvaluelistmqTime  time\uff1a " + this.propvaluelistmqTime + "ms");
            logger.error("********************for end");
            logger.error("fortime  time\uff1a " + this.fortime + "ms");
            logger.error("priceSqltime  time\uff1a " + this.priceSqltime + "ms");
            logger.error("specSqltime  time\uff1a " + this.specSqltime + "ms");
            logger.error("skuSqltime  time\uff1a " + this.skuSqltime + "ms");
            logger.error("total  time\uff1a " + (skuSqlTime - startTime) + "ms");
            rspBO.setSkuIds(skuIds);
            rspBO.setTotalCount(createPASkuFromExcelReqBO.getAgrDetails().size());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u534f\u8bae\u660e\u7ec6\u6a21\u677f\u5bfc\u5165\u5546\u54c1\u4fe1\u606f\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u534f\u8bae\u660e\u7ec6\u6a21\u677f\u5bfc\u5165\u5546\u54c1\u4fe1\u606f\u670d\u52a1\u5931\u8d25");
        }
        finally {
            this.cacheClient.delete("IS_CREATE_FLAG_" + createPASkuFromExcelReqBO.getAgreementId());
        }
        return rspBO;
    }

    private Map<String, List> creatPASkuInit(int a, List<Long> paSkuSeqs, List<Long> commoditySeqs, Map<Long, EMdmMaterial> emMap, Map<Long, CommodityType> commodityTypeMap, Map<Long, Commodity> commodityMap, Map<Long, List> propMaps, Map<Long, List> grpMap, Map<String, Long> commodityPropDefMap, AgrDetailBO agrDetailBO, CreatePASkuFromExcelReqBO createPASkuFromExcelReqBO, SupplierAgreement supplierAgreement, SupplierAgreementSku supplierAgreementSku) {
        HashMap<String, List> map = new HashMap<String, List>();
        Long paSkuSeq = paSkuSeqs.get(a);
        long eTime0 = System.currentTimeMillis();
        EMdmMaterial eMdmMaterial = emMap.get(agrDetailBO.getMaterialId());
        ArrayList<EMdmProp> propList = new ArrayList();
        CommodityType commodityType = new CommodityType();
        Commodity commodityTemp = new Commodity();
        long propTime1 = 0L;
        if (null != eMdmMaterial) {
            if (propMaps != null && propMaps.size() > 0 && null != propMaps.get(eMdmMaterial.getMaterialId())) {
                propList = propMaps.get(eMdmMaterial.getMaterialId());
            }
            propTime1 = System.currentTimeMillis();
            this.propinitTime = this.propinitTime + (propTime1 - eTime0);
            if (null != eMdmMaterial.getCatalogId() && (commodityType = commodityTypeMap.get(eMdmMaterial.getCatalogId())) != null) {
                commodityTemp = commodityMap.get(commodityType.getCommodityTypeId());
            }
        } else {
            throw new BusinessException(null, "\u7269\u6599\u7f16\u7801\u4e0d\u5b58\u5728");
        }
        Long commoditySeq = commoditySeqs.get(a);
        Sku sku = this.initSku(createPASkuFromExcelReqBO, agrDetailBO, supplierAgreement, supplierAgreementSku, eMdmMaterial, commoditySeq, paSkuSeq, commodityType);
        ArrayList<SkuConversionReqBO> extSkuConversions = new ArrayList<SkuConversionReqBO>();
        SkuConversionReqBO extSkuConversion = this.initExtSkuConversion(sku, agrDetailBO);
        extSkuConversions.add(extSkuConversion);
        long eTime1 = System.currentTimeMillis();
        this.skutime = this.skutime + (eTime1 - propTime1);
        ArrayList<Commodity> commoditys = new ArrayList<Commodity>();
        Commodity commodity = this.initCommodity(createPASkuFromExcelReqBO, supplierAgreement, supplierAgreementSku, commoditySeq, sku, commodityType, commodityTemp);
        commoditys.add(commodity);
        long eTime2 = System.currentTimeMillis();
        this.sputime = this.sputime + (eTime2 - eTime1);
        ArrayList<SkuPrice> skuPrices = new ArrayList<SkuPrice>();
        SkuPrice skuPrice = this.initSkuPrice(agrDetailBO, sku, createPASkuFromExcelReqBO, supplierAgreementSku, supplierAgreementSku.getAgreementSkuId());
        skuPrices.add(skuPrice);
        long eTime4 = System.currentTimeMillis();
        this.pricetime = this.pricetime + (eTime4 - eTime2);
        logger.error("\u5355\u54c1\u4ef7\u683c\u521d\u59cb\u5316\u8fd0\u884c\u65f6\u95f4\uff1a " + (eTime4 - eTime2) + "ms");
        List<SkuSpec> skuSpecs = this.initSkuSpec(propList, commodity, sku, createPASkuFromExcelReqBO, supplierAgreementSku, commodityType, grpMap, commodityPropDefMap);
        long eTime5 = System.currentTimeMillis();
        this.spectime = this.spectime + (eTime5 - eTime4);
        logger.error("\u5355\u54c1\u89c4\u683c\u521d\u59cb\u5316\u8fd0\u884c\u65f6\u95f4\uff1a " + (eTime5 - eTime4) + "ms");
        ArrayList<Sku> skus = new ArrayList<Sku>();
        skus.add(sku);
        map.put("skus", skus);
        map.put("commoditys", commoditys);
        map.put("skuPrices", skuPrices);
        map.put("skuSpecs", skuSpecs);
        map.put("extSkuConversions", extSkuConversions);
        return map;
    }

    private SkuConversionReqBO initExtSkuConversion(Sku sku, AgrDetailBO agrDetailBO) {
        SkuConversionReqBO sc = new SkuConversionReqBO();
        sc.setSkuId(sku.getSkuId());
        sc.setType(Long.valueOf(0L));
        sc.setSupplierId(sku.getSupplierId());
        sc.setSaleunit(agrDetailBO.getSaleunit());
        sc.setSettlerate(agrDetailBO.getSettlerate());
        sc.setSettleunit(agrDetailBO.getSettleunit());
        sc.setWarenum(agrDetailBO.getWarenum());
        sc.setCreateTime(new Date());
        if (null != agrDetailBO.getIsShowSpec() && agrDetailBO.getIsShowSpec() == 1) {
            sc.setIsShowSpec(Byte.valueOf((byte)1));
        } else {
            sc.setIsShowSpec(Byte.valueOf((byte)0));
        }
        sc.setCreateLoginId(sku.getCreateLoginId());
        return sc;
    }

    private Sku initSku(CreatePASkuFromExcelReqBO createPASkuFromExcelReqBO, AgrDetailBO agrDetailBO, SupplierAgreement supplierAgreement, SupplierAgreementSku supplierAgreementSku, EMdmMaterial eMdmMaterial, Long commoditySeq, Long paSkuSeq, CommodityType commodityType) {
        try {
            Sku sku = new Sku();
            sku.setSkuId(paSkuSeq);
            sku.setCommodityId(commoditySeq);
            sku.setSupplierId(createPASkuFromExcelReqBO.getSupplierId());
            sku.setSupplierName(supplierAgreement.getSupplierName());
            sku.setVendorId(supplierAgreement.getVendorId());
            sku.setVendorName(supplierAgreement.getVendorName());
            if (!StringUtils.isEmpty((Object)supplierAgreementSku.getMaterialId())) {
                sku.setMaterialId(Long.parseLong(supplierAgreementSku.getMaterialId()));
            } else {
                sku.setMaterialId(eMdmMaterial.getMaterialCode());
            }
            sku.setSkuLongName(eMdmMaterial.getLongDesc());
            sku.setBrandId(supplierAgreementSku.getBrandId());
            sku.setBrandName(supplierAgreementSku.getBrandName());
            sku.setMeasureId(supplierAgreementSku.getMeasureId());
            sku.setMeasureName(supplierAgreementSku.getMeasureName());
            sku.setMfgSku(eMdmMaterial.getMainModel());
            if (null != commodityType.getCommodityTypeId()) {
                sku.setCommodityTypeId(commodityType.getCommodityTypeId());
            } else {
                sku.setCommodityTypeId(supplierAgreementSku.getCommodityTypeId());
            }
            sku.setSkuLocation((int)supplierAgreement.getAgrLocation());
            sku.setSkuName(agrDetailBO.getSkuName());
            sku.setSkuDetail(agrDetailBO.getSkuDetail());
            String packageParam = this.initPackageParam(agrDetailBO);
            sku.setPackParam(packageParam);
            sku.setOnShelveWay(0);
            sku.setSkuStatus(Constant.SKU_STATUS_DRAFT);
            sku.setBrandId(supplierAgreementSku.getBrandId());
            sku.setBrandName(supplierAgreementSku.getBrandName());
            sku.setIsSupplierAgreement(Constant.IS_NOT_SUPPLIER_AGREEMENT);
            sku.setCreateLoginId(createPASkuFromExcelReqBO.getUserId());
            sku.setCreateTime(new Date());
            sku.setIsDelete(Constant.IS_DELETE);
            return sku;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1sku\u521d\u59cb\u5316\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5355\u54c1SKU\u5931\u8d25");
        }
    }

    private String initPackageParam(AgrDetailBO agrDetailBO) {
        JSONObject json = new JSONObject();
        if (!StringUtils.isEmpty((Object)agrDetailBO.getPackParamLong())) {
            json.put("packParamLong", (Object)agrDetailBO.getPackParamLong());
        } else {
            json.put("packParamLong", null);
        }
        if (!StringUtils.isEmpty((Object)agrDetailBO.getPackParamWide())) {
            json.put("packParamWide", (Object)agrDetailBO.getPackParamWide());
        } else {
            json.put("packParamWide", null);
        }
        if (!StringUtils.isEmpty((Object)agrDetailBO.getPackParamHigh())) {
            json.put("packParamHigh", (Object)agrDetailBO.getPackParamHigh());
        } else {
            json.put("packParamHigh", null);
        }
        if (!StringUtils.isEmpty((Object)agrDetailBO.getPackParamWeight())) {
            json.put("packParamWeight", (Object)agrDetailBO.getPackParamWeight());
        } else {
            json.put("packParamWeight", null);
        }
        if (!StringUtils.isEmpty((Object)agrDetailBO.getPackParamList())) {
            json.put("packParamList", (Object)agrDetailBO.getPackParamList());
        } else {
            json.put("packParamList", null);
        }
        return json.toJSONString();
    }

    private Commodity initCommodity(CreatePASkuFromExcelReqBO createPASkuFromExcelReqBO, SupplierAgreement supplierAgreement, SupplierAgreementSku supplierAgreementSku, Long commoditySeq, Sku sku, CommodityType commodityType, Commodity commodity) {
        try {
            Commodity newCommodity = new Commodity();
            if (null == commodity) {
                newCommodity.setCommodityCode(String.valueOf(sku.getSkuId()));
                newCommodity.setCommodityLocation(new Long(1L));
                if (null != commodityType.getCommodityTypeId()) {
                    newCommodity.setCommodityTypeId(commodityType.getCommodityTypeId());
                } else {
                    newCommodity.setCommodityTypeId(supplierAgreementSku.getCommodityTypeId());
                }
                newCommodity.setSupplierId(supplierAgreement.getSupplierId());
                newCommodity.setSupplierName(supplierAgreement.getSupplierName());
                newCommodity.setCreateLoginId(createPASkuFromExcelReqBO.getUserId());
                newCommodity.setCreateTime(new Date());
                newCommodity.setIsDelete(Constant.IS_DELETE);
                newCommodity.setCommodityId(commoditySeq);
                newCommodity.setSupplierShopId(supplierAgreement.getSupplierId());
                this.commodityMapper.insertSelective(newCommodity);
                return newCommodity;
            }
            return commodity;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1SPU\u521d\u59cb\u5316\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5546\u54c1\uff08SPU\uff09\u5931\u8d25");
        }
    }

    private SkuPrice initSkuPrice(AgrDetailBO agrDetailBO, Sku sku, CreatePASkuFromExcelReqBO createPASkuFromExcelReqBO, SupplierAgreementSku supplierAgreementSku, Long agreementSkuId) {
        logger.debug("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u5165\u53c2" + agrDetailBO.toString() + "sku" + sku.toString() + "supplierAgreementSku" + supplierAgreementSku.toString());
        try {
            SkuPrice skuPrice = new SkuPrice();
            skuPrice.setSkuId(sku.getSkuId());
            skuPrice.setAgreementId(createPASkuFromExcelReqBO.getAgreementId());
            skuPrice.setAgreementSkuId(agreementSkuId);
            logger.debug("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u5165\u53c2isshowspec" + agrDetailBO.getIsShowSpec());
            if (null != agrDetailBO.getIsShowSpec() && agrDetailBO.getIsShowSpec() == 1) {
                logger.debug("IsShowSpec = 1");
                BigDecimal settlerateDM = new BigDecimal(agrDetailBO.getSettlerate());
                BigDecimal buyPriceDM = new BigDecimal(supplierAgreementSku.getBuyPrice());
                BigDecimal salePriceDM = new BigDecimal(supplierAgreementSku.getSalePrice());
                Long buyPrice = buyPriceDM.multiply(settlerateDM).setScale(2, 4).longValue();
                Long salePrice = salePriceDM.multiply(settlerateDM).setScale(2, 4).longValue();
                skuPrice.setAgreementPrice(buyPrice);
                skuPrice.setSalePrice(salePrice);
                skuPrice.setMemberPrice(salePrice);
            } else {
                logger.debug("IsShowSpec = 2");
                skuPrice.setAgreementPrice(supplierAgreementSku.getBuyPrice());
                skuPrice.setSalePrice(supplierAgreementSku.getSalePrice());
                skuPrice.setMemberPrice(supplierAgreementSku.getSalePrice());
            }
            skuPrice.setSupplierId(createPASkuFromExcelReqBO.getSupplierId());
            skuPrice.setCreateLoginId(createPASkuFromExcelReqBO.getUserId());
            skuPrice.setCreateTime(new Date());
            skuPrice.setCurrencyType(Constant.CURRENCY_TYPE_RMB);
            skuPrice.setIsDelete(Constant.IS_DELETE);
            logger.debug("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u51fa\u53c2" + skuPrice.toString());
            return skuPrice;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u5546\u54c1\u4ef7\u683c\u5931\u8d25", (Throwable)e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5546\u54c1\u4ef7\u683c\u5931\u8d25");
        }
    }

    private List<SkuSpec> initSkuSpec(List<EMdmProp> propList, Commodity commodity, Sku sku, CreatePASkuFromExcelReqBO createPASkuFromExcelReqBO, SupplierAgreementSku supplierAgreementSku, CommodityType commodityType, Map<Long, List> grpMap, Map<String, Long> commodityPropDefMap) {
        try {
            List commodityPropGrps = null;
            if (null != commodityType) {
                commodityPropGrps = grpMap.get(commodityType.getCommodityTypeId());
            }
            ArrayList<SkuSpec> skuSpecs = new ArrayList<SkuSpec>();
            if (null != propList && propList.size() > 0) {
                for (EMdmProp prop : propList) {
                    String propName = prop.getPropName();
                    if (StringUtils.isEmpty((Object)propName)) continue;
                    SkuSpec skuSpec = new SkuSpec();
                    skuSpec.setCommodityId(commodity.getCommodityId());
                    skuSpec.setSkuId(sku.getSkuId());
                    skuSpec.setSupplierId(createPASkuFromExcelReqBO.getSupplierId());
                    Long commodityPropDefId = commodityPropDefMap.get(propName);
                    if (null == commodityPropDefId) continue;
                    skuSpec.setCommoditySpecId(commodityPropDefId);
                    skuSpec.setPropName(propName);
                    skuSpec.setPropShowName(propName);
                    PropValueList propValueList = this.initPropValueList(commodityPropDefId, propName, prop.getPropValue());
                    if (null != propValueList) {
                        skuSpec.setPropValueListId(propValueList.getPropValueListId());
                    } else {
                        skuSpec.setPropValueListId(prop.getPropValueId());
                    }
                    skuSpec.setPropValue(prop.getPropValue());
                    skuSpec.setCreateLoginId(createPASkuFromExcelReqBO.getUserId());
                    skuSpec.setCreateTime(new Date());
                    skuSpec.setIsDelete(Constant.IS_DELETE);
                    if (null != commodityPropGrps && commodityPropGrps.size() > 0) {
                        skuSpec.setCommodityPropGrpId(((CommodityPropGrp)commodityPropGrps.get(0)).getCommodityPropGrpId());
                    }
                    skuSpecs.add(skuSpec);
                }
            } else if (null != supplierAgreementSku) {
                PropValueList propValueList;
                Long commodityPropDefId;
                SkuSpec skuSpec;
                String model = supplierAgreementSku.getModel();
                String figure = supplierAgreementSku.getFigure();
                String spec = supplierAgreementSku.getSpec();
                String texture = supplierAgreementSku.getTexture();
                if (!StringUtils.isEmpty((Object)model)) {
                    skuSpec = new SkuSpec();
                    skuSpec.setCommodityId(commodity.getCommodityId());
                    skuSpec.setSkuId(sku.getSkuId());
                    skuSpec.setSupplierId(createPASkuFromExcelReqBO.getSupplierId());
                    if (null != commodityPropGrps && commodityPropGrps.size() > 0) {
                        skuSpec.setCommodityPropGrpId(((CommodityPropGrp)commodityPropGrps.get(0)).getCommodityPropGrpId());
                    }
                    if (null != (commodityPropDefId = commodityPropDefMap.get("\u578b\u53f7"))) {
                        skuSpec.setCommoditySpecId(commodityPropDefId);
                    }
                    skuSpec.setPropName("\u578b\u53f7");
                    skuSpec.setPropShowName("\u578b\u53f7");
                    propValueList = this.initPropValueList(commodityPropDefId, "\u578b\u53f7", model);
                    if (null != propValueList) {
                        skuSpec.setPropValueListId(propValueList.getPropValueListId());
                    }
                    skuSpec.setPropValue(model);
                    skuSpec.setCreateLoginId(createPASkuFromExcelReqBO.getUserId());
                    skuSpec.setCreateTime(new Date());
                    skuSpec.setIsDelete(Constant.IS_DELETE);
                    skuSpecs.add(skuSpec);
                }
                if (!StringUtils.isEmpty((Object)figure)) {
                    skuSpec = new SkuSpec();
                    skuSpec.setCommodityId(commodity.getCommodityId());
                    skuSpec.setSkuId(sku.getSkuId());
                    skuSpec.setSupplierId(createPASkuFromExcelReqBO.getSupplierId());
                    if (null != commodityPropGrps && commodityPropGrps.size() > 0) {
                        skuSpec.setCommodityPropGrpId(((CommodityPropGrp)commodityPropGrps.get(0)).getCommodityPropGrpId());
                    }
                    if (null != (commodityPropDefId = commodityPropDefMap.get("\u56fe\u53f7"))) {
                        skuSpec.setCommoditySpecId(commodityPropDefId);
                    }
                    skuSpec.setPropName("\u56fe\u53f7");
                    skuSpec.setPropShowName("\u56fe\u53f7");
                    propValueList = this.initPropValueList(commodityPropDefId, "\u56fe\u53f7", figure);
                    if (null != propValueList) {
                        skuSpec.setPropValueListId(propValueList.getPropValueListId());
                    }
                    skuSpec.setPropValue(figure);
                    skuSpec.setCreateLoginId(createPASkuFromExcelReqBO.getUserId());
                    skuSpec.setCreateTime(new Date());
                    skuSpec.setIsDelete(Constant.IS_DELETE);
                    skuSpecs.add(skuSpec);
                }
                if (!StringUtils.isEmpty((Object)spec)) {
                    skuSpec = new SkuSpec();
                    skuSpec.setCommodityId(commodity.getCommodityId());
                    skuSpec.setSkuId(sku.getSkuId());
                    skuSpec.setSupplierId(createPASkuFromExcelReqBO.getSupplierId());
                    if (null != commodityPropGrps && commodityPropGrps.size() > 0) {
                        skuSpec.setCommodityPropGrpId(((CommodityPropGrp)commodityPropGrps.get(0)).getCommodityPropGrpId());
                    }
                    if (null != (commodityPropDefId = commodityPropDefMap.get("\u89c4\u683c"))) {
                        skuSpec.setCommoditySpecId(commodityPropDefId);
                    }
                    skuSpec.setPropName("\u89c4\u683c");
                    skuSpec.setPropShowName("\u89c4\u683c");
                    propValueList = this.initPropValueList(commodityPropDefId, "\u89c4\u683c", spec);
                    if (null != propValueList) {
                        skuSpec.setPropValueListId(propValueList.getPropValueListId());
                    }
                    skuSpec.setPropValue(spec);
                    skuSpec.setCreateLoginId(createPASkuFromExcelReqBO.getUserId());
                    skuSpec.setCreateTime(new Date());
                    skuSpec.setIsDelete(Constant.IS_DELETE);
                    skuSpecs.add(skuSpec);
                }
                if (!StringUtils.isEmpty((Object)texture)) {
                    skuSpec = new SkuSpec();
                    skuSpec.setCommodityId(commodity.getCommodityId());
                    skuSpec.setSkuId(sku.getSkuId());
                    skuSpec.setSupplierId(createPASkuFromExcelReqBO.getSupplierId());
                    if (null != commodityPropGrps && commodityPropGrps.size() > 0) {
                        skuSpec.setCommodityPropGrpId(((CommodityPropGrp)commodityPropGrps.get(0)).getCommodityPropGrpId());
                    }
                    if (null != (commodityPropDefId = commodityPropDefMap.get("\u6750\u8d28"))) {
                        skuSpec.setCommoditySpecId(commodityPropDefId);
                    }
                    skuSpec.setPropName("\u6750\u8d28");
                    skuSpec.setPropShowName("\u6750\u8d28");
                    propValueList = this.initPropValueList(commodityPropDefId, "\u6750\u8d28", texture);
                    if (null != propValueList) {
                        skuSpec.setPropValueListId(propValueList.getPropValueListId());
                    }
                    skuSpec.setPropValue(texture);
                    skuSpec.setCreateLoginId(createPASkuFromExcelReqBO.getUserId());
                    skuSpec.setCreateTime(new Date());
                    skuSpec.setIsDelete(Constant.IS_DELETE);
                    skuSpecs.add(skuSpec);
                }
            }
            return skuSpecs;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u5546\u54c1\u89c4\u683c\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5546\u54c1\u89c4\u683c\u5931\u8d25");
        }
    }

    private void sendMsgForSkuSyncExceptionLog(CreatePASkuFromExcelReqBO createPASkuFromExcelReqBO, String errorMsg, AgrDetailBO agrDetailBO) {
        SkuSyncExceptionLogBO skuSyncExceptionLogBO = new SkuSyncExceptionLogBO();
        try {
            SkuSyncExceptionLog skuSyncExceptionLog = new SkuSyncExceptionLog();
            skuSyncExceptionLog.setSkuName(agrDetailBO.getSkuName());
            skuSyncExceptionLog.setExtSkuId(null);
            skuSyncExceptionLog.setSkuLocation(1);
            skuSyncExceptionLog.setSupplierId(createPASkuFromExcelReqBO.getSupplierId());
            skuSyncExceptionLog.setCreateLoginId(createPASkuFromExcelReqBO.getUserId());
            skuSyncExceptionLog.setCreateTime(new Date());
            skuSyncExceptionLog.setIsDelete(Constant.IS_DELETE);
            skuSyncExceptionLog.setErrorMsg(errorMsg);
            BeanUtils.copyProperties((Object)skuSyncExceptionLogBO, (Object)skuSyncExceptionLog);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u5355\u54c1\u540c\u6b65\u5f02\u5e38\u65e5\u5fd7\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5355\u54c1\u540c\u6b65\u5f02\u5e38\u65e5\u5fd7\u5931\u8d25");
        }
        try {
            this.skuSyncExceptionLogInstProducer.sendOneway(new ProxyMessage(this.topicConfig.getSkuSyncInsertTopicName(), this.topicConfig.getSkuSyncInsertTagName(), JSONObject.toJSONString((Object)skuSyncExceptionLogBO)));
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u53d1\u9001\u521d\u59cb\u5316\u5355\u54c1\u540c\u6b65\u5f02\u5e38\u65e5\u5fd7\u6d88\u606f\u5931\u8d25" + e);
            throw new BusinessException(null, "\u53d1\u9001\u521d\u59cb\u5316\u5355\u54c1\u540c\u6b65\u5f02\u5e38\u65e5\u5fd7\u6d88\u606f\u5931\u8d25");
        }
    }

    private PropValueList initPropValueList(Long commodityPropDefId, String propName, String propValue) {
        try {
            long vlTime0 = System.currentTimeMillis();
            PropValueList propValueList = new PropValueList();
            propValueList.setCommodityPropDefId(commodityPropDefId);
            propValueList.setPropCode(propName);
            propValueList.setPropValue(propValue);
            PropValueList oldPropValueList = this.propValueListMapper.selectByValue(propValueList);
            long vlTime1 = System.currentTimeMillis();
            this.propvaluelistTime = this.propvaluelistTime + (vlTime1 - vlTime0);
            if (null == oldPropValueList && null != propValue) {
                GeneratePropValueListSeqRspBO generatePropValueListSeqRspBO = this.generatePropValueListSeqService.generatePropValueListSeq();
                long vlTime2 = System.currentTimeMillis();
                this.propvaluelistseqTime = this.propvaluelistseqTime + (vlTime2 - vlTime1);
                oldPropValueList = new PropValueList();
                oldPropValueList.setPropValueListId(generatePropValueListSeqRspBO.getPropValueListId());
                PropValueListConsumerBO propValueListConsumerBO = new PropValueListConsumerBO();
                propValueListConsumerBO.setPropValueListId(generatePropValueListSeqRspBO.getPropValueListId());
                propValueListConsumerBO.setCommodityPropDefId(commodityPropDefId);
                propValueListConsumerBO.setPropCode(propName);
                propValueListConsumerBO.setPropValue(propValue);
                propValueListConsumerBO.setCreateTime(new Date());
                propValueListConsumerBO.setIsDelete(Byte.valueOf(Constant.IS_DELETE.byteValue()));
                this.propValueListInstServiceProducer.sendOneway(new ProxyMessage(this.topicConfig.getPropValueListTopicName(), this.topicConfig.getPropValueListTagName(), JSONObject.toJSONString((Object)propValueListConsumerBO)));
                long vlTime3 = System.currentTimeMillis();
                this.propvaluelistmqTime = this.propvaluelistmqTime + (vlTime3 - vlTime2);
            }
            return oldPropValueList;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u521d\u59cb\u5316\u5c5e\u6027\u503c\u5931\u8d25" + e);
            throw new BusinessException(null, "\u521d\u59cb\u5316\u5c5e\u6027\u503c\u5931\u8d25");
        }
    }
}

