/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.CheckPurchasableService;
import com.cgd.commodity.busi.QrySkuByAgrService;
import com.cgd.commodity.busi.bo.QrySkuByAgrReqBO;
import com.cgd.commodity.busi.bo.QrySkuByAgrRspBO;
import com.cgd.commodity.busi.bo.SkuConversionRspBO;
import com.cgd.commodity.busi.vo.QrySkuAgrAddPriceRspVO;
import com.cgd.commodity.busi.vo.QrySkuAgrRspVO;
import com.cgd.commodity.dao.AgreementScopeMapper;
import com.cgd.commodity.dao.ExtSkuConversionMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SkuPriceMapper;
import com.cgd.commodity.dao.SupplierAgreementMapper;
import com.cgd.commodity.dao.SupplierAgreementSkuMapper;
import com.cgd.commodity.po.AgreementScope;
import com.cgd.commodity.po.SkuPrice;
import com.cgd.commodity.po.SupplierAgreementSku;
import com.cgd.user.org.busi.QryLittleActOrgByUserBusiService;
import com.cgd.user.org.busi.bo.QryLittleActOrgByUserReqBO;
import com.cgd.user.org.busi.bo.QryLittleActOrgByUserRspBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class QrySkuByAgrServiceImpl
implements QrySkuByAgrService {
    private static final Logger logger = LoggerFactory.getLogger(QrySkuByAgrServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;
    private SupplierAgreementMapper supplierAgreementMapper;
    @Autowired
    private ExtSkuConversionMapper extSkuConversionMapper;
    @Autowired
    private CheckPurchasableService checkPurchasableService;
    @Autowired
    private SkuPriceMapper skuPriceMapper;
    @Autowired
    private AgreementScopeMapper agreementScopeMapper;
    @Autowired
    private QryLittleActOrgByUserBusiService qryLittleActOrgByUserBusiService;
    @Autowired
    private SupplierAgreementSkuMapper supplierAgreementSkuMapper;

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public QrySkuByAgrRspBO qrySkuByAgr(QrySkuByAgrReqBO qrySkuByAgrReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qrySkuByAgrReqBO.toString());
        }
        if (null == qrySkuByAgrReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u94fa\u8d27\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (qrySkuByAgrReqBO.getSkuIds().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u4e1a\u52a1\u670d\u52a1SKUID\u96c6\u5408[skuIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            List<QrySkuAgrRspVO> skuAgrs = this.qrySku(qrySkuByAgrReqBO);
            ArrayList<Long> agrIds = new ArrayList<Long>();
            List<Object> newSkuAgrs = new ArrayList();
            if (!skuAgrs.isEmpty()) {
                List<SupplierAgreementSku> agreementSkus;
                List<AgreementScope> agreementScopeList;
                ArrayList<Long> allSkuIds = new ArrayList<Long>();
                allSkuIds.addAll(qrySkuByAgrReqBO.getSkuIds());
                for (QrySkuAgrRspVO qrySkuAgrRspVO : skuAgrs) {
                    if (allSkuIds.contains(qrySkuAgrRspVO.getSkuId())) {
                        allSkuIds.remove(qrySkuAgrRspVO.getSkuId());
                    }
                    if (agrIds.contains(qrySkuAgrRspVO.getAgreementId())) continue;
                    agrIds.add(qrySkuAgrRspVO.getAgreementId());
                }
                newSkuAgrs = this.qryAgr(agrIds, qrySkuByAgrReqBO.getSupplierId(), skuAgrs);
                QrySkuByAgrRspBO qrySkuByAgrRspBO = new QrySkuByAgrRspBO();
                qrySkuByAgrRspBO.setSupplierId(qrySkuByAgrReqBO.getSupplierId());
                if (!newSkuAgrs.isEmpty()) {
                    qrySkuByAgrRspBO.setSupplierName(((QrySkuAgrRspVO)newSkuAgrs.get(0)).getSupplierName());
                }
                if (null != qrySkuByAgrReqBO.getUserId()) {
                    qrySkuByAgrRspBO.setIsLogin(Boolean.valueOf(true));
                    qrySkuByAgrRspBO.setSkuAgrs(newSkuAgrs);
                } else {
                    qrySkuByAgrRspBO.setIsLogin(Boolean.valueOf(false));
                    ArrayList<QrySkuAgrRspVO> newTSkuAgrs = new ArrayList<QrySkuAgrRspVO>();
                    for (QrySkuAgrRspVO qrySkuAgrRspVO : newSkuAgrs) {
                        qrySkuAgrRspVO.setAgreementPrice(null);
                        qrySkuAgrRspVO.setMemberPrice(null);
                        qrySkuAgrRspVO.setSalePrice(null);
                        newTSkuAgrs.add(qrySkuAgrRspVO);
                        qrySkuByAgrRspBO.setSkuAgrs(newTSkuAgrs);
                    }
                }
                QryLittleActOrgByUserReqBO qryLittleActOrgByUserReqBO = new QryLittleActOrgByUserReqBO();
                qryLittleActOrgByUserReqBO.setUserParamId(qrySkuByAgrReqBO.getUserId());
                QryLittleActOrgByUserRspBO qryLittleActOrgByUserRspBO = this.qryLittleActOrgByUserBusi(qryLittleActOrgByUserReqBO);
                ArrayList<Long> arrayList = new ArrayList<Long>();
                ArrayList<Long> agreementSkuIds = new ArrayList<Long>();
                HashMap<Long, Long> agrSkuIdMap = new HashMap<Long, Long>();
                Map<Long, Integer> flagMap = null;
                HashMap<Long, SupplierAgreementSku> materialNameMap = new HashMap<Long, SupplierAgreementSku>();
                Integer flag = 0;
                List<SkuPrice> skuPrices = this.skuPriceMapper.selectBySkuIdsAndSupplierId(qrySkuByAgrReqBO.getSkuIds(), qrySkuByAgrReqBO.getSupplierId());
                if (skuPrices != null && skuPrices.size() > 0) {
                    for (SkuPrice skuPrice : skuPrices) {
                        arrayList.add(skuPrice.getAgreementId());
                        agreementSkuIds.add(skuPrice.getAgreementSkuId());
                        agrSkuIdMap.put(skuPrice.getSkuId(), skuPrice.getAgreementSkuId());
                    }
                }
                if (arrayList != null && arrayList.size() > 0) {
                    agreementScopeList = this.agreementScopeMapper.selectByAgreementIds(arrayList, qrySkuByAgrReqBO.getSupplierId());
                    if (agreementScopeList == null || agreementScopeList.size() <= 0) {
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u534f\u8baeId\u67e5\u8be2\u5546\u54c1\u534f\u8bae\u8303\u56f4\u8868\u6570\u636e\u4e0d\u5b58\u5728");
                    }
                } else {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u4f9b\u8d27\u5546Id\u548cSkuId\u67e5\u8be2\u5546\u54c1\u4ef7\u683c\u8868\u6570\u636e\u4e0d\u5b58\u5728");
                }
                flagMap = this.checkPurchasableList(agreementScopeList, qryLittleActOrgByUserRspBO);
                if (agreementSkuIds != null && agreementSkuIds.size() > 0 && (agreementSkus = this.supplierAgreementSkuMapper.selectByIds(qrySkuByAgrReqBO.getSupplierId(), agreementSkuIds)) != null && agreementSkus.size() > 0) {
                    for (SupplierAgreementSku supplierAgreementSku : agreementSkus) {
                        materialNameMap.put(supplierAgreementSku.getAgreementSkuId(), supplierAgreementSku);
                    }
                }
                HashMap<Long, SkuConversionRspBO> skuConversionRspBOMap = new HashMap<Long, SkuConversionRspBO>();
                List<SkuConversionRspBO> list = this.extSkuConversionMapper.qrySkuConversionByIds(qrySkuByAgrReqBO.getSkuIds(), qrySkuByAgrReqBO.getSupplierId());
                for (SkuConversionRspBO skuConversionRspBO : list) {
                    skuConversionRspBOMap.put(skuConversionRspBO.getSkuId(), skuConversionRspBO);
                }
                for (QrySkuAgrRspVO qrySkuAgrRspVO : qrySkuByAgrRspBO.getSkuAgrs()) {
                    SupplierAgreementSku SupplierAgreementSku2;
                    SkuConversionRspBO skuConversionRspBO = (SkuConversionRspBO)skuConversionRspBOMap.get(qrySkuAgrRspVO.getSkuId());
                    if (skuConversionRspBO != null) {
                        qrySkuAgrRspVO.setSaleunit(skuConversionRspBO.getSaleunit());
                        qrySkuAgrRspVO.setSettlerate(skuConversionRspBO.getSettlerate());
                        qrySkuAgrRspVO.setSettleunit(skuConversionRspBO.getSettleunit());
                        qrySkuAgrRspVO.setWarenum(skuConversionRspBO.getWarenum());
                        qrySkuAgrRspVO.setIsShowSpec(skuConversionRspBO.getIsShowSpec());
                    }
                    if (flagMap != null && flagMap.get(qrySkuAgrRspVO.getAgreementId()) != null) {
                        flag = flagMap.get(qrySkuAgrRspVO.getAgreementId());
                    }
                    qrySkuAgrRspVO.setPurchasableFlag(flag);
                    if (materialNameMap == null || agrSkuIdMap == null || (SupplierAgreementSku2 = (SupplierAgreementSku)materialNameMap.get(agrSkuIdMap.get(qrySkuAgrRspVO.getSkuId()))) == null) continue;
                    qrySkuAgrRspVO.setMaterialName(SupplierAgreementSku2.getMaterialName());
                    qrySkuAgrRspVO.setMaterialId(SupplierAgreementSku2.getMaterialId());
                }
                qrySkuByAgrRspBO.setResultMsg(this.noExitSkuId(allSkuIds));
                if (this.isDebugEnabled) {
                    logger.debug("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u51fa\u53c2\u53c2\uff1a" + qrySkuByAgrRspBO.toString());
                }
                return qrySkuByAgrRspBO;
            }
            throw new BusinessException("RSP_CODE_SKU_NOT_EXIST", "\u5546\u54c1\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)((Object)e)).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)((Object)e)).getMsgCode();
                throw new BusinessException(resultCode, e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private List<QrySkuAgrRspVO> qrySku(QrySkuByAgrReqBO qrySkuByAgrReqBO) throws Exception {
        try {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("supplierId", qrySkuByAgrReqBO.getSupplierId());
            paramMap.put("skuIds", qrySkuByAgrReqBO.getSkuIds());
            return this.skuMapper.selectSkuInfoBySupAgrSkuIds(paramMap);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u3001\u4ef7\u683c\u3001\u89c4\u683c\u5931\u8d25\uff1a" + e);
            throw new Exception("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u3001\u4ef7\u683c\u3001\u89c4\u683c\u5931\u8d25" + e);
        }
    }

    private String noExitSkuId(List<Long> skuIds) {
        StringBuffer sb = new StringBuffer();
        if (!skuIds.isEmpty()) {
            sb.append("[");
            for (int i = 0; i < skuIds.size(); ++i) {
                if (i == skuIds.size() - 1) {
                    sb.append(skuIds.get(i));
                    continue;
                }
                sb.append(skuIds.get(i)).append(",");
            }
            sb.append("]");
            return "\u5546\u54c1" + sb.toString() + "\u4e0d\u5b58\u5728";
        }
        return null;
    }

    private List<QrySkuAgrRspVO> qryAgr(List<Long> agrIds, Long supplierId, List<QrySkuAgrRspVO> skuAgrs) throws Exception {
        try {
            ArrayList<QrySkuAgrRspVO> qrySkuAgrRspVOs = new ArrayList<QrySkuAgrRspVO>();
            List<QrySkuAgrAddPriceRspVO> qrySkuAgrAddPriceRspVOs = this.supplierAgreementMapper.qryAgrAndAddPriceById(agrIds, supplierId);
            HashMap<Long, QrySkuAgrAddPriceRspVO> qrySkuAgrAddPriceRspVOMap = new HashMap<Long, QrySkuAgrAddPriceRspVO>();
            if (null != qrySkuAgrAddPriceRspVOs && qrySkuAgrAddPriceRspVOs.size() > 0) {
                for (QrySkuAgrAddPriceRspVO qrySkuAgrAddPriceRspVO : qrySkuAgrAddPriceRspVOs) {
                    qrySkuAgrAddPriceRspVOMap.put(qrySkuAgrAddPriceRspVO.getAgreementId(), qrySkuAgrAddPriceRspVO);
                }
                for (QrySkuAgrRspVO qrySkuAgrRspVO : skuAgrs) {
                    QrySkuAgrAddPriceRspVO qrySkuAgrAddPriceRspVO = (QrySkuAgrAddPriceRspVO)qrySkuAgrAddPriceRspVOMap.get(qrySkuAgrRspVO.getAgreementId());
                    qrySkuAgrRspVO.setAgr(qrySkuAgrAddPriceRspVO.getAgr());
                    qrySkuAgrRspVO.setAgreementId(qrySkuAgrAddPriceRspVO.getAgreementId());
                    qrySkuAgrRspVO.setAgreementName(qrySkuAgrAddPriceRspVO.getAgreementName());
                    qrySkuAgrRspVO.setAgreementSrc(qrySkuAgrAddPriceRspVO.getAgreementSrc());
                    qrySkuAgrRspVO.setAgreementStatus(qrySkuAgrAddPriceRspVO.getAgreementStatus());
                    qrySkuAgrRspVO.setAgreementType(qrySkuAgrAddPriceRspVO.getAgreementType());
                    qrySkuAgrRspVO.setEntAgreementCode(qrySkuAgrAddPriceRspVO.getEntAgreementCode());
                    qrySkuAgrRspVO.setIsDispatch(qrySkuAgrAddPriceRspVO.getIsDispatch());
                    qrySkuAgrRspVO.setPlaAgreementCode(qrySkuAgrAddPriceRspVO.getPlaAgreementCode());
                    qrySkuAgrRspVO.setSkuAgrAddPriceProps(qrySkuAgrAddPriceRspVO.getSkuAgrAddPriceProps());
                    qrySkuAgrRspVO.setTaxRate(qrySkuAgrAddPriceRspVO.getTaxRate());
                    if (qrySkuAgrAddPriceRspVO.getAgrLocation() != null) {
                        qrySkuAgrRspVO.setSkuLocation(Integer.valueOf(qrySkuAgrAddPriceRspVO.getAgrLocation().intValue()));
                    }
                    qrySkuAgrRspVOs.add(qrySkuAgrRspVO);
                }
            }
            return qrySkuAgrRspVOs;
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u534f\u8bae\u4fe1\u606f\u5931\u8d25\uff1a" + e);
            throw new Exception("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u534f\u8bae\u4fe1\u606f\u5931\u8d25" + e);
        }
    }

    private QryLittleActOrgByUserRspBO qryLittleActOrgByUserBusi(QryLittleActOrgByUserReqBO qryLittleActOrgByUserReqBO) {
        try {
            QryLittleActOrgByUserRspBO qryLittleActOrgByUser = this.qryLittleActOrgByUserBusiService.qryLittleActOrgByUser(qryLittleActOrgByUserReqBO);
            return qryLittleActOrgByUser;
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u7528\u6237\u67e5\u8be2\u5206\u5b50\u516c\u53f8\u3001\u9879\u76ee\u5355\u4f4d\u4fe1\u606f\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u6839\u636e\u7528\u6237\u67e5\u8be2\u5206\u5b50\u516c\u53f8\u3001\u9879\u76ee\u5355\u4f4d\u4fe1\u606f\u5931\u8d25");
        }
    }

    private Map<Long, Integer> checkPurchasableList(List<AgreementScope> agreementScopeList, QryLittleActOrgByUserRspBO qryLittleActOrgByUserRspBO) {
        HashMap<Long, Integer> flgMap = new HashMap<Long, Integer>();
        if (qryLittleActOrgByUserRspBO == null) {
            return flgMap;
        }
        if (agreementScopeList != null && agreementScopeList.size() > 0) {
            for (AgreementScope agreementScope : agreementScopeList) {
                if (agreementScope.getScopeType() != null && agreementScope.getScopeType() == 0) {
                    flgMap.put(agreementScope.getAgreementId(), 1);
                    break;
                }
                if (agreementScope.getScopeType() != null && agreementScope.getScopeType() == 1 && qryLittleActOrgByUserRspBO.getProvId() != null && qryLittleActOrgByUserRspBO.getProvId().equals(agreementScope.getScopeCode())) {
                    flgMap.put(agreementScope.getAgreementId(), 1);
                    break;
                }
                if (agreementScope.getScopeType() != null && agreementScope.getScopeType() == 2 && qryLittleActOrgByUserRspBO.getTrade() != null && qryLittleActOrgByUserRspBO.getTrade().equals(agreementScope.getScopeCode())) {
                    flgMap.put(agreementScope.getAgreementId(), 1);
                    break;
                }
                if (agreementScope.getScopeType() != null && agreementScope.getScopeType() == 3 && qryLittleActOrgByUserRspBO.getBranchComp() != null && qryLittleActOrgByUserRspBO.getBranchComp().getAutoId() != null && qryLittleActOrgByUserRspBO.getBranchComp().getAutoId().equals(agreementScope.getScopeCode())) {
                    flgMap.put(agreementScope.getAgreementId(), 1);
                    break;
                }
                if (agreementScope.getScopeType() != null && agreementScope.getScopeType() == 4 && qryLittleActOrgByUserRspBO.getProjectComp() != null && qryLittleActOrgByUserRspBO.getProjectComp().getAutoId() != null && qryLittleActOrgByUserRspBO.getProjectComp().getAutoId().equals(agreementScope.getScopeCode())) {
                    flgMap.put(agreementScope.getAgreementId(), 1);
                    break;
                }
                flgMap.put(agreementScope.getAgreementId(), 0);
            }
        }
        return flgMap;
    }
}

