/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class SpecialSymbolUtils {
    public static final String DEFAULT_QUERY_REGEX = "[!$^&*+=|{}';'\",<>/?~\uff01#\uffe5%\u2026\u2026&*\u2014\u2014|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c'\u3002\uff0c\u3001\uff1f]";

    public static boolean isSpecialSymbols(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        Pattern pattern = Pattern.compile(SpecialSymbolUtils.getQueryRegex());
        Matcher matcher = pattern.matcher(value);
        char[] specialSymbols = SpecialSymbolUtils.getQueryRegex().toCharArray();
        boolean isStartWithSpecialSymbol = false;
        for (int i = 0; i < specialSymbols.length; ++i) {
            char c = specialSymbols[i];
            if (value.indexOf(c) != value.length() - 1) continue;
            isStartWithSpecialSymbol = true;
            break;
        }
        return matcher.find() && isStartWithSpecialSymbol;
    }

    public static char specialSymbol(String value) {
        char x = '\u0000';
        if (StringUtils.isBlank((CharSequence)value)) {
            return x;
        }
        char[] specialSymbols = SpecialSymbolUtils.getQueryRegex().toCharArray();
        for (int i = 0; i < specialSymbols.length; ++i) {
            char c = specialSymbols[i];
            if (value.indexOf(c) != value.length() - 1) continue;
            x = c;
            break;
        }
        return x;
    }

    protected static String getQueryRegex() {
        return DEFAULT_QUERY_REGEX;
    }

    public static void main(String[] args) {
        String str = "7/64\"";
        System.out.println(SpecialSymbolUtils.isSpecialSymbols(str));
        char x = SpecialSymbolUtils.specialSymbol(str);
        System.out.println(x);
        str = str.replace(String.valueOf(x), "\\" + String.valueOf(x));
        System.out.println(str);
    }
}

