/*
 * Decompiled with CFR 0.152.
 */
package com.gd.commodity.busi.impl;

import com.cgd.user.org.busi.QryDistDepartmentBusiService;
import com.cgd.user.org.busi.bo.QryDistDepartmentReqBO;
import com.cgd.user.org.busi.bo.QryDistDepartmentRspBO;
import com.gd.commodity.busi.ModityAgStatusByagrIdService;
import com.gd.commodity.busi.bo.agreement.ModityAgrInfoRspBO;
import com.gd.commodity.constant.Constant;
import com.gd.commodity.dao.SupplierAgreementMapper;
import com.gd.commodity.po.SupplierAgreement;
import com.ohaotian.plugin.base.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ModityAgStatusByagrIdServiceImpl
implements ModityAgStatusByagrIdService {
    private static final Logger logger = LoggerFactory.getLogger(ModityAgStatusByagrIdServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SupplierAgreementMapper supplierAgreementMapper;
    @Autowired
    private QryDistDepartmentBusiService qryDistDepartmentBusiService;

    public ModityAgrInfoRspBO updateAgrStatusInfo(ModityAgrInfoRspBO modityAgrInfoRspBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u4fee\u6539\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + modityAgrInfoRspBO.toString());
        }
        try {
            SupplierAgreement supplierAgreement = this.supplierAgreementMapper.selectByIds(modityAgrInfoRspBO.getAgreementId(), modityAgrInfoRspBO.getSupplierId());
            if (null == supplierAgreement) {
                modityAgrInfoRspBO.setIsSuccess(Boolean.valueOf(false));
                modityAgrInfoRspBO.setResultMsg("\u534f\u8bae\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
                return modityAgrInfoRspBO;
            }
            QryDistDepartmentReqBO reqBO = new QryDistDepartmentReqBO();
            reqBO.setOrgId(modityAgrInfoRspBO.getSupplierId());
            if (supplierAgreement.getAgrLocation() == 1) {
                reqBO.setTypeArea(Integer.valueOf(1));
            } else if (supplierAgreement.getAgrLocation() == 5) {
                reqBO.setTypeArea(Integer.valueOf(5));
            }
            QryDistDepartmentRspBO rspBo = this.qryDistDepartmentBusiService.qryDistDepartment(reqBO);
            if (rspBo == null || !"0000".equals(rspBo.getRespCode())) {
                logger.error("\u901a\u8fc7\u7ec4\u7ec7\u673a\u6784\u67e5\u8be2\u94fa\u8d27\u90e8\u95e8\u5931\u8d25");
                throw new BusinessException("RSP_CODE_DAO_ERROR", rspBo.getRespDesc());
            }
            logger.debug(rspBo.toString());
            supplierAgreement.setVendorDepartmentId(rspBo.getDistributionDepartId());
            supplierAgreement.setVendorDepartmentName(rspBo.getDistributionDepartName());
            supplierAgreement.setAssignStatus((byte)1);
            supplierAgreement.setProducerId(666L);
            supplierAgreement.setAgreementStatus(Constant.AGR_STATUS_DRAFT.byteValue());
            this.supplierAgreementMapper.updateByPrimaryKeySelective(supplierAgreement);
            modityAgrInfoRspBO.setIsSuccess(Boolean.valueOf(true));
            modityAgrInfoRspBO.setResultMsg("\u8f6c\u5546\u57ce\u534f\u8bae\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u4fee\u6539\u6846\u67b6\u534f\u8bae\u5931\u8d25", (Throwable)e);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u4fee\u6539\u6846\u67b6\u534f\u8bae\u5931\u8d25");
        }
        return modityAgrInfoRspBO;
    }
}

