/*
 * Decompiled with CFR 0.152.
 */
package com.gd.commodity.busi.impl;

import com.cgd.user.org.busi.QryDistDepartmentBusiService;
import com.cgd.user.org.busi.bo.QryDistDepartmentReqBO;
import com.cgd.user.org.busi.bo.QryDistDepartmentRspBO;
import com.gd.commodity.busi.DelSupplierAgreementByIdService;
import com.gd.commodity.busi.ModityAgStatusByagrIdService;
import com.gd.commodity.busi.bo.agreement.AgrAttach;
import com.gd.commodity.busi.bo.agreement.ModityAgrInfoRspBO;
import com.gd.commodity.constant.Constant;
import com.gd.commodity.dao.AgreementScopeMapper;
import com.gd.commodity.dao.SupplierAgreementAttachMapper;
import com.gd.commodity.dao.SupplierAgreementMapper;
import com.gd.commodity.dao.SupplierAgreementSkuMapper;
import com.gd.commodity.po.AgreementScope;
import com.gd.commodity.po.SupplierAgreement;
import com.gd.commodity.po.SupplierAgreementAttach;
import com.gd.commodity.po.SupplierAgreementSku;
import com.ohaotian.plugin.base.bo.RspBusiBaseBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ModityAgStatusByagrIdServiceImpl
implements ModityAgStatusByagrIdService {
    private static final Logger logger = LoggerFactory.getLogger(ModityAgStatusByagrIdServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SupplierAgreementMapper supplierAgreementMapper;
    @Autowired
    private QryDistDepartmentBusiService qryDistDepartmentBusiService;
    @Autowired
    private DelSupplierAgreementByIdService delSupplierAgreementByIdService;
    @Autowired
    private SupplierAgreementSkuMapper supplierAgreementSkuMapper;
    @Autowired
    private SupplierAgreementAttachMapper supplierAgreementAttachMapper;
    @Autowired
    private AgreementScopeMapper agreementScopeMapper;

    public ModityAgrInfoRspBO updateAgrStatusInfo(ModityAgrInfoRspBO modityAgrInfoRspBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u4fee\u6539\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + modityAgrInfoRspBO.toString());
        }
        try {
            SupplierAgreement supplierAgreement = this.supplierAgreementMapper.selectByIds(modityAgrInfoRspBO.getAgreementId(), modityAgrInfoRspBO.getSupplierId());
            if (null == supplierAgreement) {
                modityAgrInfoRspBO.setIsSuccess(Boolean.valueOf(false));
                modityAgrInfoRspBO.setResultMsg("\u534f\u8bae\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
                return modityAgrInfoRspBO;
            }
            supplierAgreement.setAssignStatus((byte)1);
            supplierAgreement.setProducerId(666L);
            supplierAgreement.setAgreementStatus(Constant.AGR_STATUS_DRAFT.byteValue());
            supplierAgreement.setSupplierId(supplierAgreement.getUnitAccountId());
            supplierAgreement.setSupplierName(supplierAgreement.getUnitAccountName());
            supplierAgreement.setAgreementSrc((byte)2);
            List<SupplierAgreementSku> supplierAgreementSkus = this.supplierAgreementSkuMapper.selectByAgrId(modityAgrInfoRspBO.getAgreementId(), modityAgrInfoRspBO.getSupplierId());
            for (SupplierAgreementSku supplierAgreementSku : supplierAgreementSkus) {
                supplierAgreementSku.setSupplierId(supplierAgreement.getUnitAccountId());
            }
            List<AgrAttach> agrAttachs = this.supplierAgreementAttachMapper.qryAgrAttach(modityAgrInfoRspBO.getAgreementId(), modityAgrInfoRspBO.getSupplierId());
            List<AgreementScope> agreementScopes = this.agreementScopeMapper.selectByAgreementId(modityAgrInfoRspBO.getAgreementId(), modityAgrInfoRspBO.getSupplierId());
            for (AgreementScope agreementScope : agreementScopes) {
                agreementScope.setSupplierId(supplierAgreement.getSupplierId());
            }
            QryDistDepartmentReqBO reqBO = new QryDistDepartmentReqBO();
            reqBO.setOrgId(modityAgrInfoRspBO.getSupplierId());
            if (1 == supplierAgreement.getAgrLocation()) {
                reqBO.setTypeArea(Integer.valueOf(1));
            } else if (5 == supplierAgreement.getAgrLocation()) {
                reqBO.setTypeArea(Integer.valueOf(5));
            }
            QryDistDepartmentRspBO rspBo = this.qryDistDepartmentBusiService.qryDistDepartment(reqBO);
            if (rspBo == null || !"0000".equals(rspBo.getRespCode())) {
                logger.error("\u672a\u5339\u914d\u5230\u94fa\u8d27\u90e8\u95e8");
                throw new BusinessException("RSP_CODE_DAO_ERROR", rspBo.getRespDesc());
            }
            logger.debug(rspBo.toString());
            supplierAgreement.setVendorDepartmentId(rspBo.getDistributionDepartId());
            supplierAgreement.setVendorDepartmentName(rspBo.getDistributionDepartName());
            RspBusiBaseBO rspBusiBaseBO = this.delSupplierAgreementByIdService.delSupplierAgreement(modityAgrInfoRspBO.getAgreementId(), modityAgrInfoRspBO.getSupplierId());
            if (!rspBusiBaseBO.getRespCode().equals("0000")) {
                logger.error("\u5220\u9664\u534f\u8bae\u5931\u8d25");
                throw new BusinessException("RSP_CODE_DAO_ERROR", "\u5220\u9664\u534f\u8bae\u5931\u8d25");
            }
            logger.debug("supplierAgreement\u660e\u7ec62" + supplierAgreement);
            this.supplierAgreementMapper.insertSelective(supplierAgreement);
            if (!supplierAgreementSkus.isEmpty()) {
                this.supplierAgreementSkuMapper.batchInsert(supplierAgreementSkus);
            }
            if (!agreementScopes.isEmpty()) {
                this.agreementScopeMapper.insertAgrScopeBatch(agreementScopes);
            }
            if (!agrAttachs.isEmpty()) {
                ArrayList<SupplierAgreementAttach> list = new ArrayList<SupplierAgreementAttach>();
                for (AgrAttach agrAttach : agrAttachs) {
                    SupplierAgreementAttach supplierAgreementAttach = new SupplierAgreementAttach();
                    BeanUtils.copyProperties((Object)agrAttach, (Object)supplierAgreementAttach);
                    supplierAgreementAttach.setSupplierId(supplierAgreement.getSupplierId());
                    supplierAgreementAttach.setAgreementId(agrAttach.getAgreementID());
                    supplierAgreementAttach.setAttachmentType((byte)agrAttach.getAttachmentType().intValue());
                    supplierAgreementAttach.setIsDelete((byte)agrAttach.getIsDelete().intValue());
                    list.add(supplierAgreementAttach);
                }
                this.supplierAgreementAttachMapper.insertAgrAttachBatch(list);
            }
            modityAgrInfoRspBO.setIsSuccess(Boolean.valueOf(true));
            modityAgrInfoRspBO.setResultMsg("\u8f6c\u5546\u57ce\u534f\u8bae\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u4fee\u6539\u6846\u67b6\u534f\u8bae\u5931\u8d25", (Throwable)e);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u65b0\u589e\u6846\u67b6\u534f\u8bae\u5931\u8d25");
        }
        return modityAgrInfoRspBO;
    }
}

