/*
 * Decompiled with CFR 0.152.
 */
package com.gd.commodity.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.gd.commodity.busi.AgreementApproveTaskService;
import com.gd.commodity.busi.SubmitAgrService;
import com.gd.commodity.busi.bo.agreement.AgreementApproveTaskStartRspBO;
import com.gd.commodity.busi.bo.agreement.AgreementChangeBO;
import com.gd.commodity.busi.bo.agreement.SubmitAgrReqBO;
import com.gd.commodity.busi.bo.agreement.SubmitAgrRspBO;
import com.gd.commodity.busi.vo.agreement.AgrAdjustPriceFormulaRspVO;
import com.gd.commodity.dao.AgrAdjustPriceFormulaMapper;
import com.gd.commodity.dao.SupplierAgreementMapper;
import com.gd.commodity.dao.SupplierAgreementSkuMapper;
import com.gd.commodity.intfce.bo.agreement.CreateAgrApproveLogConsumerBO;
import com.gd.commodity.po.SupplierAgreement;
import com.gd.commodity.po.SupplierAgreementSku;
import com.ohaotian.commodity.config.TopicConfig;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

public class SubmitAgrServiceImpl
implements SubmitAgrService {
    private static final Logger logger = LoggerFactory.getLogger(SubmitAgrServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SupplierAgreementMapper supplierAgreementMapper;
    private SupplierAgreementSkuMapper supplierAgreementSkuMapper;
    private AgrAdjustPriceFormulaMapper agrAdjustPriceFormulaMapper;
    private AgreementApproveTaskService agreementApproveTaskService;
    @Resource
    TopicConfig topicConfig;
    @Resource(name="createAgrApproveLogProducer")
    private ProxyMessageProducer createAgrApproveLogProducer;

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public void setSupplierAgreementSkuMapper(SupplierAgreementSkuMapper supplierAgreementSkuMapper) {
        this.supplierAgreementSkuMapper = supplierAgreementSkuMapper;
    }

    public void setAgrAdjustPriceFormulaMapper(AgrAdjustPriceFormulaMapper agrAdjustPriceFormulaMapper) {
        this.agrAdjustPriceFormulaMapper = agrAdjustPriceFormulaMapper;
    }

    public void setAgreementApproveTaskService(AgreementApproveTaskService agreementApproveTaskService) {
        this.agreementApproveTaskService = agreementApproveTaskService;
    }

    public SubmitAgrRspBO submitAgr(SubmitAgrReqBO submitAgrReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u63d0\u4ea4\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + submitAgrReqBO.toString());
        }
        SubmitAgrRspBO submitAgrRspBO = new SubmitAgrRspBO();
        try {
            int action = submitAgrReqBO.getAction();
            int status = 0;
            SupplierAgreement supplierAgreement = this.supplierAgreementMapper.selectById(submitAgrReqBO.getAgreementId(), submitAgrReqBO.getSupplierId());
            List<SupplierAgreementSku> supplierAgreementSkus = this.supplierAgreementSkuMapper.selectByAgrId(submitAgrReqBO.getAgreementId(), submitAgrReqBO.getSupplierId());
            if (1 != supplierAgreement.getAgreementSrc() && 2 != supplierAgreement.getAgreementSrc() && (supplierAgreementSkus == null || supplierAgreementSkus.size() <= 0)) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8bf7\u6dfb\u52a0\u81f3\u5c11\u4e00\u6761\u534f\u8bae\u660e\u7ec6\uff01");
            }
            if (supplierAgreement != null && supplierAgreement.getIsAdjustPriceFormula() != null && (1 == supplierAgreement.getAgreementSrc() || 2 == supplierAgreement.getAgreementSrc()) && supplierAgreement.getIsAdjustPriceFormula() == 1 && null != supplierAgreementSkus && supplierAgreementSkus.size() > 0) {
                for (SupplierAgreementSku supplierAgreementSku : supplierAgreementSkus) {
                    List<AgrAdjustPriceFormulaRspVO> agrAdjustPriceFormulaRsp = this.agrAdjustPriceFormulaMapper.selectByAgrSkuIdAndSupId(supplierAgreementSku.getAgreementSkuId(), submitAgrReqBO.getSupplierId());
                    if (agrAdjustPriceFormulaRsp == null || agrAdjustPriceFormulaRsp.size() == 0) {
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6b64\u534f\u8bae\u542b\u6709\u8c03\u4ef7\u516c\u5f0f,\u8bf7\u786e\u8ba4\u6bcf\u6761\u534f\u8bae\u660e\u7ec6\u90fd\u6709\u8c03\u4ef7\u516c\u5f0f");
                    }
                    for (AgrAdjustPriceFormulaRspVO agrAdjustPriceFormulaRspVO : agrAdjustPriceFormulaRsp) {
                        if (null != agrAdjustPriceFormulaRspVO.getAgrFormulaInfoValue() || agrAdjustPriceFormulaRspVO.getAgrFormulaInfoType() != 0) continue;
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6b64\u534f\u8bae\u542b\u6709\u8c03\u4ef7\u516c\u5f0f,\u8bf7\u786e\u8ba4\u6bcf\u6761\u534f\u8bae\u660e\u7ec6\u7684\u8c03\u4ef7\u516c\u5f0f\u6709\u503c");
                    }
                }
            }
            if (supplierAgreement != null && 0 == supplierAgreement.getAgreementSrc() && action == 1 && null != supplierAgreementSkus && supplierAgreementSkus.size() > 0) {
                for (SupplierAgreementSku supplierAgreementSku : supplierAgreementSkus) {
                    if (StringUtils.isEmpty((Object)supplierAgreementSku.getFigure())) {
                        if (StringUtils.isEmpty((Object)supplierAgreementSku.getSpec()) && 1 == supplierAgreement.getAgreementVariety()) {
                            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7269\u6599\u7f16\u7801" + supplierAgreementSku.getMaterialId() + "\u534f\u8bae\u660e\u7ec6\u7684\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (StringUtils.isEmpty((Object)supplierAgreementSku.getModel()) && 1 == supplierAgreement.getAgreementVariety()) {
                            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7269\u6599\u7f16\u7801" + supplierAgreementSku.getMaterialId() + "\u534f\u8bae\u660e\u7ec6\u7684\u578b\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                    }
                    if (1 == supplierAgreement.getAgreementVariety() && StringUtils.isEmpty((Object)supplierAgreementSku.getMaterialName())) {
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7269\u6599\u7f16\u7801" + supplierAgreementSku.getMaterialId() + "\u534f\u8bae\u660e\u7ec6\u7684\u7269\u6599\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (null != supplierAgreementSku.getSupplyCycle()) continue;
                    if (1 == supplierAgreement.getAgreementVariety()) {
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7269\u6599\u7f16\u7801" + supplierAgreementSku.getMaterialId() + "\u534f\u8bae\u660e\u7ec6\u7684\u4f9b\u8d27\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (2 == supplierAgreement.getAgreementVariety()) {
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9879\u76ee\u7f16\u7801" + supplierAgreementSku.getMaterialId() + "\u534f\u8bae\u660e\u7ec6\u7684\u4f9b\u8d27\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (3 != supplierAgreement.getAgreementVariety()) continue;
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9879\u76ee\u7f16\u7801" + supplierAgreementSku.getMaterialId() + "\u534f\u8bae\u660e\u7ec6\u7684\u4f9b\u8d27\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if (action == 0) {
                status = 0;
            } else if (action == 1) {
                status = 2;
                AgreementChangeBO agreementChangeBO = new AgreementChangeBO();
                BeanUtils.copyProperties((Object)submitAgrReqBO, (Object)agreementChangeBO);
                agreementChangeBO.setUserId(submitAgrReqBO.getUserId());
                agreementChangeBO.setUserName(submitAgrReqBO.getUserName());
                agreementChangeBO.setChangeType(Integer.valueOf(0));
                AgreementApproveTaskStartRspBO agreementApproveTaskStartRspBO = this.agreementApproveTaskService.executeAgreementApproveTaskStartUp(agreementChangeBO);
                if (!agreementApproveTaskStartRspBO.getRespCode().equals("0000")) {
                    throw new BusinessException(agreementApproveTaskStartRspBO.getRespCode(), agreementApproveTaskStartRspBO.getRespDesc());
                }
            }
            int updateRows = this.supplierAgreementMapper.updateAgrStateBySup(submitAgrReqBO.getAgreementId(), submitAgrReqBO.getSupplierId(), status);
            if (updateRows > 0) {
                submitAgrRspBO.setSubmitState(Integer.valueOf(1));
            } else {
                submitAgrRspBO.setSubmitState(Integer.valueOf(0));
            }
        }
        catch (Exception e) {
            logger.error("\u63d0\u4ea4\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)((Object)e)).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)((Object)e)).getMsgCode();
                throw new BusinessException(resultCode, e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u63d0\u4ea4\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
        return submitAgrRspBO;
    }

    private void sendMsg(SubmitAgrReqBO submitAgrReqBO) {
        try {
            CreateAgrApproveLogConsumerBO createAgrApproveLogConsumerBO = new CreateAgrApproveLogConsumerBO();
            createAgrApproveLogConsumerBO.setAgreementId(submitAgrReqBO.getAgreementId());
            createAgrApproveLogConsumerBO.setSupplierId(submitAgrReqBO.getSupplierId());
            createAgrApproveLogConsumerBO.setApproveType(Integer.valueOf(0));
            createAgrApproveLogConsumerBO.setApproveResult(Integer.valueOf(2));
            createAgrApproveLogConsumerBO.setCreateTime(new Date());
            createAgrApproveLogConsumerBO.setCreateLoginId(submitAgrReqBO.getUserId());
            this.createAgrApproveLogProducer.sendOneway(new ProxyMessage(this.topicConfig.getAgrApproveLogTopicName(), this.topicConfig.getAgrApproveLogTagName(), JSONObject.toJSONString((Object)createAgrApproveLogConsumerBO)));
        }
        catch (Exception e) {
            logger.error("\u63d0\u4ea4\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u53d1\u9001\u6d88\u606f\u751f\u6210\u534f\u8bae\u5ba1\u6279\u8bb0\u5f55\u5931\u8d25" + e);
        }
    }
}

