/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.manage.market.impl;

import com.ohaotian.commodity.busi.manage.market.UpdateElecSkuStatusService;
import com.ohaotian.commodity.busi.manage.market.bo.UpdateElecSkuStatusRspBO;
import com.ohaotian.commodity.common.exception.BusinessException;
import com.ohaotian.commodity.dao.SkuMapper;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="updateElecSkuStatusService")
public class UpdateElecSkuStatusServiceImpl
implements UpdateElecSkuStatusService {
    private static final Logger logger = LoggerFactory.getLogger(UpdateElecSkuStatusServiceImpl.class);
    private final boolean isDebugEnablled = logger.isDebugEnabled();
    @Autowired
    private SkuMapper skuMapper;

    public UpdateElecSkuStatusRspBO updateElecSkuStatus(Long skuId, Long supplierId, Long userId, Integer skuStatus) {
        if (this.isDebugEnablled) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u66f4\u65b0\u5546\u54c1\u72b6\u6001\u670d\u52a1\u5165\u53c2:skuId =" + skuId + "supplierId=" + supplierId + "skuStatus = " + skuStatus);
        }
        if (skuId == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5355\u54c1Id[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (supplierId == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5355\u54c1\u72b6\u6001[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (skuStatus == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4f9b\u5e94\u5546Id[skuStatus]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UpdateElecSkuStatusRspBO rspBO = new UpdateElecSkuStatusRspBO();
        try {
            ArrayList<Long> skuIds = new ArrayList<Long>();
            skuIds.add(skuId);
            if (this.skuMapper.updateSkuStateBatchByIds(skuIds, supplierId, userId, skuStatus) > 0) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
            }
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u8d85\u5e02\u66f4\u65b0\u5546\u54c1\u72b6\u6001\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException(null, "\u7535\u5b50\u8d85\u5e02\u66f4\u65b0\u5546\u54c1\u72b6\u6001\u670d\u52a1\u51fa\u9519");
        }
        return rspBO;
    }
}

