/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QueryEcommerceCatalogService;
import com.cgd.commodity.busi.bo.EcommerceCatalogRepBO;
import com.cgd.commodity.busi.bo.EcommerceCatalogRspBO;
import com.cgd.commodity.dao.EcommerceCatalogMapper;
import com.cgd.commodity.po.EcommerceCatalog;
import com.ohaotian.commodity.busi.manage.market.extend.QueryCatalogNameService;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class QueryEcommerceCatalogServiceImpl
implements QueryEcommerceCatalogService {
    private static final Logger logger = LoggerFactory.getLogger(QueryEcommerceCatalogServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private EcommerceCatalogMapper ecommerceCatalogMapper;
    @Autowired
    private QueryCatalogNameService queryCatalogNameService;

    public RspPageBO<EcommerceCatalogRspBO> queryEcommerceCatalogs(EcommerceCatalogRepBO ecommerceCatalogRepBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5546\u54c1\u7c7b\u76ee\u52a0\u4ef7\u914d\u7f6e\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + ecommerceCatalogRepBO.toString());
        }
        RspPageBO resultPage = new RspPageBO();
        try {
            ArrayList<Long> commodityTypeIds = new ArrayList<Long>();
            ArrayList<EcommerceCatalogRspBO> ecommerceCatalogRspBOs = new ArrayList<EcommerceCatalogRspBO>();
            Page page = new Page(ecommerceCatalogRepBO.getPageNo(), ecommerceCatalogRepBO.getPageSize());
            EcommerceCatalog ecommerceCatalog = new EcommerceCatalog();
            BeanUtils.copyProperties((Object)ecommerceCatalogRepBO, (Object)ecommerceCatalog);
            List<EcommerceCatalog> ecommerceCatalogList = this.ecommerceCatalogMapper.selectEcommerceCatalogs((Page<EcommerceCatalog>)page, ecommerceCatalog);
            for (EcommerceCatalog ecommerceCatalogPo : ecommerceCatalogList) {
                commodityTypeIds.add(ecommerceCatalogPo.getCommodityTypeId());
            }
            if (commodityTypeIds.size() > 0) {
                Map<Long, String> typeName = this.queryCatalogNameService.queryMdmCatalogMapByCommodityTypeId(commodityTypeIds);
                for (EcommerceCatalog ecommerceCatalogPo : ecommerceCatalogList) {
                    EcommerceCatalogRspBO ecommerceCatalogRspBO = new EcommerceCatalogRspBO();
                    BeanUtils.copyProperties((Object)ecommerceCatalogPo, (Object)ecommerceCatalogRspBO);
                    String str = typeName.get(ecommerceCatalogPo.getCommodityTypeId());
                    ecommerceCatalogRspBO.setCategoryFourName(str);
                    ecommerceCatalogRspBOs.add(ecommerceCatalogRspBO);
                }
            }
            resultPage.setRespCode("0000");
            resultPage.setRespDesc("\u6210\u529f");
            resultPage.setPageNo(page.getPageNo());
            resultPage.setRecordsTotal(page.getTotalCount());
            resultPage.setRows(ecommerceCatalogRspBOs);
            resultPage.setTotal(page.getTotalPages());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5546\u54c1\u7c7b\u76ee\u52a0\u4ef7\u914d\u7f6e\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u5546\u54c1\u7c7b\u76ee\u52a0\u4ef7\u914d\u7f6e\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
        return resultPage;
    }
}

