/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.cgd.commodity.busi.SkuPriceUpdateService;
import com.cgd.commodity.busi.bo.SkuPriceUpdateReqBO;
import com.cgd.commodity.busi.bo.SkuPriceUpdateRspBO;
import com.cgd.commodity.dao.EcommerceCatalogMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SkuPriceMapper;
import com.cgd.commodity.intfce.bo.PriceChangeConsumerBO;
import com.cgd.commodity.intfce.vo.PriceChangeConsumerVO;
import com.cgd.commodity.po.Sku;
import com.cgd.commodity.po.SkuPrice;
import com.ohaotian.commodity.config.TopicConfig;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SkuPriceUpdateServiceImpl
implements SkuPriceUpdateService {
    private static final Logger logger = LoggerFactory.getLogger(SkuPriceUpdateServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;
    private SkuPriceMapper skuPriceMapper;
    @Autowired
    private EcommerceCatalogMapper ecommerceCatalogMapper;
    @Resource
    private TopicConfig topicConfig;
    @Resource(name="priceChangeServiceProducer")
    private ProxyMessageProducer producer;

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setSkuPriceMapper(SkuPriceMapper skuPriceMapper) {
        this.skuPriceMapper = skuPriceMapper;
    }

    public SkuPriceUpdateRspBO skuPriceUpdate(SkuPriceUpdateReqBO skuPriceUpdateReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5b9a\u65f6\u4efb\u52a1\u5546\u54c1\u4ef7\u683c\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + skuPriceUpdateReqBO.toString());
        }
        if (null == skuPriceUpdateReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5355\u54c1\u72b6\u6001\u53d8\u66f4\u65e5\u5fd7\u4e1a\u52a1\u670d\u52a1\u4f9b\u5e94\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == skuPriceUpdateReqBO.getExtSkuId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5355\u54c1\u72b6\u6001\u53d8\u66f4\u65e5\u5fd7\u4e1a\u52a1\u670d\u52a1\u4f9b\u5e94\u5546ID[extSkuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            SkuPriceUpdateRspBO skuPriceUpdateRspBO = new SkuPriceUpdateRspBO();
            Sku oldSku = this.skuMapper.selectByExtSkuIdAndSupplierId(skuPriceUpdateReqBO.getExtSkuId(), skuPriceUpdateReqBO.getSupplierId());
            if (null == oldSku) {
                skuPriceUpdateRspBO.setIsSuccess(Boolean.valueOf(false));
                skuPriceUpdateRspBO.setResultMsg("\u4f9b\u5e94\u5546[" + skuPriceUpdateReqBO.getSupplierId() + "]\u7684\u5546\u54c1[" + skuPriceUpdateReqBO.getExtSkuId() + "]\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
            } else {
                List<SkuPrice> skuPrices = this.skuPriceMapper.selectBySkuId(oldSku.getSkuId(), oldSku.getSupplierId());
                SkuPrice skuPrice = new SkuPrice();
                skuPrice.setSkuId(oldSku.getSkuId());
                skuPrice.setSupplierId(skuPriceUpdateReqBO.getSupplierId());
                skuPrice.setAgreementPrice(skuPriceUpdateReqBO.getAgreementPrice());
                skuPrice.setMarketPrice(skuPriceUpdateReqBO.getMarketPrice());
                if (1L == skuPriceUpdateReqBO.getSupplierId()) {
                    Double price = (double)skuPriceUpdateReqBO.getAgreementPrice().longValue() * 1.04;
                    skuPrice.setMemberPrice(price.longValue());
                    skuPrice.setSalePrice(price.longValue());
                } else {
                    Double price = (double)skuPriceUpdateReqBO.getAgreementPrice().longValue() * 1.04;
                    skuPrice.setMemberPrice(price.longValue());
                    skuPrice.setSalePrice(price.longValue());
                }
                if (!skuPrices.isEmpty()) {
                    skuPrice.setUpdateTime(new Date());
                    this.skuPriceMapper.updateBySkuIdKey(skuPrice);
                } else {
                    skuPrice.setCreateTime(new Date());
                    skuPrice.setCurrencyType(0);
                    skuPrice.setIsDelete(0);
                    this.skuPriceMapper.insertSelective(skuPrice);
                }
                skuPriceUpdateRspBO.setIsSuccess(Boolean.valueOf(true));
                this.sendMsg(skuPriceUpdateReqBO, skuPrices);
            }
            return skuPriceUpdateRspBO;
        }
        catch (Exception e) {
            logger.error("\u5b9a\u65f6\u4efb\u52a1\u5546\u54c1\u4ef7\u683c\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5b9a\u65f6\u4efb\u52a1\u5546\u54c1\u4ef7\u683c\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private void sendMsg(SkuPriceUpdateReqBO skuPriceUpdateReqBO, List<SkuPrice> skuPrices) {
        try {
            PriceChangeConsumerBO priceChangeConsumerBO = new PriceChangeConsumerBO();
            ArrayList<PriceChangeConsumerVO> skus = new ArrayList<PriceChangeConsumerVO>();
            PriceChangeConsumerVO priceChangeConsumerVO = new PriceChangeConsumerVO();
            priceChangeConsumerVO.setAgreementPrice(skuPriceUpdateReqBO.getAgreementPrice());
            priceChangeConsumerVO.setExtSkuId(skuPriceUpdateReqBO.getExtSkuId());
            priceChangeConsumerVO.setMarketPrice(skuPriceUpdateReqBO.getMarketPrice());
            priceChangeConsumerVO.setCreateTime(new Date());
            if (!skuPrices.isEmpty()) {
                priceChangeConsumerVO.setPreAgreementPrice(skuPrices.get(0).getAgreementPrice());
                priceChangeConsumerVO.setPreMarketPrice(skuPrices.get(0).getMarketPrice());
            }
            skus.add(priceChangeConsumerVO);
            priceChangeConsumerBO.setSkus(skus);
            priceChangeConsumerBO.setSupplierId(skuPriceUpdateReqBO.getSupplierId());
            this.producer.sendOneway(new ProxyMessage(this.topicConfig.getSkuPriceChangeTopicName(), this.topicConfig.getSkuPriceChangeTagName(), JSONObject.toJSONString((Object)priceChangeConsumerBO)));
        }
        catch (Exception e) {
            logger.error("\u5b9a\u65f6\u4efb\u52a1\u5546\u54c1\u4ef7\u683c\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u53d1\u9001\u5546\u54c1\u4ef7\u683c\u53d8\u66f4\u65e5\u5fd7\u6d88\u8d39\u8005\u670d\u52a1\u6d88\u606f\u5931\u8d25", (Throwable)e);
        }
    }
}

