/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.consumer;

import com.cgd.commodity.constant.CommodityTopicConstant;
import com.cgd.commodity.consumer.AgrStsChgConsumer;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SupplierAgreementMapper;
import com.cgd.commodity.intfce.bo.UpdateAgrStatusConsumerBO;
import com.cgd.commodity.po.SupplierAgreement;
import com.gd.commodity.constant.Constant;
import com.ohaotian.plugin.mq.bo.MqSubScribeSingleBO;
import com.ohaotian.plugin.mq.interfce.MqCunsumer;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UpdateAgrStatusConsumer
implements MqCunsumer {
    private static final Logger logger = LoggerFactory.getLogger(AgrStsChgConsumer.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SupplierAgreementMapper supplierAgreementMapper;
    @Autowired
    private SkuMapper skuMapper;

    public MqSubScribeSingleBO subscribe() {
        MqSubScribeSingleBO mqSubScribeSingleBO = new MqSubScribeSingleBO();
        mqSubScribeSingleBO.setConsumerId("AGREEMENT_STATUS_CHG_CID");
        mqSubScribeSingleBO.setTag(CommodityTopicConstant.AGREEMENT_STATUS_CHG_TAG);
        mqSubScribeSingleBO.setTopic("AGREEMENT_STATUS_CHG_TOPIC");
        return mqSubScribeSingleBO;
    }

    public void execute(String tag, Object msg) {
        try {
            UpdateAgrStatusConsumerBO updateAgrStatusConsumerBO = (UpdateAgrStatusConsumerBO)msg;
            if (this.isDebugEnabled) {
                logger.debug("\u751f\u6210\u53d8\u66f4\u534f\u8bae\u72b6\u6001\u6d88\u8d39\u8005\u7ec4\u5408\u670d\u52a1\u5165\u53c2cgd\uff1a" + updateAgrStatusConsumerBO.toString());
            }
            SupplierAgreement supplierAgreement = new SupplierAgreement();
            supplierAgreement.setAgreementId(updateAgrStatusConsumerBO.getAgreementId());
            supplierAgreement.setAgreementStatus(updateAgrStatusConsumerBO.getAgreementStatus().byteValue());
            supplierAgreement.setSupplierId(updateAgrStatusConsumerBO.getSupplierId());
            supplierAgreement.setUpdateLoginId(updateAgrStatusConsumerBO.getOperId());
            supplierAgreement.setUpdateTime(new Date());
            this.supplierAgreementMapper.updateAgrStsById(supplierAgreement);
            this.skuMapper.updateSkuStatusByAgrId(Constant.SKU_STATUS_AGREEMENT_FROZEN, updateAgrStatusConsumerBO.getOperId(), supplierAgreement.getSupplierId(), supplierAgreement.getAgreementId());
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u53d8\u66f4\u534f\u8bae\u72b6\u6001\u6d88\u8d39\u8005\u7ec4\u5408\u670d\u52a1\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }
}

