/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.intfce.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cgd.commodity.atom.GenerateBrandSeqService;
import com.cgd.commodity.atom.GenerateMeasureSeqService;
import com.cgd.commodity.atom.bo.GenerateBrandSeqRspBO;
import com.cgd.commodity.atom.bo.GenerateMeasureSeqRspBO;
import com.cgd.commodity.busi.BusiAttributeChangeService;
import com.cgd.commodity.busi.CreateSKUService;
import com.cgd.commodity.busi.SkuPriceUpdateService;
import com.cgd.commodity.busi.SkuStateUpdateService;
import com.cgd.commodity.busi.bo.AttributeExtPropChangeVO;
import com.cgd.commodity.busi.bo.BusiAttributeChangeReqBO;
import com.cgd.commodity.busi.bo.BusiAttributeChangeRspBO;
import com.cgd.commodity.busi.bo.BusiInfoSKUReqBO;
import com.cgd.commodity.busi.bo.BusiInfoSKURspBO;
import com.cgd.commodity.busi.bo.CommodityMeasureBO;
import com.cgd.commodity.busi.bo.SkuPriceUpdateReqBO;
import com.cgd.commodity.busi.bo.SkuPriceUpdateRspBO;
import com.cgd.commodity.busi.bo.SkuStateUpdateReqBO;
import com.cgd.commodity.busi.bo.SkuStateUpdateRspBO;
import com.cgd.commodity.busi.vo.ElectricityParam;
import com.cgd.commodity.constant.Constant;
import com.cgd.commodity.dao.BrandMapper;
import com.cgd.commodity.dao.CommodityMeasureMapper;
import com.cgd.commodity.intfce.SkuChangeService;
import com.cgd.commodity.intfce.bo.BrandConsumerBO;
import com.cgd.commodity.intfce.bo.SkuChangeReqBO;
import com.cgd.commodity.intfce.bo.SkuChangeRspBO;
import com.cgd.commodity.intfce.vo.SkuChangeReqVO;
import com.cgd.commodity.intfce.vo.SkuChangeRspVO;
import com.cgd.commodity.intfce.vo.SkuInfoChangeReqVO;
import com.cgd.commodity.po.Brand;
import com.cgd.commodity.po.CommodityMeasure;
import com.cgd.electricitysupplier.busi.QrySKUFromInterService;
import com.cgd.electricitysupplier.busi.QrySkuPriceService;
import com.cgd.electricitysupplier.busi.QrySkuStateService;
import com.cgd.electricitysupplier.busi.bo.BusiQrySKUReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySKURspBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySkuPriceReqBO;
import com.cgd.electricitysupplier.busi.bo.BusiQrySkuPriceRspBO;
import com.cgd.electricitysupplier.busi.bo.SkuStateReqBO;
import com.cgd.electricitysupplier.busi.bo.SkuStateRsp;
import com.cgd.electricitysupplier.busi.bo.SkuStateRspBo;
import com.cgd.electricitysupplier.busi.vo.BusiQrySkuPriceRspVO;
import com.ohaotian.commodity.config.TopicConfig;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.DelFormatHelper;
import com.ohaotian.plugin.common.util.JsonUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SkuChangeServiceImpl
implements SkuChangeService {
    private static final Logger logger = LoggerFactory.getLogger(SkuChangeServiceImpl.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    private QrySkuPriceService qrySkuPriceService;
    private SkuPriceUpdateService skuPriceUpdateService;
    private QrySkuStateService qrySkuStateService;
    private SkuStateUpdateService skuStateUpdateService;
    private QrySKUFromInterService qrySKUFromInterService;
    private BusiAttributeChangeService busiAttributeChangeService;
    private CreateSKUService createSKUService;
    private Properties prop;
    @Autowired
    private BrandMapper brandMapper;
    @Autowired
    private GenerateBrandSeqService generateBrandSeqService;
    @Autowired
    private GenerateMeasureSeqService generateMeasureSeqService;
    @Resource
    TopicConfig topicConfig;
    @Resource(name="brandInstServiceProducer")
    private ProxyMessageProducer producerBrand;
    @Resource(name="measureInstServiceProducer")
    private ProxyMessageProducer producerMeasure;
    @Autowired
    private CommodityMeasureMapper commodityMeasureMapper;

    public void setQrySkuPriceService(QrySkuPriceService qrySkuPriceService) {
        this.qrySkuPriceService = qrySkuPriceService;
    }

    public void setSkuPriceUpdateService(SkuPriceUpdateService skuPriceUpdateService) {
        this.skuPriceUpdateService = skuPriceUpdateService;
    }

    public void setQrySkuStateService(QrySkuStateService qrySkuStateService) {
        this.qrySkuStateService = qrySkuStateService;
    }

    public void setSkuStateUpdateService(SkuStateUpdateService skuStateUpdateService) {
        this.skuStateUpdateService = skuStateUpdateService;
    }

    public void setQrySKUFromInterService(QrySKUFromInterService qrySKUFromInterService) {
        this.qrySKUFromInterService = qrySKUFromInterService;
    }

    public void setBusiAttributeChangeService(BusiAttributeChangeService busiAttributeChangeService) {
        this.busiAttributeChangeService = busiAttributeChangeService;
    }

    public void setCreateSKUService(CreateSKUService createSKUService) {
        this.createSKUService = createSKUService;
    }

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SkuChangeRspBO changeSKU(SkuChangeReqBO skuChangeReqBO) {
        if (isDebugEnabled) {
            logger.debug("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u5165\u53c2\uff1a" + skuChangeReqBO.toString());
        }
        if (null == skuChangeReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u4f9b\u5e94\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == skuChangeReqBO.getMsgGetType()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u6d88\u606f\u7c7b\u578b[msgGetType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (6 == skuChangeReqBO.getMsgGetType()) {
            if (null == skuChangeReqBO.getSkus()) throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1sku\u96c6\u5408[skus]\u4e0d\u80fd\u4e3a\u7a7a");
            if (skuChangeReqBO.getSkus().isEmpty()) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1sku\u96c6\u5408[skus]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            if (null == skuChangeReqBO.getSkuInfos()) throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1skuInfo\u96c6\u5408[skuInfos]\u4e0d\u80fd\u4e3a\u7a7a");
            if (skuChangeReqBO.getSkuInfos().isEmpty()) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1skuInfo\u96c6\u5408[skuInfos]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        try {
            ArrayList<String> extSkuIds;
            ArrayList<SkuChangeRspVO> results = new ArrayList<SkuChangeRspVO>();
            if (Constant.MSG_GET_TYPE_PRICE.equals(skuChangeReqBO.getMsgGetType())) {
                BusiQrySkuPriceReqBO busiQrySkuPriceReqBO = new BusiQrySkuPriceReqBO();
                busiQrySkuPriceReqBO.setIsExtSku(Boolean.valueOf(true));
                busiQrySkuPriceReqBO.setSupplierId(skuChangeReqBO.getSupplierId());
                extSkuIds = new ArrayList<String>();
                for (SkuInfoChangeReqVO skuInfoChangeReqVO : skuChangeReqBO.getSkuInfos()) {
                    extSkuIds.add(skuInfoChangeReqVO.getExtSkuId());
                }
                busiQrySkuPriceReqBO.setExtSkuIds(extSkuIds);
                BusiQrySkuPriceRspBO busiQrySkuPriceRspBO = this.qrySkuPriceService.qrySkuPrice(busiQrySkuPriceReqBO);
                results.addAll(this.callSkuPriceUpdate(busiQrySkuPriceRspBO, skuChangeReqBO));
            }
            if (Constant.MSG_GET_TYPE_SHELF.equals(skuChangeReqBO.getMsgGetType())) {
                SkuStateReqBO skuStateReqBO = new SkuStateReqBO();
                skuStateReqBO.setIsExtSkuId(Boolean.valueOf(true));
                skuStateReqBO.setSupplierId(skuChangeReqBO.getSupplierId());
                extSkuIds = new ArrayList();
                for (SkuInfoChangeReqVO skuInfoChangeReqVO : skuChangeReqBO.getSkuInfos()) {
                    extSkuIds.add(skuInfoChangeReqVO.getExtSkuId());
                }
                skuStateReqBO.setExtSkuIds(extSkuIds);
                SkuStateRsp skuStateRsp = this.qrySkuStateService.qrySkuStatus(skuStateReqBO);
                results.addAll(this.callSkuStateUpdate(skuStateRsp, skuChangeReqBO));
            }
            if (Constant.MSG_GET_TYPE_SKU.equals(skuChangeReqBO.getMsgGetType())) {
                results.addAll(this.callAddOrDelSku(skuChangeReqBO));
            }
            if (Constant.MSG_GET_TYPE_SKU_SPEC.equals(skuChangeReqBO.getMsgGetType())) {
                results.addAll(this.callExtSkuDetail(skuChangeReqBO));
            }
            if (Constant.MSG_GET_TYPE_SKU_SPEC_JD.equals(skuChangeReqBO.getMsgGetType())) {
                results.addAll(this.callJDExtSkuDetail(skuChangeReqBO));
            }
            SkuChangeRspBO skuChangeRspBO = new SkuChangeRspBO();
            skuChangeRspBO.setIsSuccess(Boolean.valueOf(true));
            skuChangeRspBO.setSkus(results);
            return skuChangeRspBO;
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u5931\u8d25" + e);
            SkuChangeRspBO skuChangeRspBO = new SkuChangeRspBO();
            skuChangeRspBO.setIsSuccess(Boolean.valueOf(false));
            skuChangeRspBO.setResultMsg("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u5931\u8d25" + e);
            return skuChangeRspBO;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<SkuChangeRspVO> callSkuPriceUpdate(BusiQrySkuPriceRspBO busiQrySkuPriceRspBO, SkuChangeReqBO skuChangeReqBO) {
        ArrayList<SkuChangeRspVO> skuChangeRspVOs = new ArrayList<SkuChangeRspVO>();
        if ("0000".equals(busiQrySkuPriceRspBO.getRespCode())) {
            SkuChangeRspVO skuChangeRspVO;
            for (Object busiQrySkuPriceRspVO : busiQrySkuPriceRspBO.getSkuPrices()) {
                SkuPriceUpdateReqBO skuPriceUpdateReqBO = new SkuPriceUpdateReqBO();
                skuChangeRspVO = new SkuChangeRspVO();
                try {
                    BusiQrySKUReqBO busiQrySKUReqBO = new BusiQrySKUReqBO();
                    busiQrySKUReqBO.setExtSkuId(busiQrySkuPriceRspVO.getSkuId());
                    busiQrySKUReqBO.setIsExtSkuId(Boolean.valueOf(true));
                    busiQrySKUReqBO.setSupplierId(skuChangeReqBO.getSupplierId());
                    BusiQrySKURspBO busiQrySKURspBO = this.qrySKUFromInterService.qrySKUInfo(busiQrySKUReqBO);
                    List categories = busiQrySKURspBO.getCategories();
                    String catalogCode = null;
                    if (null == categories) throw new BusinessException("CREATE_SKU_SERVICE_RSP_SKU_TYPE_NOT_EXIST", "\u5546\u54c1\u7c7b\u76ee\u4e3a\u7a7a");
                    if (categories.isEmpty()) throw new BusinessException("CREATE_SKU_SERVICE_RSP_SKU_TYPE_NOT_EXIST", "\u5546\u54c1\u7c7b\u76ee\u4e3a\u7a7a");
                    catalogCode = 1 == skuChangeReqBO.getSupplierId().intValue() ? (String)categories.get(2) : (2 == skuChangeReqBO.getSupplierId().intValue() ? (String)categories.get(0) : (String)categories.get(3));
                    skuPriceUpdateReqBO.setAgreementPrice(MoneyUtils.BigDecimal2Long((BigDecimal)busiQrySkuPriceRspVO.getPrice()));
                    skuPriceUpdateReqBO.setExtSkuId(busiQrySkuPriceRspVO.getSkuId());
                    skuPriceUpdateReqBO.setMarketPrice(MoneyUtils.BigDecimal2Long((BigDecimal)busiQrySkuPriceRspVO.getEcPrice()));
                    skuPriceUpdateReqBO.setSupplierId(skuChangeReqBO.getSupplierId());
                    skuPriceUpdateReqBO.setCatalogCode(catalogCode);
                    SkuPriceUpdateRspBO skuPriceUpdateRspBO = this.skuPriceUpdateService.skuPriceUpdate(skuPriceUpdateReqBO);
                    if ("0000".equals(skuPriceUpdateRspBO.getRespCode())) {
                        if (skuPriceUpdateRspBO.getIsSuccess().booleanValue()) continue;
                        for (SkuInfoChangeReqVO skuInfoChangeReqVO : skuChangeReqBO.getSkuInfos()) {
                            if (!busiQrySkuPriceRspVO.getSkuId().equals(skuInfoChangeReqVO.getExtSkuId())) continue;
                            skuChangeRspVO.setExtSkuChangeId(skuInfoChangeReqVO.getExtSkuChangeId());
                            skuChangeRspVO.setExtSkuId(busiQrySkuPriceRspVO.getSkuId());
                            skuChangeRspVO.setErrorMsg(skuPriceUpdateRspBO.getResultMsg());
                            skuChangeRspVOs.add(skuChangeRspVO);
                        }
                        continue;
                    }
                    for (SkuInfoChangeReqVO skuInfoChangeReqVO : skuChangeReqBO.getSkuInfos()) {
                        if (!busiQrySkuPriceRspVO.getSkuId().equals(skuInfoChangeReqVO.getExtSkuId())) continue;
                        skuChangeRspVO.setExtSkuChangeId(skuInfoChangeReqVO.getExtSkuChangeId());
                        skuChangeRspVO.setExtSkuId(busiQrySkuPriceRspVO.getSkuId());
                        skuChangeRspVO.setErrorMsg(skuPriceUpdateRspBO.getRespDesc());
                        skuChangeRspVOs.add(skuChangeRspVO);
                    }
                }
                catch (Exception e) {
                    logger.error("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u5b9a\u65f6\u4efb\u52a1\u5546\u54c1\u4ef7\u683c\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a", (Throwable)e);
                    skuChangeRspVO.setExtSkuId(busiQrySkuPriceRspVO.getSkuId());
                    skuChangeRspVO.setErrorMsg("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u5b9a\u65f6\u4efb\u52a1\u5546\u54c1\u4ef7\u683c\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a" + e);
                    skuChangeRspVOs.add(skuChangeRspVO);
                }
            }
            ArrayList<String> existSkuIds = new ArrayList<String>();
            for (BusiQrySkuPriceRspVO busiQrySkuPriceRspVO : busiQrySkuPriceRspBO.getSkuPrices()) {
                existSkuIds.add(busiQrySkuPriceRspVO.getSkuId());
            }
            for (SkuInfoChangeReqVO skuInfoChangeReqVO : skuChangeReqBO.getSkuInfos()) {
                if (existSkuIds.contains(skuInfoChangeReqVO.getExtSkuId())) continue;
                skuChangeRspVO = new SkuChangeRspVO();
                skuChangeRspVO.setErrorMsg(busiQrySkuPriceRspBO.getResultMessage());
                skuChangeRspVO.setExtSkuId(skuInfoChangeReqVO.getExtSkuId());
                skuChangeRspVO.setExtSkuChangeId(skuInfoChangeReqVO.getExtSkuChangeId());
                skuChangeRspVOs.add(skuChangeRspVO);
            }
            return skuChangeRspVOs;
        }
        logger.error("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u5b9a\u65f6\u4efb\u52a1\u5546\u54c1\u4ef7\u683c\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a" + busiQrySkuPriceRspBO.getRespDesc());
        for (SkuInfoChangeReqVO skuInfoChangeReqVO : skuChangeReqBO.getSkuInfos()) {
            SkuChangeRspVO skuChangeRspVO = new SkuChangeRspVO();
            skuChangeRspVO.setErrorMsg(busiQrySkuPriceRspBO.getRespDesc());
            skuChangeRspVO.setExtSkuId(skuInfoChangeReqVO.getExtSkuId());
            skuChangeRspVO.setExtSkuChangeId(skuInfoChangeReqVO.getExtSkuChangeId());
            skuChangeRspVOs.add(skuChangeRspVO);
        }
        return skuChangeRspVOs;
    }

    private List<SkuChangeRspVO> callSkuStateUpdate(SkuStateRsp skuStateRsp, SkuChangeReqBO skuChangeReqBO) {
        ArrayList<SkuChangeRspVO> skuChangeRspVOs = new ArrayList<SkuChangeRspVO>();
        if ("0000".equals(skuStateRsp.getRespCode())) {
            SkuChangeRspVO skuChangeRspVO;
            for (Object skuStateRspBo : skuStateRsp.getSkuStates()) {
                SkuStateUpdateReqBO skuStateUpdateReqBO = new SkuStateUpdateReqBO();
                skuChangeRspVO = new SkuChangeRspVO();
                try {
                    skuStateUpdateReqBO.setExtSkuId(skuStateRspBo.getSku());
                    skuStateUpdateReqBO.setSkuState(skuStateRspBo.getState());
                    skuStateUpdateReqBO.setSupplierId(skuChangeReqBO.getSupplierId());
                    SkuStateUpdateRspBO skuStateUpdateRspBO = this.skuStateUpdateService.updateSkuStateByMsgType(skuChangeReqBO.getMsgGetType(), skuStateUpdateReqBO);
                    if ("0000".equals(skuStateUpdateRspBO.getRespCode())) {
                        if (skuStateUpdateRspBO.getIsSuccess().booleanValue()) continue;
                        for (SkuInfoChangeReqVO skuInfoChangeReqVO : skuChangeReqBO.getSkuInfos()) {
                            if (!skuStateRspBo.getSku().equals(skuInfoChangeReqVO.getExtSkuId())) continue;
                            skuChangeRspVO.setExtSkuChangeId(skuInfoChangeReqVO.getExtSkuChangeId());
                            skuChangeRspVO.setExtSkuId(skuStateRspBo.getSku());
                            skuChangeRspVO.setErrorMsg(skuStateUpdateRspBO.getResultMsg());
                            skuChangeRspVOs.add(skuChangeRspVO);
                        }
                        continue;
                    }
                    skuChangeRspVO.setExtSkuId(skuStateRspBo.getSku());
                    skuChangeRspVO.setErrorMsg(skuStateUpdateRspBO.getRespDesc());
                    skuChangeRspVOs.add(skuChangeRspVO);
                }
                catch (Exception e) {
                    logger.error("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u5b9a\u65f6\u5546\u54c1\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a" + e);
                    skuChangeRspVO.setExtSkuId(skuStateRspBo.getSku());
                    skuChangeRspVO.setErrorMsg("\u5546\u54c1\u8c03\u7528\u5b9a\u65f6\u5546\u54c1\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a" + e);
                    skuChangeRspVOs.add(skuChangeRspVO);
                }
            }
            ArrayList<String> existSkuIds = new ArrayList<String>();
            for (SkuStateRspBo skuStateRspBo : skuStateRsp.getSkuStates()) {
                existSkuIds.add(skuStateRspBo.getSku());
            }
            for (SkuInfoChangeReqVO skuInfoChangeReqVO : skuChangeReqBO.getSkuInfos()) {
                if (existSkuIds.contains(skuInfoChangeReqVO.getExtSkuId())) continue;
                skuChangeRspVO = new SkuChangeRspVO();
                skuChangeRspVO.setErrorMsg(skuStateRsp.getResultMessage());
                skuChangeRspVO.setExtSkuId(skuInfoChangeReqVO.getExtSkuId());
                skuChangeRspVO.setExtSkuChangeId(skuInfoChangeReqVO.getExtSkuChangeId());
                skuChangeRspVOs.add(skuChangeRspVO);
            }
        } else {
            logger.error("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u5b9a\u65f6\u5546\u54c1\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a" + skuStateRsp.getRespDesc());
            for (SkuInfoChangeReqVO skuInfoChangeReqVO : skuChangeReqBO.getSkuInfos()) {
                SkuChangeRspVO skuChangeRspVO = new SkuChangeRspVO();
                skuChangeRspVO.setErrorMsg(skuStateRsp.getRespDesc());
                skuChangeRspVO.setExtSkuId(skuInfoChangeReqVO.getExtSkuId());
                skuChangeRspVO.setExtSkuChangeId(skuInfoChangeReqVO.getExtSkuChangeId());
                skuChangeRspVOs.add(skuChangeRspVO);
            }
        }
        return skuChangeRspVOs;
    }

    private List<SkuChangeRspVO> callAddOrDelSku(SkuChangeReqBO skuChangeReqBO) {
        ArrayList<SkuChangeRspVO> skuChangeRspVOs = new ArrayList<SkuChangeRspVO>();
        for (SkuChangeReqVO skuChangeReqVO : skuChangeReqBO.getSkus()) {
            try {
                SkuChangeRspVO skuChangeRspVO = new SkuChangeRspVO();
                if (1 == skuChangeReqVO.getSkuPoolState()) {
                    BusiInfoSKUReqBO busiInfoSKUReqBO = new BusiInfoSKUReqBO();
                    busiInfoSKUReqBO.setExtSkuId(skuChangeReqVO.getExtSkuId());
                    busiInfoSKUReqBO.setSkuLocation(Integer.valueOf(2));
                    busiInfoSKUReqBO.setSupplierName(this.prop.getProperty("SUPPLIER_NAME_" + skuChangeReqBO.getSupplierId()));
                    busiInfoSKUReqBO.setSupplierId(skuChangeReqBO.getSupplierId());
                    BusiInfoSKURspBO busiInfoSKURspBO = this.createSKUService.createSKU(busiInfoSKUReqBO);
                    if ("0000".equals(busiInfoSKURspBO.getRespCode())) {
                        if (!busiInfoSKURspBO.getIsSuccess().booleanValue()) {
                            skuChangeRspVO.setExtSkuChangeId(skuChangeRspVO.getExtSkuChangeId());
                            skuChangeRspVO.setExtSkuId(skuChangeReqVO.getExtSkuId());
                            skuChangeRspVO.setErrorMsg(busiInfoSKURspBO.getResultDesc());
                            skuChangeRspVOs.add(skuChangeRspVO);
                        }
                    } else {
                        skuChangeRspVO.setExtSkuChangeId(skuChangeReqVO.getExtSkuChangeId());
                        skuChangeRspVO.setExtSkuId(skuChangeReqVO.getExtSkuId());
                        skuChangeRspVO.setErrorMsg(busiInfoSKURspBO.getRespDesc());
                        skuChangeRspVOs.add(skuChangeRspVO);
                    }
                }
                if (2 != skuChangeReqVO.getSkuPoolState()) continue;
                SkuStateUpdateReqBO skuStateUpdateReqBO = new SkuStateUpdateReqBO();
                skuStateUpdateReqBO.setExtSkuId(skuChangeReqVO.getExtSkuId());
                skuStateUpdateReqBO.setSkuState(Constant.SKU_STATUS_INVALID);
                skuStateUpdateReqBO.setSupplierId(skuChangeReqBO.getSupplierId());
                SkuStateUpdateRspBO skuStateUpdateRspBO = this.skuStateUpdateService.updateSkuState(skuStateUpdateReqBO);
                if ("0000".equals(skuStateUpdateRspBO.getRespCode())) {
                    if (skuStateUpdateRspBO.getIsSuccess().booleanValue()) continue;
                    skuChangeRspVO.setExtSkuChangeId(skuChangeReqVO.getExtSkuChangeId());
                    skuChangeRspVO.setExtSkuId(skuChangeReqVO.getExtSkuId());
                    skuChangeRspVO.setErrorMsg(skuStateUpdateRspBO.getResultMsg());
                    skuChangeRspVOs.add(skuChangeRspVO);
                    continue;
                }
                skuChangeRspVO.setExtSkuChangeId(skuChangeReqVO.getExtSkuChangeId());
                skuChangeRspVO.setExtSkuId(skuChangeReqVO.getExtSkuId());
                skuChangeRspVO.setErrorMsg(skuStateUpdateRspBO.getRespDesc());
                skuChangeRspVOs.add(skuChangeRspVO);
            }
            catch (Exception e) {
                logger.error("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u6267\u884c\u5546\u54c1\u6dfb\u52a0\u5220\u9664\u5931\u8d25\uff1a" + e);
                SkuChangeRspVO skuChangeRspVO = new SkuChangeRspVO();
                skuChangeRspVO.setExtSkuChangeId(skuChangeReqVO.getExtSkuChangeId());
                skuChangeRspVO.setExtSkuId(skuChangeReqVO.getExtSkuId());
                skuChangeRspVO.setErrorMsg("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u6267\u884c\u5546\u54c1\u6dfb\u52a0\u5220\u9664\u5931\u8d25\uff1a" + e);
                skuChangeRspVOs.add(skuChangeRspVO);
            }
        }
        return skuChangeRspVOs;
    }

    private List<SkuChangeRspVO> callExtSkuDetail(SkuChangeReqBO skuChangeReqBO) {
        ArrayList<SkuChangeRspVO> skuChangeRspVOs = new ArrayList<SkuChangeRspVO>();
        HashMap<String, Long> measureNameAndIdMap = new HashMap<String, Long>();
        HashMap<String, Long> brandNameAndIdMap = new HashMap<String, Long>();
        for (SkuInfoChangeReqVO skuInfoChangeReqVO : skuChangeReqBO.getSkuInfos()) {
            SkuChangeRspVO skuChangeRspVO = new SkuChangeRspVO();
            try {
                BusiQrySKUReqBO busiQrySKUReqBO = new BusiQrySKUReqBO();
                busiQrySKUReqBO.setExtSkuId(skuInfoChangeReqVO.getExtSkuId());
                busiQrySKUReqBO.setIsExtSkuId(Boolean.valueOf(true));
                busiQrySKUReqBO.setSupplierId(skuChangeReqBO.getSupplierId());
                if (1L == skuChangeReqBO.getSupplierId()) {
                    busiQrySKUReqBO.setPriceFloatRate(Double.valueOf(1.04));
                } else {
                    busiQrySKUReqBO.setPriceFloatRate(Double.valueOf(1.04));
                }
                BusiQrySKURspBO busiQrySKURspBO = this.qrySKUFromInterService.qrySKUInfo(busiQrySKUReqBO);
                if ("0000".equals(busiQrySKURspBO.getRespCode()) && !StringUtils.isEmpty((CharSequence)busiQrySKURspBO.getSku())) {
                    BusiAttributeChangeRspBO busiAttributeChangeRspBO;
                    BusiAttributeChangeReqBO busiAttributeChangeReqBO = new BusiAttributeChangeReqBO();
                    busiAttributeChangeReqBO.setSupplierId(skuChangeReqBO.getSupplierId());
                    busiAttributeChangeReqBO.setExtSkuId(skuInfoChangeReqVO.getExtSkuId());
                    busiAttributeChangeReqBO.setSkuName(busiQrySKURspBO.getName());
                    busiAttributeChangeReqBO.setBrandName(busiQrySKURspBO.getBrandName());
                    Long brandId = null;
                    if (!StringUtils.isEmpty((CharSequence)busiQrySKURspBO.getBrandName())) {
                        if (brandNameAndIdMap.containsKey(busiQrySKURspBO.getBrandName())) {
                            brandId = (Long)brandNameAndIdMap.get(busiQrySKURspBO.getBrandName());
                        } else {
                            brandId = this.getBrandId(busiQrySKURspBO);
                            brandNameAndIdMap.put(busiQrySKURspBO.getBrandName(), brandId);
                        }
                    }
                    busiAttributeChangeReqBO.setBrandId(brandId);
                    Long measureId = null;
                    if (!StringUtils.isEmpty((CharSequence)busiQrySKURspBO.getSaleUnit())) {
                        if (measureNameAndIdMap.containsKey(busiQrySKURspBO.getSaleUnit())) {
                            measureId = (Long)measureNameAndIdMap.get(busiQrySKURspBO.getSaleUnit());
                        } else {
                            measureId = this.getMeasureId(busiQrySKURspBO.getSaleUnit());
                            measureNameAndIdMap.put(busiQrySKURspBO.getSaleUnit(), measureId);
                        }
                    }
                    busiAttributeChangeReqBO.setMeasureId(measureId);
                    busiAttributeChangeReqBO.setMeasureName(busiQrySKURspBO.getSaleUnit());
                    busiAttributeChangeReqBO.setSkuMainPicUrl(busiQrySKURspBO.getImagePath());
                    busiAttributeChangeReqBO.setSkuDetail(busiQrySKURspBO.getIntroduction());
                    busiAttributeChangeReqBO.setPackParam(busiQrySKURspBO.getWareQD());
                    busiAttributeChangeReqBO.setOperatorId(skuChangeReqBO.getOperatorId());
                    busiAttributeChangeReqBO.setMoq(busiQrySKURspBO.getMoq());
                    busiAttributeChangeReqBO.setTaxCode(busiQrySKURspBO.getTaxCode());
                    if (!StringUtils.isEmpty((CharSequence)busiQrySKURspBO.getDeliveryTime())) {
                        busiAttributeChangeReqBO.setPreDeliverDay(Integer.valueOf(busiQrySKURspBO.getDeliveryTime()));
                    }
                    if (!busiQrySKURspBO.getAttribute().isEmpty()) {
                        AttributeExtPropChangeVO extPropBO;
                        ArrayList<AttributeExtPropChangeVO> extPropBOs = new ArrayList<AttributeExtPropChangeVO>();
                        if (Constant.JDSupplierId.intValue() == skuChangeReqBO.getSupplierId().intValue()) {
                            if (null != busiQrySKURspBO.getAttribute()) {
                                for (Map.Entry attributeEntry : busiQrySKURspBO.getAttribute().entrySet()) {
                                    if (!(attributeEntry.getValue() instanceof Map)) continue;
                                    Map propMap = (Map)attributeEntry.getValue();
                                    for (Map.Entry entry : propMap.entrySet()) {
                                        extPropBO = new AttributeExtPropChangeVO();
                                        extPropBO.setExtPropName((String)entry.getKey());
                                        extPropBO.setExtPropValue((String)entry.getValue());
                                        extPropBOs.add(extPropBO);
                                    }
                                }
                            }
                        } else {
                            String params = JSONArray.toJSONString(busiQrySKURspBO.getAttribute().get("param"));
                            if (!"null".equals(params)) {
                                ElectricityParam[] electricityParamArr = (ElectricityParam[])JsonUtils.jsonStringToJavaBean((String)params, ElectricityParam[].class);
                                List<ElectricityParam> electricityParams = Arrays.asList(electricityParamArr);
                                for (ElectricityParam electricityParam : electricityParams) {
                                    extPropBO = new AttributeExtPropChangeVO();
                                    extPropBO.setExtPropName(electricityParam.getAttrName());
                                    extPropBO.setExtPropValue(electricityParam.getAttrValue());
                                    extPropBOs.add(extPropBO);
                                }
                            }
                        }
                        busiAttributeChangeReqBO.setAttributeExtPropChanges(extPropBOs);
                    }
                    if ("0000".equals((busiAttributeChangeRspBO = this.busiAttributeChangeService.updateAttributeChange(busiAttributeChangeReqBO)).getRespCode())) {
                        if (busiAttributeChangeRspBO.getIsSuccess().booleanValue()) continue;
                        skuChangeRspVO.setExtSkuId(skuInfoChangeReqVO.getExtSkuId());
                        skuChangeRspVO.setExtSkuChangeId(skuInfoChangeReqVO.getExtSkuChangeId());
                        skuChangeRspVOs.add(skuChangeRspVO);
                        continue;
                    }
                    skuChangeRspVO.setExtSkuId(skuInfoChangeReqVO.getExtSkuId());
                    skuChangeRspVO.setExtSkuChangeId(skuInfoChangeReqVO.getExtSkuChangeId());
                    skuChangeRspVO.setErrorMsg(busiAttributeChangeRspBO.getRespDesc());
                    skuChangeRspVOs.add(skuChangeRspVO);
                    continue;
                }
                skuChangeRspVO.setExtSkuId(skuInfoChangeReqVO.getExtSkuId());
                skuChangeRspVO.setExtSkuChangeId(skuInfoChangeReqVO.getExtSkuChangeId());
                skuChangeRspVO.setErrorMsg("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u5546\u54c1\u4ecb\u7ecd\u53ca\u89c4\u683c\u53c2\u6570\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
                skuChangeRspVOs.add(skuChangeRspVO);
            }
            catch (Exception e) {
                logger.error("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u5546\u54c1\u4ecb\u7ecd\u53ca\u89c4\u683c\u53c2\u6570\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a" + e);
                skuChangeRspVO.setExtSkuId(skuInfoChangeReqVO.getExtSkuId());
                skuChangeRspVO.setExtSkuChangeId(skuInfoChangeReqVO.getExtSkuChangeId());
                skuChangeRspVO.setErrorMsg("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u5546\u54c1\u4ecb\u7ecd\u53ca\u89c4\u683c\u53c2\u6570\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a" + e);
                skuChangeRspVOs.add(skuChangeRspVO);
            }
        }
        return skuChangeRspVOs;
    }

    private List<SkuChangeRspVO> callJDExtSkuDetail(SkuChangeReqBO skuChangeReqBO) {
        logger.debug(" \u4eac\u4e1c\u6d88\u606f99\u53d8\u53d8\u66f4\u5f00\u59cb\uff1a");
        ArrayList<SkuChangeRspVO> skuChangeRspVOs = new ArrayList<SkuChangeRspVO>();
        HashMap<String, Long> measureNameAndIdMap = new HashMap<String, Long>();
        Long measureId = null;
        for (SkuInfoChangeReqVO skuInfoChangeReqVO : skuChangeReqBO.getSkuInfos()) {
            logger.debug(" \u4eac\u4e1c\u6d88\u606f99\u53d8\u53d8\u66f4\u5f00\u59cb\uff1a" + skuInfoChangeReqVO);
            SkuChangeRspVO skuChangeRspVO = new SkuChangeRspVO();
            try {
                BusiAttributeChangeReqBO busiAttributeChangeReqBO = new BusiAttributeChangeReqBO();
                busiAttributeChangeReqBO.setSupplierId(skuChangeReqBO.getSupplierId());
                busiAttributeChangeReqBO.setExtSkuId(skuInfoChangeReqVO.getExtSkuId());
                busiAttributeChangeReqBO.setSkuName(skuInfoChangeReqVO.getName());
                if (!StringUtils.isEmpty((CharSequence)skuInfoChangeReqVO.getSaleUnit())) {
                    if (measureNameAndIdMap.containsKey(skuInfoChangeReqVO.getSaleUnit())) {
                        measureId = (Long)measureNameAndIdMap.get(skuInfoChangeReqVO.getSaleUnit());
                    } else {
                        measureId = this.getMeasureId(skuInfoChangeReqVO.getSaleUnit());
                        measureNameAndIdMap.put(skuInfoChangeReqVO.getSaleUnit(), measureId);
                    }
                }
                busiAttributeChangeReqBO.setMeasureId(measureId);
                busiAttributeChangeReqBO.setMeasureName(skuInfoChangeReqVO.getSaleUnit());
                busiAttributeChangeReqBO.setTaxCode(skuInfoChangeReqVO.getTaxCode());
                BusiAttributeChangeRspBO busiAttributeChangeRspBO = this.busiAttributeChangeService.updateJDAttributeChange(busiAttributeChangeReqBO);
                if ("0000".equals(busiAttributeChangeRspBO.getRespCode())) {
                    if (busiAttributeChangeRspBO.getIsSuccess().booleanValue()) continue;
                    skuChangeRspVO.setExtSkuId(skuInfoChangeReqVO.getExtSkuId());
                    skuChangeRspVO.setExtSkuChangeId(skuInfoChangeReqVO.getExtSkuChangeId());
                    skuChangeRspVOs.add(skuChangeRspVO);
                    continue;
                }
                skuChangeRspVO.setExtSkuId(skuInfoChangeReqVO.getExtSkuId());
                skuChangeRspVO.setExtSkuChangeId(skuInfoChangeReqVO.getExtSkuChangeId());
                skuChangeRspVO.setErrorMsg(busiAttributeChangeRspBO.getRespDesc());
                skuChangeRspVOs.add(skuChangeRspVO);
            }
            catch (Exception e) {
                logger.error(" \u6d88\u606f\u7c7b\u578b -99  --- \u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u5546\u54c1\u4ecb\u7ecd\u53ca\u89c4\u683c\u53c2\u6570\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a", (Throwable)e);
                skuChangeRspVO.setExtSkuId(skuInfoChangeReqVO.getExtSkuId());
                skuChangeRspVO.setExtSkuChangeId(skuInfoChangeReqVO.getExtSkuChangeId());
                skuChangeRspVO.setErrorMsg("\u6d88\u606f\u7c7b\u578b ---99--- \u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u5546\u54c1\u4ecb\u7ecd\u53ca\u89c4\u683c\u53c2\u6570\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
                skuChangeRspVOs.add(skuChangeRspVO);
            }
        }
        return skuChangeRspVOs;
    }

    private Long getBrandId(BusiQrySKURspBO busiQrySKURspBO) {
        if (StringUtils.isEmpty((CharSequence)busiQrySKURspBO.getBrandName())) {
            return null;
        }
        try {
            Brand oldBrand = this.brandMapper.selectByName(busiQrySKURspBO.getBrandName());
            Long brandId = 0L;
            if (null == oldBrand) {
                GenerateBrandSeqRspBO generateBrandSeqRspBO = this.generateBrandSeqService.generateBrandSeq();
                brandId = generateBrandSeqRspBO.getBrandId();
                Brand record = new Brand();
                record.setBrandId(generateBrandSeqRspBO.getBrandId());
                record.setBrandName(busiQrySKURspBO.getBrandName());
                record.setEffTime(DelFormatHelper.getNowYearAndMonthDay());
                record.setExpTime(DelFormatHelper.getNowYearAndMonthDay((String)"2050-12-31"));
                record.setBrandStatus(Constant.BRAND_STATUS_OPEN);
                record.setCreateLoginId(666L);
                record.setCreateTime(new Date());
                record.setIsDelete(Constant.IS_DELETE);
                BrandConsumerBO brandConsumerBO = new BrandConsumerBO();
                BeanUtils.copyProperties((Object)record, (Object)brandConsumerBO);
                this.producerBrand.sendOneway(new ProxyMessage(this.topicConfig.getBrandTopicName(), this.topicConfig.getBrandTagName(), JSONObject.toJSONString((Object)brandConsumerBO)));
            } else {
                brandId = oldBrand.getBrandId();
            }
            return brandId;
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u5546\u54c1\u4ecb\u7ecd\u53ca\u89c4\u683c\u53c2\u6570\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u54c1\u724c\u65b0\u589e\u5931\u8d25\uff1a", (Throwable)e);
            return null;
        }
    }

    private Long getMeasureId(String saleUnit) {
        if (StringUtils.isEmpty((CharSequence)saleUnit)) {
            return null;
        }
        try {
            CommodityMeasure commodityMeasure = this.commodityMeasureMapper.selectByName(saleUnit);
            Long measureId = 0L;
            if (null == commodityMeasure) {
                GenerateMeasureSeqRspBO generateMeasureSeqRspBO = this.generateMeasureSeqService.generateMeasureSeq();
                CommodityMeasureBO record = new CommodityMeasureBO();
                measureId = generateMeasureSeqRspBO.getMeasuerId();
                record.setMeasureId(measureId);
                record.setMeasureName(saleUnit);
                record.setMeasureType(Integer.valueOf(0));
                record.setIsDelete(Byte.valueOf((byte)0));
                record.setCreateTime(new Date());
                logger.debug("\u8ba1\u91cf\u5355\u4f4d\u6d88\u606f\u961f\u5217topic\u540d\u79f0\uff1a" + this.topicConfig.getMeasureTopicName());
                this.producerMeasure.sendOneway(new ProxyMessage(this.topicConfig.getMeasureTopicName(), this.topicConfig.getMeasureTagName(), JSONObject.toJSONString((Object)record)));
                logger.debug("\u8ba1\u91cf\u5355\u4f4d\u6d88\u606f\u961f\u5217tag\u540d\u79f0\uff1a" + this.topicConfig.getMeasureTagName() + "name:" + record.getMeasureName() + "Id\uff1a" + record.getMeasureId());
            } else {
                measureId = commodityMeasure.getMeasureId();
            }
            return measureId;
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u53d8\u5316\u7ec4\u5408\u670d\u52a1\u5546\u54c1\u4ecb\u7ecd\u53ca\u89c4\u683c\u53c2\u6570\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u8ba1\u91cf\u5355\u4f4d\u65b0\u589e\u5931\u8d25\uff1a", (Throwable)e);
            return null;
        }
    }
}

