/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.type.Impl;

import com.cgd.commodity.dao.MdmCatalogMapper;
import com.ohaotian.commodity.busi.manage.market.extend.QueryCatalogNameService;
import com.ohaotian.commodity.busi.type.QueryCommodityTypeLevelListService;
import com.ohaotian.commodity.busi.type.bo.QueryCommodityTypeLevelListReqBO;
import com.ohaotian.commodity.busi.type.bo.QueryCommodityTypeLevelListRspBO;
import com.ohaotian.commodity.dao.CommodityTypeLevelMapper;
import com.ohaotian.commodity.dao.po.CommodityTypeLevel;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="queryCommodityTypeLevelListService")
public class QueryCommodityTypeLevelListServiceImpl
implements QueryCommodityTypeLevelListService {
    private static final Logger logger = LoggerFactory.getLogger(QueryCommodityTypeLevelListServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private CommodityTypeLevelMapper commodityTypeLevelMapper;
    @Autowired
    private MdmCatalogMapper mdmCatalogMapper;
    @Autowired
    private QueryCatalogNameService queryCatalogNameService;

    public RspPageBO<QueryCommodityTypeLevelListRspBO> queryCommodityTypeLevelList(QueryCommodityTypeLevelListReqBO queryCommodityTypeLevelListReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5546\u54c1\u7c7b\u578b\u7b49\u7ea7\u5217\u8868\u67e5\u8be2\u5165\u53c2\uff1a" + queryCommodityTypeLevelListReqBO.toString());
        }
        RspPageBO rspPageBO = new RspPageBO();
        ArrayList<QueryCommodityTypeLevelListRspBO> qctl = new ArrayList<QueryCommodityTypeLevelListRspBO>();
        Page page = new Page(queryCommodityTypeLevelListReqBO.getPageNo(), queryCommodityTypeLevelListReqBO.getPageSize());
        try {
            List<CommodityTypeLevel> list = this.commodityTypeLevelMapper.queryCommodityTypeLevelList((Page<CommodityTypeLevel>)page, queryCommodityTypeLevelListReqBO.getCategory1Id(), queryCommodityTypeLevelListReqBO.getCategory2Id(), queryCommodityTypeLevelListReqBO.getCategory3Id(), queryCommodityTypeLevelListReqBO.getCategory4Id(), queryCommodityTypeLevelListReqBO.getCommodityTypeId(), queryCommodityTypeLevelListReqBO.getAuditLevel());
            for (CommodityTypeLevel value : list) {
                List<String> cName = this.queryCatalogNameService.queryObjByCatalogId(value);
                String cateName = "";
                if (cName != null && cName.size() > 0) {
                    cateName = String.join((CharSequence)",", cName);
                    cateName = cateName.replace(",", "/");
                }
                QueryCommodityTypeLevelListRspBO bo = new QueryCommodityTypeLevelListRspBO();
                bo.setCategory1Id(value.getCategory1Id());
                bo.setCategory2Id(value.getCategory2Id());
                bo.setCategory3Id(value.getCategory3Id());
                bo.setCategory4Id(value.getCategory4Id());
                bo.setAuditLevel(value.getAuditLevel());
                bo.setId(value.getId());
                bo.setCommodityTypeId(value.getCommodityTypeId());
                bo.setCreateLoginId(value.getCreateLoginId());
                bo.setCreateTime(value.getCreateTime());
                bo.setUpdateLoginId(value.getUpdateLoginId());
                bo.setUpdateTime(value.getUpdateTime());
                bo.setIsDelete(value.getIsDelete());
                bo.setExtJson(value.getExtJson());
                bo.setCatelogName(cateName);
                qctl.add(bo);
            }
            rspPageBO.setRespCode("0000");
            rspPageBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u7c7b\u578b\u7b49\u7ea7\u5217\u8868\u67e5\u8be2\u51fa\u9519", (Throwable)e);
            rspPageBO.setRespCode("8888");
            rspPageBO.setRespDesc("\u5931\u8d25");
        }
        rspPageBO.setPageNo(queryCommodityTypeLevelListReqBO.getPageNo());
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setRows(qctl);
        rspPageBO.setTotal(page.getTotalPages());
        return rspPageBO;
    }
}

