/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.BatQrySkuService;
import com.cgd.commodity.busi.bo.BatQrySkuReqBO;
import com.cgd.commodity.busi.bo.BatQrySkuRspBO;
import com.cgd.commodity.busi.bo.SkuInfoRsp;
import com.cgd.commodity.busi.bo.SkuSpecRspBO;
import com.cgd.commodity.dao.AgreementScopeMapper;
import com.cgd.commodity.dao.CommodityMeasureMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SkuPriceMapper;
import com.cgd.commodity.dao.SkuSpecMapper;
import com.cgd.commodity.po.AgreementScope;
import com.cgd.commodity.po.CommodityMeasure;
import com.cgd.commodity.po.Sku;
import com.cgd.commodity.po.SkuPrice;
import com.cgd.commodity.po.SkuSpec;
import com.cgd.user.org.busi.QryLittleActOrgByUserBusiService;
import com.cgd.user.org.busi.bo.QryLittleActOrgByUserReqBO;
import com.cgd.user.org.busi.bo.QryLittleActOrgByUserRspBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BatQrySkuServiceImpl
implements BatQrySkuService {
    private static final Logger logger = LoggerFactory.getLogger(BatQrySkuServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private SkuPriceMapper skuPriceMapper;
    @Autowired
    private SkuSpecMapper skuSpecMapper;
    @Autowired
    private AgreementScopeMapper agreementScopeMapper;
    @Autowired
    private QryLittleActOrgByUserBusiService qryLittleActOrgByUserBusiService;
    @Autowired
    private CommodityMeasureMapper commodityMeasureMapper;
    private Properties prop;

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    /*
     * WARNING - void declaration
     */
    public BatQrySkuRspBO batQrySku(BatQrySkuReqBO batQrySkuReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5546\u54c1\u4e2d\u5fc3\u6279\u91cf\u83b7\u53d6Sku\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + batQrySkuReqBO.toString());
        }
        if (null == batQrySkuReqBO.getSkuIds()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u4e2d\u5fc3\u6279\u91cf\u83b7\u53d6Sku\u4e1a\u52a1\u670d\u52a1\u5355\u54c1IDS[skuIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == batQrySkuReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u4e2d\u5fc3\u6279\u91cf\u83b7\u53d6Sku\u4e1a\u52a1\u670d\u52a1\u4f9b\u5e94\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            HashMap<String, Object> skuIdsParam = new HashMap<String, Object>();
            List skuIds = batQrySkuReqBO.getSkuIds();
            skuIdsParam.put("skuIds", skuIds);
            skuIdsParam.put("supplierId", batQrySkuReqBO.getSupplierId());
            List<Sku> skuList = this.skuMapper.qrySkuBySkuIdsAndSupplierId(skuIdsParam);
            BatQrySkuRspBO batQrySkuRspBO = new BatQrySkuRspBO();
            if (batQrySkuReqBO.getUserId() != null) {
                batQrySkuRspBO.setIsLogin(Boolean.valueOf(true));
            } else {
                batQrySkuRspBO.setIsLogin(Boolean.valueOf(false));
            }
            ArrayList<SkuInfoRsp> results = new ArrayList<SkuInfoRsp>();
            List<SkuPrice> skuPriceList = this.skuPriceMapper.qryPriceBySkuIdsAndSupplierId(skuIdsParam);
            List<SkuSpec> skuSpecList = this.skuSpecMapper.qrySpecBySkuIdsAndSupplierId(skuIdsParam);
            ArrayList<Long> measureIds = new ArrayList<Long>();
            for (Sku value : skuList) {
                if (null == value.getMeasureId()) continue;
                measureIds.add(value.getMeasureId());
            }
            HashMap<Long, CommodityMeasure> commodityMeasureMap = new HashMap<Long, CommodityMeasure>();
            if (measureIds.size() > 0) {
                List<CommodityMeasure> commodityMeasures = this.commodityMeasureMapper.selectByMeasureIds(measureIds);
                for (CommodityMeasure commodityMeasure : commodityMeasures) {
                    commodityMeasureMap.put(commodityMeasure.getMeasureId(), commodityMeasure);
                }
            }
            if (skuList != null && skuList.size() > 0) {
                Long vendorId = Long.parseLong(this.prop.getProperty("VENDOR_ID"));
                for (Sku sku : skuList) {
                    SkuInfoRsp skuInfoRsp = new SkuInfoRsp();
                    BeanUtils.copyProperties((Object)skuInfoRsp, (Object)sku);
                    skuInfoRsp.setVendorId(vendorId);
                    if (null != sku.getMeasureId() && commodityMeasureMap.size() != 0) {
                        skuInfoRsp.setMeasureType(((CommodityMeasure)commodityMeasureMap.get(sku.getMeasureId())).getMeasureType());
                    }
                    if (skuPriceList != null && skuPriceList.size() > 0) {
                        for (SkuPrice skuPrice : skuPriceList) {
                            if (!sku.getSkuId().equals(skuPrice.getSkuId())) continue;
                            if (skuPrice.getMarketPrice() != null) {
                                skuInfoRsp.setMarketPrice(MoneyUtils.Long2BigDecimal((Long)skuPrice.getMarketPrice()));
                            }
                            if (skuPrice.getAgreementPrice() != null) {
                                skuInfoRsp.setAgreementPrice(MoneyUtils.Long2BigDecimal((Long)skuPrice.getAgreementPrice()));
                            }
                            if (skuPrice.getMemberPrice() != null) {
                                skuInfoRsp.setMemberPrice(MoneyUtils.Long2BigDecimal((Long)skuPrice.getMemberPrice()));
                            }
                            if (skuPrice.getSalePrice() != null) {
                                skuInfoRsp.setSalePrice(MoneyUtils.Long2BigDecimal((Long)skuPrice.getSalePrice()));
                            }
                            if (skuPrice.getCurrencyType() != null) {
                                skuInfoRsp.setCurrencyType(skuPrice.getCurrencyType());
                            }
                            skuInfoRsp.setAgreementId(skuPrice.getAgreementId());
                            break;
                        }
                    }
                    if (skuSpecList != null && skuSpecList.size() > 0) {
                        ArrayList<SkuSpecRspBO> skuSpec = new ArrayList<SkuSpecRspBO>();
                        for (Object spec : skuSpecList) {
                            if (!sku.getSkuId().equals(((SkuSpec)spec).getSkuId())) continue;
                            SkuSpecRspBO skuSpecRspBO = new SkuSpecRspBO();
                            skuSpecRspBO.setPropDefId(((SkuSpec)spec).getCommoditySpecId());
                            skuSpecRspBO.setPropGroupId(((SkuSpec)spec).getCommodityPropGrpId());
                            skuSpecRspBO.setPropName(((SkuSpec)spec).getPropName());
                            skuSpecRspBO.setPropShowName(((SkuSpec)spec).getPropShowName());
                            skuSpecRspBO.setPropValue(((SkuSpec)spec).getPropValue());
                            skuSpecRspBO.setPropValueId(((SkuSpec)spec).getPropValueListId());
                            skuSpecRspBO.setSkuSpecId(((SkuSpec)spec).getSkuSpecId());
                            skuSpec.add(skuSpecRspBO);
                        }
                        skuInfoRsp.setSkuSpec(skuSpec);
                    }
                    results.add(skuInfoRsp);
                }
                QryLittleActOrgByUserReqBO qryLittleActOrgByUserReqBO = new QryLittleActOrgByUserReqBO();
                qryLittleActOrgByUserReqBO.setUserParamId(batQrySkuReqBO.getUserId());
                QryLittleActOrgByUserRspBO qryLittleActOrgByUserRspBO = this.qryLittleActOrgByUserBusi(qryLittleActOrgByUserReqBO);
                ArrayList<Long> agreementIds = new ArrayList<Long>();
                Map<Long, Integer> flagMap = null;
                Integer n = 0;
                if (skuPriceList != null && skuPriceList.size() > 0) {
                    for (SkuPrice skuPrice : skuPriceList) {
                        agreementIds.add(skuPrice.getAgreementId());
                    }
                }
                if (agreementIds != null && agreementIds.size() > 0) {
                    List<AgreementScope> agreementScopeList = this.agreementScopeMapper.selectByAgreementIds(agreementIds, batQrySkuReqBO.getSupplierId());
                    if (agreementScopeList != null && agreementScopeList.size() > 0) {
                        flagMap = this.checkPurchasableList(agreementScopeList, qryLittleActOrgByUserRspBO);
                    }
                } else {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u4f9b\u8d27\u5546Id\u548cSkuId\u67e5\u8be2\u5546\u54c1\u4ef7\u683c\u8868\u6570\u636e\u4e0d\u5b58\u5728");
                }
                for (SkuInfoRsp skuInfoRsp : results) {
                    void var16_21;
                    if (flagMap != null && flagMap.get(skuInfoRsp.getAgreementId()) != null) {
                        Integer n2 = flagMap.get(skuInfoRsp.getAgreementId());
                    }
                    skuInfoRsp.setPurchasableFlag((Integer)var16_21);
                }
                batQrySkuRspBO.setResults(results);
            }
            if (this.isDebugEnabled) {
                logger.debug("\u5546\u54c1\u4e2d\u5fc3\u6279\u91cf\u83b7\u53d6Sku\u4e1a\u52a1\u670d\u52a1\u51fa\u53c2\uff1a" + batQrySkuRspBO.toString());
            }
            return batQrySkuRspBO;
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u4e2d\u5fc3\u6279\u91cf\u83b7\u53d6Sku\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u4e2d\u5fc3\u6279\u91cf\u83b7\u53d6Sku\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
    }

    private QryLittleActOrgByUserRspBO qryLittleActOrgByUserBusi(QryLittleActOrgByUserReqBO qryLittleActOrgByUserReqBO) {
        try {
            QryLittleActOrgByUserRspBO qryLittleActOrgByUser = this.qryLittleActOrgByUserBusiService.qryLittleActOrgByUser(qryLittleActOrgByUserReqBO);
            return qryLittleActOrgByUser;
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u7528\u6237\u67e5\u8be2\u5206\u5b50\u516c\u53f8\u3001\u9879\u76ee\u5355\u4f4d\u4fe1\u606f\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u6839\u636e\u7528\u6237\u67e5\u8be2\u5206\u5b50\u516c\u53f8\u3001\u9879\u76ee\u5355\u4f4d\u4fe1\u606f\u5931\u8d25");
        }
    }

    private Map<Long, Integer> checkPurchasableList(List<AgreementScope> agreementScopeList, QryLittleActOrgByUserRspBO qryLittleActOrgByUserRspBO) {
        HashMap<Long, Integer> flgMap = new HashMap<Long, Integer>();
        if (qryLittleActOrgByUserRspBO == null) {
            return flgMap;
        }
        if (agreementScopeList != null && agreementScopeList.size() > 0) {
            for (AgreementScope agreementScope : agreementScopeList) {
                if (agreementScope.getScopeType() != null && agreementScope.getScopeType() == 0) {
                    flgMap.put(agreementScope.getAgreementId(), 1);
                    break;
                }
                if (agreementScope.getScopeType() != null && agreementScope.getScopeType() == 1 && qryLittleActOrgByUserRspBO.getProvId() != null && qryLittleActOrgByUserRspBO.getProvId().equals(agreementScope.getScopeCode())) {
                    flgMap.put(agreementScope.getAgreementId(), 1);
                    break;
                }
                if (agreementScope.getScopeType() != null && agreementScope.getScopeType() == 2 && qryLittleActOrgByUserRspBO.getTrade() != null && qryLittleActOrgByUserRspBO.getTrade().equals(agreementScope.getScopeCode())) {
                    flgMap.put(agreementScope.getAgreementId(), 1);
                    break;
                }
                if (agreementScope.getScopeType() != null && agreementScope.getScopeType() == 3 && qryLittleActOrgByUserRspBO.getBranchComp() != null && qryLittleActOrgByUserRspBO.getBranchComp().getAutoId() != null && qryLittleActOrgByUserRspBO.getBranchComp().getAutoId().equals(agreementScope.getScopeCode())) {
                    flgMap.put(agreementScope.getAgreementId(), 1);
                    break;
                }
                if (agreementScope.getScopeType() != null && agreementScope.getScopeType() == 4 && qryLittleActOrgByUserRspBO.getProjectComp() != null && qryLittleActOrgByUserRspBO.getProjectComp().getAutoId() != null && qryLittleActOrgByUserRspBO.getProjectComp().getAutoId().equals(agreementScope.getScopeCode())) {
                    flgMap.put(agreementScope.getAgreementId(), 1);
                    break;
                }
                flgMap.put(agreementScope.getAgreementId(), 0);
            }
        }
        return flgMap;
    }

    public void setProp(Properties prop) {
        this.prop = prop;
    }
}

