/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.MdmQryCatalogNameByIdsService;
import com.cgd.commodity.busi.bo.MdmQryCatalogNameReqBO;
import com.cgd.commodity.busi.bo.MdmQryCatalogNameRspBO;
import com.cgd.commodity.busi.impl.MdmQryCatalogNameServiceImpl;
import com.cgd.commodity.busi.vo.MdmQryCatalogNameRspVO;
import com.cgd.commodity.dao.MdmCatalogMapper;
import com.cgd.commodity.po.MdmCatalogPO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdmQryCatalogNameByIdsServiceImpl
implements MdmQryCatalogNameByIdsService {
    private static final Logger logger = LoggerFactory.getLogger(MdmQryCatalogNameServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private MdmCatalogMapper mdmCatalogMapper;
    private CacheClient cacheClient;

    public MdmQryCatalogNameRspBO qryCatalogNameByids(MdmQryCatalogNameReqBO mdmQryCatalogNameReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u4e3b\u6570\u636e\u5206\u7c7b\u540d\u79f0\u67e5\u8be2\u670d\u52a1\u5165\u53c2\uff1a" + mdmQryCatalogNameReqBO.toString());
        }
        MdmQryCatalogNameRspBO rspBO = new MdmQryCatalogNameRspBO();
        List ids = mdmQryCatalogNameReqBO.getIds();
        ArrayList<MdmQryCatalogNameRspVO> rspBOList = new ArrayList<MdmQryCatalogNameRspVO>();
        ArrayList<String> noRedisList = new ArrayList<String>();
        try {
            for (String catalogId : ids) {
                MdmQryCatalogNameRspVO cacheRspVO = new MdmQryCatalogNameRspVO();
                if (this.cacheClient.get("CATALOG_ID" + catalogId) != null) {
                    cacheRspVO = (MdmQryCatalogNameRspVO)this.cacheClient.get("CATALOG_ID" + catalogId);
                    rspBOList.add(cacheRspVO);
                    continue;
                }
                noRedisList.add(catalogId);
            }
            if (noRedisList.size() > 0) {
                List<MdmCatalogPO> mdmCatalogPOs = this.mdmCatalogMapper.selectByCatalogIds(noRedisList);
                if (null != mdmCatalogPOs && mdmCatalogPOs.size() > 0) {
                    for (MdmCatalogPO mdmCatalogPO : mdmCatalogPOs) {
                        MdmQryCatalogNameRspVO rspVO = new MdmQryCatalogNameRspVO();
                        rspVO.setCatalogId(this.cataLogToString(mdmCatalogPO));
                        rspVO.setCatalogName(mdmCatalogPO.getCatalogName());
                        this.cacheClient.set("CATALOG_ID" + mdmQryCatalogNameReqBO.getCatalogId(), (Object)rspVO, 86400000);
                        rspBOList.add(rspVO);
                    }
                } else {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u96c6\u5408\u4e2d\u6709\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                }
            }
            rspBO.setMdmQryCatalogNameRspVOs(rspBOList);
            return rspBO;
        }
        catch (Exception e) {
            rspBO.setRespDesc("\u4e3b\u6570\u636e\u5206\u7c7b\u540d\u79f0\u67e5\u8be2\u670d\u52a1\u51fa\u9519");
            rspBO.setRespCode("8888");
            logger.error("\u4e3b\u6570\u636e\u5206\u7c7b\u540d\u79f0\u67e5\u8be2\u670d\u52a1\u51fa\u9519", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e3b\u6570\u636e\u5206\u7c7b\u540d\u79f0\u67e5\u8be2\u670d\u52a1\u51fa\u9519");
        }
    }

    private String cataLogToString(MdmCatalogPO mdmCatalogPO) {
        String result = String.valueOf(mdmCatalogPO.getCatalogId());
        int catalogIdLength = String.valueOf(mdmCatalogPO.getCatalogId()).length();
        if (catalogIdLength == 1 || catalogIdLength == 3 || catalogIdLength == 5 || catalogIdLength == 8) {
            result = "0" + result;
        }
        return result;
    }

    public void setMdmCatalogMapper(MdmCatalogMapper mdmCatalogMapper) {
        this.mdmCatalogMapper = mdmCatalogMapper;
    }

    public void setCacheClient(CacheClient cacheClient) {
        this.cacheClient = cacheClient;
    }
}

