/*
 * Decompiled with CFR 0.152.
 */
package com.gd.commodity.busi.impl;

import com.cgd.common.loader.perms.DataPermissionBean;
import com.cgd.common.loader.perms.PermissionCacheService;
import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdAndCompIdBusiService;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdAndCompIdReqBO;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdAndCompIdRspBO;
import com.gd.commodity.busi.QryAgrsBySupplierManagerService;
import com.gd.commodity.busi.bo.agreement.QryAgrsByCurrManagerReqBO;
import com.gd.commodity.busi.bo.agreement.QryAgrsByCurrManagerRspBO;
import com.gd.commodity.busi.impl.QryAgrsByCurrManagerServiceImpl;
import com.gd.commodity.dao.SupplierAgreementMapper;
import com.gd.commodity.dao.SupplierAgreementSkuMapper;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class QryAgrsBySupplierManagerServiceImpl
implements QryAgrsBySupplierManagerService {
    private static final Logger logger = LoggerFactory.getLogger(QryAgrsByCurrManagerServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SupplierAgreementMapper supplierAgreementMapper;
    @Autowired
    private SupplierAgreementSkuMapper supplierAgreementSkuMapper;
    @Autowired
    private SelectUserInfoByUserIdAndCompIdBusiService selectUserInfoByUserIdAndCompIdBusiService;
    @Autowired
    private PermissionCacheService permissionCacheService;

    public RspPageBO<QryAgrsByCurrManagerRspBO> qryAgrsBySupplierManage(QryAgrsByCurrManagerReqBO qryAgrsByCurrManagerReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u6211\u7684\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryAgrsByCurrManagerReqBO.toString());
        }
        if (null == qryAgrsByCurrManagerReqBO.getUserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7528\u6237ID[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == qryAgrsByCurrManagerReqBO.getAgreementSrc()) {
            Byte agrSrc = 1;
            qryAgrsByCurrManagerReqBO.setAgreementSrc(agrSrc);
        }
        try {
            Set authorisedOrgIds;
            DataPermissionBean dataPermission = this.permissionCacheService.getDataPermission(PermissionCacheService.ResrcCode.terraceAgreementCheck, qryAgrsByCurrManagerReqBO.getUserId());
            if (dataPermission != null && (authorisedOrgIds = dataPermission.getAuthorisedOrgIds()) != null && !authorisedOrgIds.isEmpty()) {
                ArrayList deptIds = new ArrayList(authorisedOrgIds);
                qryAgrsByCurrManagerReqBO.setVendorDepartmentIds(deptIds);
            }
            Long supplierId = null;
            Long userId = qryAgrsByCurrManagerReqBO.getUserId();
            qryAgrsByCurrManagerReqBO.setUserId(null);
            Page page = new Page(qryAgrsByCurrManagerReqBO.getPageNo(), qryAgrsByCurrManagerReqBO.getPageSize());
            List<Object> results = new ArrayList();
            if (!StringUtils.isEmpty((Object)qryAgrsByCurrManagerReqBO.getMaterialId())) {
                List<Long> agreementIds = this.supplierAgreementSkuMapper.qryAgrIdsByIdAndMaterialName(supplierId, qryAgrsByCurrManagerReqBO.getMaterialId());
                if (!agreementIds.isEmpty()) {
                    results = this.supplierAgreementMapper.qryByManagerSelectCondition((Page<QryAgrsByCurrManagerReqBO>)page, qryAgrsByCurrManagerReqBO, agreementIds, supplierId);
                }
            } else {
                results = this.supplierAgreementMapper.qryByManagerSelectCondition((Page<QryAgrsByCurrManagerReqBO>)page, qryAgrsByCurrManagerReqBO, null, supplierId);
            }
            RspPageBO rspPageBO = new RspPageBO();
            rspPageBO.setRecordsTotal(page.getTotalCount());
            rspPageBO.setTotal(page.getTotalPages());
            rspPageBO.setPageNo(qryAgrsByCurrManagerReqBO.getPageNo());
            rspPageBO.setRows(results);
            return rspPageBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6211\u7684\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u6211\u7684\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private Long getUserSupplierId(Long userId) {
        try {
            SelectUserInfoByUserIdAndCompIdReqBO selectUserInfoAndCompIdReqBO = new SelectUserInfoByUserIdAndCompIdReqBO();
            selectUserInfoAndCompIdReqBO.setUserId(userId);
            SelectUserInfoByUserIdAndCompIdRspBO selectUserInfoByUserIdAndCompIdRspBO = this.selectUserInfoByUserIdAndCompIdBusiService.selectUserInfoByUserIdAndCompId(selectUserInfoAndCompIdReqBO);
            if ("0000".equals(selectUserInfoByUserIdAndCompIdRspBO.getRespCode())) {
                return selectUserInfoByUserIdAndCompIdRspBO.getCompId();
            }
            return null;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u542f\u7528\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u6839\u636e\u7528\u6237\u67e5\u94fa\u8d27\u5355\u4f4d\u4fe1\u606f\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u6839\u636e\u7528\u6237\u67e5\u94fa\u8d27\u5355\u4f4d\u4fe1\u606f\u5931\u8d25");
        }
    }
}

