/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.distribute.impl;

import com.cgd.workflow.bo.BpmStartReqBO;
import com.cgd.workflow.bo.BpmStartRspBO;
import com.cgd.workflow.busin.service.BpmStartBusinService;
import com.ohaotian.commodity.atom.GenerateSkuPicSeqService;
import com.ohaotian.commodity.atom.bo.GenerateSkuPicSeqRspBO;
import com.ohaotian.commodity.busi.constant.Constant;
import com.ohaotian.commodity.busi.constant.SupplyConstant;
import com.ohaotian.commodity.busi.distribute.web.UpdateSkuPicBatchService;
import com.ohaotian.commodity.busi.distribute.web.bo.UpdateSkuPicBO;
import com.ohaotian.commodity.busi.distribute.web.bo.UpdateSkuPicBatchReqBO;
import com.ohaotian.commodity.busi.distribute.web.bo.UpdateSkuPicBatchRspBO;
import com.ohaotian.commodity.common.exception.BusinessException;
import com.ohaotian.commodity.dao.SkuMapper;
import com.ohaotian.commodity.dao.SkuOnShelveLogMapper;
import com.ohaotian.commodity.dao.SkuPicMapper;
import com.ohaotian.commodity.dao.SkuPriceMapper;
import com.ohaotian.commodity.dao.po.Sku;
import com.ohaotian.commodity.dao.po.SkuOnShelveLog;
import com.ohaotian.commodity.dao.po.SkuPic;
import com.ohaotian.commodity.dao.po.SkuPrice;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="updateSkuPicBatchService")
public class UpdateSkuPicBatchServiceImpl
implements UpdateSkuPicBatchService {
    private static final Logger logger = LoggerFactory.getLogger(UpdateSkuPicBatchServiceImpl.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private GenerateSkuPicSeqService generateSkuPicSeqService;
    @Autowired
    private SkuPicMapper skuPicMapper;
    @Autowired
    private BpmStartBusinService bpmStartBusinService;
    @Autowired
    private SkuOnShelveLogMapper skuOnShelveLogMapper;
    @Autowired
    private SkuPriceMapper skuPriceMapper;

    public UpdateSkuPicBatchRspBO updateSkuPicBatch(UpdateSkuPicBatchReqBO updateSkuPicBatchReqBO) {
        if (isDebugEnabled) {
            logger.debug("\u6279\u91cf\u66f4\u65b0\u5546\u54c1\u56fe\u7247\u670d\u52a1\u5165\u53c2\uff1a" + updateSkuPicBatchReqBO.toString());
        }
        UpdateSkuPicBatchRspBO rspBO = new UpdateSkuPicBatchRspBO();
        try {
            for (Long skuId : updateSkuPicBatchReqBO.getSkuIds()) {
                Sku oldSku = this.skuMapper.selectBySkuIdAndSupplierId(skuId, updateSkuPicBatchReqBO.getSupplierId());
                if (null != oldSku) {
                    this.updateSku(updateSkuPicBatchReqBO, oldSku);
                    this.updateSkuPic(updateSkuPicBatchReqBO, oldSku);
                    if (0 != updateSkuPicBatchReqBO.getOperateType().intValue()) continue;
                    this.skuOnShelveApprove(updateSkuPicBatchReqBO, oldSku.getSkuId(), oldSku);
                    continue;
                }
                if (isDebugEnabled) {
                    logger.debug("\u6279\u91cf\u66f4\u65b0\u5546\u54c1\u56fe\u7247\u670d\u52a1\u6839\u636eSKUID\u67e5\u8be2SKU\u4e0d\u5b58\u5728");
                }
                throw new BusinessException("RSP_CODE_SKU_NOT_EXIST", "\u6839\u636eSKUID\u67e5\u8be2SKU\u4e0d\u5b58\u5728");
            }
            rspBO.setIsSuccess(Boolean.valueOf(true));
            rspBO.setResltMsg("\u66f4\u65b0\u6210\u529f");
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u66f4\u65b0\u5546\u54c1\u56fe\u7247\u670d\u52a1\u51fa\u9519" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "CREATE_SKU_SERVICE_RSP_FAIL" : ((BusinessException)e).getMsgCode();
                throw new BusinessException(resultCode, "\u6279\u91cf\u66f4\u65b0\u5546\u54c1\u56fe\u7247\u670d\u52a1\u5931\u8d25:" + e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6279\u91cf\u66f4\u65b0\u5546\u54c1\u56fe\u7247\u670d\u52a1\u5931\u8d25");
        }
    }

    private void updateSku(UpdateSkuPicBatchReqBO updateSkuPicBatchReqBO, Sku oldSku) {
        try {
            Sku sku = new Sku();
            sku.setSkuId(oldSku.getSkuId());
            sku.setSupplierId(oldSku.getSupplierId());
            Boolean updateFlag = false;
            String picUrl = null;
            if (!updateSkuPicBatchReqBO.getSkuPics().isEmpty()) {
                for (UpdateSkuPicBO updateSkuPicBO : updateSkuPicBatchReqBO.getSkuPics()) {
                    if (null == updateSkuPicBO.getIsPrimary() || 1 != updateSkuPicBO.getIsPrimary().intValue()) continue;
                    picUrl = updateSkuPicBO.getSkuPicUrl();
                    break;
                }
            }
            if (!StringUtils.isEmpty((Object)oldSku.getSkuMainPicUrl())) {
                if (!oldSku.getSkuMainPicUrl().equals(picUrl)) {
                    sku.setSkuMainPicUrl(picUrl);
                    updateFlag = true;
                }
            } else {
                sku.setSkuMainPicUrl(picUrl);
                updateFlag = true;
            }
            if (null != oldSku.getOnShelveWay() && updateSkuPicBatchReqBO.getOnShelveWay().byteValue() != oldSku.getOnShelveWay().byteValue()) {
                sku.setOnShelveWay(updateSkuPicBatchReqBO.getOnShelveWay().intValue());
                updateFlag = true;
            }
            if (null != oldSku.getPreOnShelveDay() && updateSkuPicBatchReqBO.getPreOnShelveDay() != oldSku.getPreOnShelveDay().intValue()) {
                sku.setPreOnShelveDay(updateSkuPicBatchReqBO.getPreOnShelveDay());
                updateFlag = true;
            }
            if (null != oldSku.getOnShelveTime() && updateSkuPicBatchReqBO.getOnShelveTime() != oldSku.getOnShelveTime()) {
                sku.setOnShelveTime(updateSkuPicBatchReqBO.getOnShelveTime());
                updateFlag = true;
            }
            if (0 == updateSkuPicBatchReqBO.getOperateType().intValue()) {
                sku.setSkuStatus(Constant.SKU_STATUS_PUSHING);
                updateFlag = true;
            }
            if (1 == updateSkuPicBatchReqBO.getOperateType().intValue()) {
                sku.setSkuStatus(Constant.SKU_STATUS_DRAFT);
                updateFlag = true;
            }
            if (updateFlag.booleanValue()) {
                sku.setUpdateLoginId(updateSkuPicBatchReqBO.getUserId());
                sku.setUpdateTime(new Date());
                this.skuMapper.updateByPrimaryKeySelective(sku, oldSku.getSupplierId());
            }
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u66f4\u65b0\u5546\u54c1\u56fe\u7247\u670d\u52a1\u5546\u54c1\u4fe1\u606f\u66f4\u65b0\u5931\u8d25:" + e);
            throw new BusinessException(null, "\u5546\u54c1\u4fe1\u606f\u66f4\u65b0\u5931\u8d25");
        }
    }

    private void updateSkuPic(UpdateSkuPicBatchReqBO updateSkuPicBatchReqBO, Sku oldSku) {
        try {
            List<SkuPic> oldSkuPics;
            ArrayList<Long> skuPicIds = new ArrayList<Long>();
            ArrayList<SkuPic> skuPics = new ArrayList<SkuPic>();
            if (!updateSkuPicBatchReqBO.getSkuPics().isEmpty()) {
                for (UpdateSkuPicBO updateSkuPicBO : updateSkuPicBatchReqBO.getSkuPics()) {
                    GenerateSkuPicSeqRspBO generateSkuPicSeqRspBO = this.generateSkuPicSeqService.generateSkuPicSeq();
                    SkuPic skuPic = new SkuPic();
                    skuPic.setSkuPicId(generateSkuPicSeqRspBO.getSkuPicId());
                    skuPic.setCommodityId(oldSku.getCommodityId());
                    skuPic.setSkuId(oldSku.getSkuId());
                    skuPic.setSkuPicUrl(updateSkuPicBO.getSkuPicUrl());
                    skuPic.setSupplierId(updateSkuPicBatchReqBO.getSupplierId());
                    skuPic.setCreateLoginId(updateSkuPicBatchReqBO.getUserId());
                    skuPic.setCreateTime(new Date());
                    skuPic.setUpdateLoginId(updateSkuPicBatchReqBO.getUserId());
                    skuPic.setUpdateTime(new Date());
                    skuPic.setIsDelete(Constant.IS_DELETE);
                    if (null != updateSkuPicBO.getPicOrder()) {
                        skuPic.setPicOrder(updateSkuPicBO.getPicOrder().intValue());
                    }
                    if (null != updateSkuPicBO.getIsPrimary()) {
                        skuPic.setIsPrimary(updateSkuPicBO.getIsPrimary().intValue());
                    }
                    skuPics.add(skuPic);
                }
            }
            if (!(oldSkuPics = this.skuPicMapper.selectBySkuIdAndSupplierId(oldSku.getSkuId(), updateSkuPicBatchReqBO.getSupplierId())).isEmpty()) {
                for (SkuPic oldSkuPic : oldSkuPics) {
                    skuPicIds.add(oldSkuPic.getSkuPicId());
                }
                this.skuPicMapper.deleteSkuPicBatch(skuPicIds, updateSkuPicBatchReqBO.getSupplierId());
            }
            if (!skuPics.isEmpty()) {
                this.skuPicMapper.insertSkuPicBatch(skuPics);
            }
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u66f4\u65b0\u5546\u54c1\u56fe\u7247\u670d\u52a1\u5546\u54c1\u56fe\u7247\u66f4\u65b0\u5931\u8d25:" + e);
            throw new BusinessException(null, "\u5546\u54c1\u56fe\u7247\u66f4\u65b0\u5931\u8d25");
        }
    }

    private void skuOnShelveApprove(UpdateSkuPicBatchReqBO updateSkuPicBatchReqBO, Long skuId, Sku oldSku) {
        try {
            SkuOnShelveLog skuOnShelveLog;
            ArrayList<SkuOnShelveLog> skuOnShelveLogs;
            List<SkuPrice> skuPrices = this.skuPriceMapper.selectBySkuId(skuId, updateSkuPicBatchReqBO.getSupplierId());
            BpmStartReqBO bpmStartReqBO = new BpmStartReqBO();
            bpmStartReqBO.setBusinessTitle("\u5546\u54c1\u4fe1\u606f\u66f4\u65b0\u5e76\u63d0\u4ea4\u4e0a\u67b6\u5ba1\u6838");
            bpmStartReqBO.setBusinessType("10");
            bpmStartReqBO.setBusinessId(String.valueOf(skuId));
            bpmStartReqBO.setDetailUrl("\u5546\u54c1\u4fe1\u606f\u66f4\u65b0\u4e0a\u67b6\u5ba1\u6838");
            bpmStartReqBO.setApplyerId(updateSkuPicBatchReqBO.getUserId());
            bpmStartReqBO.setStartFlag("1");
            bpmStartReqBO.setUserId(updateSkuPicBatchReqBO.getUserId());
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("supplierId", updateSkuPicBatchReqBO.getSupplierId());
            variables.put("userId", updateSkuPicBatchReqBO.getUserId());
            variables.put("skuId", skuId);
            variables.put("approveType", "10");
            if (skuPrices != null && !skuPrices.isEmpty()) {
                variables.put("agreementId", skuPrices.get(0).getAgreementId());
                variables.put("agreementSkuId", skuPrices.get(0).getAgreementSkuId());
            } else {
                variables.put("agreementId", updateSkuPicBatchReqBO.getAgreementId());
            }
            variables.put("agrLocation", Byte.valueOf(oldSku.getSkuLocation().toString()));
            variables.put("userName", updateSkuPicBatchReqBO.getUserName());
            bpmStartReqBO.setVariables(variables);
            BpmStartRspBO bpmStart = this.bpmStartBusinService.bpmStart(bpmStartReqBO);
            if ("0000".equals(bpmStart.getRespCode())) {
                skuOnShelveLogs = new ArrayList<SkuOnShelveLog>();
                skuOnShelveLog = new SkuOnShelveLog();
                skuOnShelveLog.setProcInstlId(bpmStart.getProcInstId());
                skuOnShelveLog.setSkuId(skuId);
                if (skuPrices != null && !skuPrices.isEmpty()) {
                    skuOnShelveLog.setAgreementId(skuPrices.get(0).getAgreementId());
                    skuOnShelveLog.setAgreementSkuId(skuPrices.get(0).getAgreementSkuId());
                }
            } else {
                logger.info("\u6279\u91cf\u66f4\u65b0\u5546\u54c1\u56fe\u7247\u670d\u52a1" + bpmStart.getRespDesc());
                throw new Exception(bpmStart.getRespDesc());
            }
            skuOnShelveLog.setSupplierId(updateSkuPicBatchReqBO.getSupplierId());
            skuOnShelveLog.setApproveType(SupplyConstant.APPROVE_ON_SHELF_TYPE);
            skuOnShelveLog.setApproveStatus(SupplyConstant.APPROVE_STATUS_START);
            skuOnShelveLog.setApproveResult(SupplyConstant.APPROVE_SUB_TYPE);
            skuOnShelveLog.setCreateLoginId(updateSkuPicBatchReqBO.getUserId());
            skuOnShelveLog.setCreateLoginName(updateSkuPicBatchReqBO.getUserName());
            skuOnShelveLog.setCreateTime(new Date());
            skuOnShelveLog.setIsDelete(Constant.IS_DELETE.byteValue());
            skuOnShelveLog.setSkuLocation(Byte.valueOf(oldSku.getSkuLocation().toString()));
            skuOnShelveLogs.add(skuOnShelveLog);
            this.skuOnShelveLogMapper.batchSkuOnShelveLog(skuOnShelveLogs);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u66f4\u65b0\u5546\u54c1\u56fe\u7247\u670d\u52a1\u542f\u52a8\u5de5\u4f5c\u6d41\u5931\u8d25" + e);
            throw new BusinessException(null, "\u542f\u52a8\u5de5\u4f5c\u6d41\u5931\u8d25");
        }
    }
}

