/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.ModitySkuInfoService;
import com.cgd.commodity.busi.bo.SkuInfoRep;
import com.cgd.commodity.busi.impl.QryCommodityTypeServiceImpl;
import com.cgd.commodity.dao.SkuMapper;
import com.ohaotian.plugin.base.bo.RspBusiBaseBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ModitySkuInfoServiceImpl
implements ModitySkuInfoService {
    private static final Logger logger = LoggerFactory.getLogger(QryCommodityTypeServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SkuMapper skuMapper;

    public RspBusiBaseBO updateAgrInfo(SkuInfoRep skuInfoRep) {
        if (this.isDebugEnabled) {
            logger.debug("\u5546\u54c1\u4fe1\u606f\u66f4\u65b0\u670d\u52a1\u5165\u53c2\uff1a" + skuInfoRep.toString());
        }
        if (skuInfoRep.getUserId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u53c2\u6570\u3010userId\u3011\u5fc5\u586b");
        }
        if (skuInfoRep.getSkuIds() == null || skuInfoRep.getSkuIds().size() == 0) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u53c2\u6570\u3010skuIds\u3011\u5fc5\u586b");
        }
        if (skuInfoRep.getSupplierId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u53c2\u6570\u3010supplierId\u3011\u5fc5\u586b");
        }
        RspBusiBaseBO rspBusiBaseBO = new RspBusiBaseBO();
        try {
            this.skuMapper.updateSkuStateBatchByIds(skuInfoRep.getSkuIds(), skuInfoRep.getSupplierId(), skuInfoRep.getUserId(), skuInfoRep.getSkuStatus(), skuInfoRep.getIsApprove());
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u5546\u54c1\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u5931\u8d25", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4fee\u6539\u5546\u54c1\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
        rspBusiBaseBO.setRespCode("0000");
        rspBusiBaseBO.setRespDesc("\u6210\u529f");
        return rspBusiBaseBO;
    }
}

