/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.base.file.FileProcessing;
import com.cgd.commodity.busi.QryAgrChangeDetailService;
import com.cgd.commodity.busi.bo.AgrAttach;
import com.cgd.commodity.busi.bo.agreement.BusiQryAgrChangeReqBO;
import com.cgd.commodity.busi.bo.agreement.BusiQryAgrChangeRspBO;
import com.cgd.commodity.busi.vo.agreement.AgreementChangeDetailVO;
import com.cgd.commodity.busi.vo.agreement.AgreementQueryDetailVO;
import com.cgd.commodity.busi.vo.agreement.AgreementScopeVO;
import com.cgd.commodity.dao.AgreementChangeAttachMapper;
import com.cgd.commodity.dao.AgreementChangeMapper;
import com.cgd.commodity.dao.AgreementMajorChangeMapper;
import com.cgd.commodity.dao.AgreementScopeMapper;
import com.cgd.commodity.dao.SupplierAgreementAttachMapper;
import com.cgd.commodity.dao.SupplierAgreementMapper;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class QryAgrChangeDetailServiceImpl
implements QryAgrChangeDetailService {
    private static final Logger logger = LoggerFactory.getLogger(QryAgrChangeDetailServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private AgreementChangeMapper agreementChangeMapper;
    private AgreementChangeAttachMapper agreementChangeAttachMapper;
    private SupplierAgreementMapper supplierAgreementMapper;
    private SupplierAgreementAttachMapper supplierAgreementAttachMapper;
    private AgreementScopeMapper agreementScopeMapper;
    private AgreementMajorChangeMapper agreementMajorChangeMapper;
    @Autowired
    private CacheClient cacheClient;

    public void setAgreementChangeMapper(AgreementChangeMapper agreementChangeMapper) {
        this.agreementChangeMapper = agreementChangeMapper;
    }

    public void setAgreementChangeAttachMapper(AgreementChangeAttachMapper agreementChangeAttachMapper) {
        this.agreementChangeAttachMapper = agreementChangeAttachMapper;
    }

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public void setSupplierAgreementAttachMapper(SupplierAgreementAttachMapper supplierAgreementAttachMapper) {
        this.supplierAgreementAttachMapper = supplierAgreementAttachMapper;
    }

    public void setAgreementScopeMapper(AgreementScopeMapper agreementScopeMapper) {
        this.agreementScopeMapper = agreementScopeMapper;
    }

    public void setAgreementMajorChangeMapper(AgreementMajorChangeMapper agreementMajorChangeMapper) {
        this.agreementMajorChangeMapper = agreementMajorChangeMapper;
    }

    public BusiQryAgrChangeRspBO qryAgrChangeDetail(BusiQryAgrChangeReqBO busiQryAggrChangeReqBO) {
        BusiQryAgrChangeRspBO busiQryAggrChangeRspBO = new BusiQryAgrChangeRspBO();
        if (this.isDebugEnabled) {
            logger.debug("\u589e\u52a0\u9500\u91cf\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + busiQryAggrChangeRspBO.toString());
        }
        try {
            AgreementChangeDetailVO aggrementChangeDetailVO = new AgreementChangeDetailVO();
            AgreementQueryDetailVO aggrementQueryDetailVO = new AgreementQueryDetailVO();
            aggrementChangeDetailVO = this.agreementChangeMapper.selectById(busiQryAggrChangeReqBO.getChangeId(), busiQryAggrChangeReqBO.getSupplierId());
            List<AgrAttach> agrAttachChangeDetail = this.agreementChangeAttachMapper.qryAgrAttach(busiQryAggrChangeReqBO.getAggrId(), busiQryAggrChangeReqBO.getSupplierId());
            aggrementChangeDetailVO.setAgrAttach(agrAttachChangeDetail);
            aggrementQueryDetailVO = this.supplierAgreementMapper.qryAgreementDetail(busiQryAggrChangeReqBO.getAggrId(), busiQryAggrChangeReqBO.getSupplierId());
            List<AgrAttach> agrAttachs = this.supplierAgreementAttachMapper.qryAgrContractAttach(busiQryAggrChangeReqBO.getAggrId(), busiQryAggrChangeReqBO.getSupplierId());
            for (AgrAttach agrAttach : agrAttachs) {
                agrAttach.setAttachmentAddr(this.accessoryUrlSign(agrAttach.getAttachmentAddr()));
            }
            aggrementQueryDetailVO.setAgrAttach(agrAttachs);
            List<AgrAttach> agrOtherAttachs = this.supplierAgreementAttachMapper.qryAgrOtherAttach(busiQryAggrChangeReqBO.getAggrId(), busiQryAggrChangeReqBO.getSupplierId());
            for (AgrAttach agrAttach : agrOtherAttachs) {
                agrAttach.setAttachmentAddr(this.accessoryUrlSign(agrAttach.getAttachmentAddr()));
            }
            aggrementQueryDetailVO.setAgrOtherAttach(agrOtherAttachs);
            List<AgreementScopeVO> list = this.agreementScopeMapper.selectById(busiQryAggrChangeReqBO.getAggrId(), busiQryAggrChangeReqBO.getSupplierId(), aggrementQueryDetailVO.getScopeType());
            aggrementQueryDetailVO.setAgreementScopeVOs(list);
            if (aggrementChangeDetailVO.getChangeType() == 7) {
                aggrementQueryDetailVO = this.agreementMajorChangeMapper.selectById(busiQryAggrChangeReqBO.getAggrId(), busiQryAggrChangeReqBO.getSupplierId());
            }
            busiQryAggrChangeRspBO.setAggrementChangeDetailVO(aggrementChangeDetailVO);
            busiQryAggrChangeRspBO.setAggrementQueryDetailVO(aggrementQueryDetailVO);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u534f\u8bae\u53d8\u66f4\u7533\u8bf7\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u534f\u8bae\u53d8\u66f4\u7533\u8bf7\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        busiQryAggrChangeRspBO.setRespCode("0000");
        busiQryAggrChangeRspBO.setRespDesc("\u6210\u529f");
        return busiQryAggrChangeRspBO;
    }

    private String accessoryUrlSign(String origUrl) {
        String signedUrl = (String)this.cacheClient.get(origUrl, String.class);
        if (signedUrl == null) {
            int attUrlSignExpire = 1800;
            signedUrl = FileProcessing.generatePresignedUrl((String)origUrl, (long)attUrlSignExpire);
            this.cacheClient.put(origUrl, (Object)signedUrl, attUrlSignExpire);
        }
        return signedUrl;
    }
}

