/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryOnAndOffShelfSkuService;
import com.cgd.commodity.busi.bo.supply.BusiQryOnAndOffShelfSkuReqBO;
import com.cgd.commodity.busi.bo.supply.BusiQryOnAndOffShelfSkuRspBO;
import com.cgd.commodity.dao.CatalogCommodityTypeMapper;
import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.cgd.commodity.dao.SkuInfoChangeLogMapper;
import com.cgd.commodity.dao.SkuInfoChangeMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.po.CatalogCommodityType;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class QryOnAndOffShelfSkuServiceImpl
implements QryOnAndOffShelfSkuService {
    private static final Logger logger = LoggerFactory.getLogger(QryOnAndOffShelfSkuServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private SkuInfoChangeMapper skuInfoChangeMapper;
    @Autowired
    private CatalogCommodityTypeMapper catalogCommodityTypeMapper;
    @Autowired
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;
    @Autowired
    private SkuInfoChangeLogMapper skuInfoChangeLogMapper;

    public RspPageBO<BusiQryOnAndOffShelfSkuRspBO> qryOnAndOffShelfSku(BusiQryOnAndOffShelfSkuReqBO busiQryOnAndOffShelfSkuReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u4e0a\u4e0b\u67b6\u5546\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + busiQryOnAndOffShelfSkuReqBO.toString());
        }
        RspPageBO rsp = new RspPageBO();
        try {
            int indexOf;
            String skuName = busiQryOnAndOffShelfSkuReqBO.getSkuName();
            if (skuName != null && !"".equals(skuName) && (indexOf = skuName.indexOf(92)) != -1) {
                String name = skuName.replaceAll("\\\\", "\\\\\\\\");
                busiQryOnAndOffShelfSkuReqBO.setSkuName(name);
            }
            LinkedList<Long> commodityTypeIds = new LinkedList<Long>();
            if (null != busiQryOnAndOffShelfSkuReqBO.getCatalogId()) {
                List<CatalogCommodityType> catalogs = this.catalogCommodityTypeMapper.selectByCatalogId(busiQryOnAndOffShelfSkuReqBO.getCatalogId());
                for (CatalogCommodityType catalogCommodityType : catalogs) {
                    commodityTypeIds.add(catalogCommodityType.getCommodityTypeId());
                }
            }
            ArrayList<Long> skuIds = new ArrayList();
            if (busiQryOnAndOffShelfSkuReqBO.getFlag() != null && busiQryOnAndOffShelfSkuReqBO.getFlag() == 1) {
                skuIds = this.skuInfoChangeLogMapper.checkAgrIdHasApproveLog(busiQryOnAndOffShelfSkuReqBO.getAgreementId(), busiQryOnAndOffShelfSkuReqBO.getSupplierId());
            }
            Page page = new Page(busiQryOnAndOffShelfSkuReqBO.getPageNo(), busiQryOnAndOffShelfSkuReqBO.getPageSize());
            List<Object> results = new ArrayList();
            results = this.skuMapper.selectOnAndOffShelfSku((Page<BusiQryOnAndOffShelfSkuReqBO>)page, busiQryOnAndOffShelfSkuReqBO, commodityTypeIds, skuIds);
            if (results.size() > 0) {
                LinkedList<Long> typeIds = new LinkedList<Long>();
                for (BusiQryOnAndOffShelfSkuRspBO busiQryOnAndOffShelfSkuRspBO : results) {
                    typeIds.add(busiQryOnAndOffShelfSkuRspBO.getCommodityTypeId());
                }
                List<Map<String, Object>> catalogMaps = this.commodityGuideCatalogMapper.selectCatalogNameBatByTypeIdAndLocation(typeIds);
                if (!catalogMaps.isEmpty()) {
                    for (BusiQryOnAndOffShelfSkuRspBO busiQryOnAndOffShelfSkuRspBO : results) {
                        for (Map<String, Object> map : catalogMaps) {
                            if (!map.get("commodityTypeId").equals(busiQryOnAndOffShelfSkuRspBO.getCommodityTypeId())) continue;
                            busiQryOnAndOffShelfSkuRspBO.setFirstCatalogName((String)map.get("firstCatalogName"));
                            busiQryOnAndOffShelfSkuRspBO.setSecondCatalogName((String)map.get("secondCatalogName"));
                            busiQryOnAndOffShelfSkuRspBO.setThirdCatalogName((String)map.get("thirdCatalogName"));
                        }
                        if (busiQryOnAndOffShelfSkuRspBO.getMarketPrice() == null) continue;
                        busiQryOnAndOffShelfSkuRspBO.setMarketPrice(MoneyUtils.Long2BigDecimal((Long)busiQryOnAndOffShelfSkuRspBO.getMarketPrice().longValue()));
                    }
                }
            }
            rsp.setRecordsTotal(page.getTotalCount());
            rsp.setTotal(page.getTotalPages());
            rsp.setRows(results);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4e0a\u4e0b\u67b6\u5546\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u4e0a\u4e0b\u67b6\u5546\u54c1\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
        return rsp;
    }

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setCatalogCommodityTypeMapper(CatalogCommodityTypeMapper catalogCommodityTypeMapper) {
        this.catalogCommodityTypeMapper = catalogCommodityTypeMapper;
    }

    public void setCommodityGuideCatalogMapper(CommodityGuideCatalogMapper commodityGuideCatalogMapper) {
        this.commodityGuideCatalogMapper = commodityGuideCatalogMapper;
    }
}

