/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QueryPriceFactorConfigurationHistoryService;
import com.cgd.commodity.busi.bo.EcommerceCatalogBO;
import com.cgd.commodity.busi.bo.EcommerceCatalogRspBO;
import com.cgd.commodity.busi.bo.PriceFactorConfigurationHisBO;
import com.cgd.commodity.dao.EcommerceCatalogMapper;
import com.cgd.commodity.dao.PriceFactorConfigurationHistoryMapper;
import com.cgd.commodity.po.EcommerceCatalog;
import com.cgd.commodity.po.PriceFactorConfigurationHistoryPO;
import com.ohaotian.commodity.busi.manage.market.extend.QueryCatalogNameService;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class QueryPriceFactorConfigurationHistoryServiceImpl
implements QueryPriceFactorConfigurationHistoryService {
    private static final Logger logger = LoggerFactory.getLogger(QueryPriceFactorConfigurationHistoryServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private PriceFactorConfigurationHistoryMapper priceFactorConfigurationHistoryMapper;
    @Autowired
    private EcommerceCatalogMapper ecommerceCatalogMapper;
    @Autowired
    private QueryCatalogNameService queryCatalogNameService;

    public EcommerceCatalogRspBO queryHistoryList(EcommerceCatalogBO ecommerceCatalogBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u52a0\u4ef7\u7cfb\u6570\u5386\u53f2\u7eaa\u5f55\u5165\u53c2\uff1a" + ecommerceCatalogBO.toString());
        }
        if (ecommerceCatalogBO == null || ecommerceCatalogBO.getCatalogId() == null) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5165\u53c2\u4e3a\u7a7a");
        }
        EcommerceCatalogRspBO ecommerceCatalogRspBO = new EcommerceCatalogRspBO();
        try {
            ArrayList<PriceFactorConfigurationHisBO> priceFactorConfigurationHisBOs = new ArrayList<PriceFactorConfigurationHisBO>();
            ArrayList<Long> commodityTypeIds = new ArrayList<Long>();
            EcommerceCatalog ecommerceCatalog = this.ecommerceCatalogMapper.selectByPrimaryKey(ecommerceCatalogBO.getCatalogId());
            List<PriceFactorConfigurationHistoryPO> priceFactorConfigurationHistoryPOs = this.priceFactorConfigurationHistoryMapper.qryPriceFactorConfigurations(ecommerceCatalogBO.getCatalogId());
            BeanUtils.copyProperties((Object)ecommerceCatalog, (Object)ecommerceCatalogRspBO);
            ecommerceCatalogRspBO.setAdjustTime(ecommerceCatalog.getAdjustTime());
            ecommerceCatalogRspBO.setIsAllow(ecommerceCatalog.getIsAllow());
            ecommerceCatalogRspBO.setPriceFactor(ecommerceCatalog.getPriceFactor());
            ecommerceCatalogRspBO.setSupplierName(ecommerceCatalog.getSupplierName());
            commodityTypeIds.add(ecommerceCatalog.getCommodityTypeId());
            Map<Long, String> typeName = this.queryCatalogNameService.queryMdmCatalogMapByCommodityTypeId(commodityTypeIds);
            ecommerceCatalogRspBO.setCategoryFourName(typeName.get(ecommerceCatalog.getCommodityTypeId()));
            for (PriceFactorConfigurationHistoryPO configurationHistoryPO : priceFactorConfigurationHistoryPOs) {
                PriceFactorConfigurationHisBO PriceFactorConfigurationHisBO2 = new PriceFactorConfigurationHisBO();
                BeanUtils.copyProperties((Object)configurationHistoryPO, (Object)PriceFactorConfigurationHisBO2);
                priceFactorConfigurationHisBOs.add(PriceFactorConfigurationHisBO2);
            }
            ecommerceCatalogRspBO.setPriceFactorConfigurationHisBOs(priceFactorConfigurationHisBOs);
        }
        catch (Exception e) {
            logger.error("\u52a0\u4ef7\u7cfb\u6570\u5386\u53f2\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u52a0\u4ef7\u7cfb\u6570\u5386\u53f2\u67e5\u8be2\u5931\u8d25");
        }
        return ecommerceCatalogRspBO;
    }
}

