/*
 * Decompiled with CFR 0.152.
 */
package com.gd.commodity.busi.impl;

import com.cgd.commodity.busi.bo.SkuConversionRspBO;
import com.cgd.commodity.dao.ExtSkuConversionMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.po.Sku;
import com.gd.commodity.busi.ElecSkuChangeApprTaskService;
import com.gd.commodity.busi.bo.agreement.ElecSkuChangeApprTaskReqBO;
import com.gd.commodity.busi.bo.agreement.ElecSkuChangeApprTaskRspBO;
import com.gd.commodity.dao.ElecSkuChangeApprTaskMapper;
import com.ohaotian.commodity.busi.manage.market.extend.QueryCatalogNameService;
import com.ohaotian.commodity.common.exception.BusinessException;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service(value="gdQryAgrsOfMarketApprovalService")
public class ElecSkuChangeApprTaskServiceImpl
implements ElecSkuChangeApprTaskService {
    private static final Logger logger = LoggerFactory.getLogger(ElecSkuChangeApprTaskServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private ElecSkuChangeApprTaskMapper elecSkuChangeApprTaskMapper;
    @Autowired
    private QueryCatalogNameService queryCatalogNameService;
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private ExtSkuConversionMapper extSkuConversionMapper;

    public void setElecSkuChangeApprTaskMapper(ElecSkuChangeApprTaskMapper elecSkuChangeApprTaskMapper) {
        this.elecSkuChangeApprTaskMapper = elecSkuChangeApprTaskMapper;
    }

    public void setQueryCatalogNameService(QueryCatalogNameService queryCatalogNameService) {
        this.queryCatalogNameService = queryCatalogNameService;
    }

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setExtSkuConversionMapper(ExtSkuConversionMapper extSkuConversionMapper) {
        this.extSkuConversionMapper = extSkuConversionMapper;
    }

    public RspPageBO<ElecSkuChangeApprTaskRspBO> elecSkuChangeApprTaskService(ElecSkuChangeApprTaskReqBO qryReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u6839\u636e\u5f53\u524d\u767b\u5f55\u7528\u6237\u67e5\u8be2\u5546\u54c1\u53d8\u66f4\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryReqBO.toString() + qryReqBO.getUserId());
        }
        if (qryReqBO.getSupplierId() == null) {
            logger.error("\u5546\u54c1\u53d8\u66f4\u5ba1\u6279\u670d\u52a1\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u53d8\u66f4\u5ba1\u6279\u670d\u52a1\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RspPageBO rspPageBO = new RspPageBO();
        List<Object> rspPageList = new ArrayList();
        Page page = new Page(qryReqBO.getPageNo(), qryReqBO.getPageSize());
        try {
            ArrayList<Long> skuIds = new ArrayList<Long>();
            HashMap<Long, Sku> skuMap = new HashMap<Long, Sku>();
            ArrayList<Long> catalogIdList = new ArrayList<Long>();
            HashMap<Long, SkuConversionRspBO> skuConversionRspBOMap = new HashMap<Long, SkuConversionRspBO>();
            rspPageList = this.elecSkuChangeApprTaskMapper.qryElecSkuChangeApprTaskByPage((Page<ElecSkuChangeApprTaskReqBO>)page, qryReqBO);
            if (rspPageList.size() > 0) {
                for (Object elecSkuChangeApprTaskRspBO : rspPageList) {
                    skuIds.add(elecSkuChangeApprTaskRspBO.getSkuId());
                }
                List<Sku> skus = this.skuMapper.selectBySupIdAndSkuId(qryReqBO.getSupplierId(), skuIds);
                for (Sku sku : skus) {
                    skuMap.put(sku.getSkuId(), sku);
                    catalogIdList.add(sku.getCommodityTypeId());
                }
                List<SkuConversionRspBO> skuConversionRspBOList = this.extSkuConversionMapper.qrySkuConversionByIds(skuIds, qryReqBO.getSupplierId());
                for (SkuConversionRspBO skuConversionRspBO2 : skuConversionRspBOList) {
                    skuConversionRspBOMap.put(skuConversionRspBO2.getSkuId(), skuConversionRspBO2);
                }
                Map<Long, String> map = this.queryCatalogNameService.queryMdmCatalogMapByCommodityTypeId(catalogIdList);
                SkuConversionRspBO skuConversionRspBO = null;
                Sku sku = null;
                for (ElecSkuChangeApprTaskRspBO elecSkuChangeApprTaskRspBO : rspPageList) {
                    skuConversionRspBO = (SkuConversionRspBO)skuConversionRspBOMap.get(elecSkuChangeApprTaskRspBO.getSkuId());
                    sku = (Sku)skuMap.get(elecSkuChangeApprTaskRspBO.getSkuId());
                    String str = map.get(sku.getCommodityTypeId());
                    elecSkuChangeApprTaskRspBO.setCommodityTypeName(str);
                    if (elecSkuChangeApprTaskRspBO.getTaskStatus() == 0) {
                        elecSkuChangeApprTaskRspBO.setTaskStatusName("\u5f85\u5904\u7406");
                    } else if (elecSkuChangeApprTaskRspBO.getTaskStatus() == 1) {
                        elecSkuChangeApprTaskRspBO.setTaskStatusName("\u901a\u8fc7");
                    } else if (elecSkuChangeApprTaskRspBO.getTaskStatus() == 2) {
                        elecSkuChangeApprTaskRspBO.setTaskStatusName("\u9a73\u56de");
                    }
                    if (sku != null) {
                        elecSkuChangeApprTaskRspBO.setSupplierName(sku.getSupplierName());
                        elecSkuChangeApprTaskRspBO.setOldSkuName(sku.getSkuName());
                        elecSkuChangeApprTaskRspBO.setOldTaxCode(sku.getTaxCode());
                        elecSkuChangeApprTaskRspBO.setOldMeasureName(sku.getMeasureName());
                    }
                    if (skuConversionRspBO == null) continue;
                    elecSkuChangeApprTaskRspBO.setOldSettlerate(skuConversionRspBO.getSettlerate());
                    elecSkuChangeApprTaskRspBO.setOldSettleunit(skuConversionRspBO.getSettleunit());
                    elecSkuChangeApprTaskRspBO.setOldUnit(skuConversionRspBO.getUnit());
                }
            }
            rspPageBO.setRespCode("0000");
            rspPageBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7535\u5b50\u8d85\u5e02\u5f85\u5ba1\u6838\u5546\u54c1\u5217\u8868\u51fa\u9519", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u7535\u5b50\u8d85\u5e02\u5f85\u5ba1\u6838\u5546\u54c1\u5217\u8868\u51fa\u9519");
        }
        rspPageBO.setPageNo(qryReqBO.getPageNo());
        rspPageBO.setRows(rspPageList);
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setTotal(page.getTotalPages());
        return rspPageBO;
    }
}

