/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.UpdateSkuPriceByPriceFactorService;
import com.cgd.commodity.busi.bo.SkuInfoRep;
import com.cgd.commodity.busi.impl.QueryEcommerceCatalogServiceImpl;
import com.cgd.commodity.dao.EcommerceCatalogMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SkuPriceMapper;
import com.cgd.commodity.po.EcommerceCatalog;
import com.cgd.commodity.po.Sku;
import com.cgd.commodity.po.SkuPrice;
import com.ohaotian.base.common.bo.RspBusiBaseBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UpdateSkuPriceByPriceFactorServiceImpl
implements UpdateSkuPriceByPriceFactorService {
    private static final Logger logger = LoggerFactory.getLogger(QueryEcommerceCatalogServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private EcommerceCatalogMapper ecommerceCatalogMapper;
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private SkuPriceMapper skuPriceMapper;

    public RspBusiBaseBO updateSkuPrice(SkuInfoRep skuInfoRep) {
        if (this.isDebugEnabled) {
            logger.debug("\u5b9a\u65f6\u4efb\u52a1 \u8c03\u6574\u4ef7\u683c " + skuInfoRep);
        }
        if (skuInfoRep.getSupplierId() == null) {
            logger.error("\u5b9a\u65f6\u4efb\u52a1 \u8c03\u6574\u4ef7\u683c\u5165\u53c2\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5b9a\u65f6\u4efb\u52a1 \u8c03\u6574\u4ef7\u683c\u5165\u53c2\u4e3a\u7a7a");
        }
        RspBusiBaseBO rspBusiBaseBO = new RspBusiBaseBO();
        try {
            ArrayList<Long> skuIds = new ArrayList<Long>();
            List<EcommerceCatalog> ecommerceCatalogs = this.ecommerceCatalogMapper.selectByTime(skuInfoRep.getSupplierId());
            logger.debug("\u9700\u8981\u8c03\u6574\u7684\u5546\u54c1\u7c7b\u76ee " + ecommerceCatalogs);
            for (EcommerceCatalog ecommerceCatalog : ecommerceCatalogs) {
                List<Sku> skus = this.skuMapper.selectBycommodityTypeId(ecommerceCatalog.getCommodityTypeId(), skuInfoRep.getSupplierId());
                logger.debug("\u9700\u8981\u8c03\u6574\u7684\u5546\u54c1 " + skus);
                for (Sku sku : skus) {
                    skuIds.add(sku.getSkuId());
                }
                if (skuIds == null || skuIds.size() <= 0) continue;
                List<SkuPrice> skuPrices = this.skuPriceMapper.selectBySkuIdsAndSupplierId(skuIds, skuInfoRep.getSupplierId());
                for (SkuPrice skuPrice : skuPrices) {
                    BigDecimal priceFactor = new BigDecimal(ecommerceCatalog.getPriceFactor());
                    BigDecimal divisor = new BigDecimal(100);
                    BigDecimal addFactor = new BigDecimal(1);
                    BigDecimal agreementPrice = new BigDecimal(skuPrice.getAgreementPrice());
                    BigDecimal price = agreementPrice.multiply(priceFactor.divide(divisor).add(addFactor));
                    skuPrice.setMemberPrice(price.longValue());
                    skuPrice.setSalePrice(price.longValue());
                    if (skuPrice.getMarketPrice() != null) {
                        BigDecimal marketPrice = new BigDecimal(skuPrice.getMarketPrice());
                        if (ecommerceCatalog.getIsAllow() == 0 && price.compareTo(marketPrice) == 1) {
                            skuPrice.setMemberPrice(marketPrice.longValue());
                            skuPrice.setSalePrice(marketPrice.longValue());
                        }
                    }
                    skuPrice.setUpdateTime(new Date());
                    this.skuPriceMapper.updateBySkuIdKey(skuPrice);
                }
            }
            rspBusiBaseBO.setRespCode("0000");
            rspBusiBaseBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u5b9a\u65f6\u4efb\u52a1 \u8c03\u6574\u4ef7\u683c\u5931\u8d25", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5b9a\u65f6\u4efb\u52a1 \u8c03\u6574\u4ef7\u683c\u5931\u8d25");
        }
        return rspBusiBaseBO;
    }
}

