/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.aliyun.opensearch.sdk.dependencies.org.json.JSONArray;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONException;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONObject;
import com.cgd.commodity.busi.CmprSKUDimPrcService;
import com.cgd.commodity.busi.bo.BusiCmprSKUDimPrcReqBO;
import com.cgd.commodity.busi.bo.BusiCmprSKUDimPrcRspBO;
import com.cgd.commodity.busi.bo.BusiCmprSKUDimPrcRspInfo;
import com.cgd.commodity.constant.Constant;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.es.builder.search.SearchBuilder;
import com.ohaotian.plugin.es.builder.search.SearchRequestBuilder;
import com.ohaotian.plugin.es.builder.search.SearchRequestBuilderAdapter;
import com.ohaotian.plugin.es.builder.search.filter.BooleanFilterCondition;
import com.ohaotian.plugin.es.builder.search.filter.FilterCondition;
import com.ohaotian.plugin.es.builder.search.filter.MatchFilterCondition;
import com.ohaotian.plugin.es.builder.search.query.BooleanQueryCondition;
import com.ohaotian.plugin.es.builder.search.query.MatchQueryCondition;
import com.ohaotian.plugin.es.builder.search.query.QueryCondition;
import com.ohaotian.plugin.es.builder.search.result.Result;
import com.ohaotian.plugin.es.builder.search.sort.SearchSortMode;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CmprSKUDimPrcServiceImpl
implements CmprSKUDimPrcService {
    private static final Log log = LogFactory.getLog(CmprSKUDimPrcServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private SearchRequestBuilderAdapter searchRequestBuilderAdapter;
    private Properties prop;

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    public BusiCmprSKUDimPrcRspBO cmprSKUDimPrcsPrc(BusiCmprSKUDimPrcReqBO busiCmprSKUDimPrcReqBO) {
        String[] temps;
        BusiCmprSKUDimPrcRspBO bo = new BusiCmprSKUDimPrcRspBO();
        if (this.isDebugEnabled) {
            log.debug((Object)("\u6a21\u7cca\u6bd4\u4ef7\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + busiCmprSKUDimPrcReqBO.toString()));
        }
        if (null == busiCmprSKUDimPrcReqBO.getSkuId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6a21\u7cca\u6bd4\u4ef7\u4e1a\u52a1\u670d\u52a1\u5355\u54c1ID[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiCmprSKUDimPrcReqBO.getCommodityTypeId() || "".equals(busiCmprSKUDimPrcReqBO.getCommodityTypeId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6a21\u7cca\u6bd4\u4ef7\u4e1a\u52a1\u670d\u52a1\u5546\u54c1\u7c7b\u578bid[commodityTypeId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (busiCmprSKUDimPrcReqBO.getUserId() != null) {
            bo.setIsLogin(Boolean.valueOf(true));
        } else {
            bo.setIsLogin(Boolean.valueOf(false));
        }
        ArrayList<BusiCmprSKUDimPrcRspInfo> busiCmprSKUDimPrcRspInfos = new ArrayList<BusiCmprSKUDimPrcRspInfo>();
        Long skuId = busiCmprSKUDimPrcReqBO.getSkuId();
        Long commodityTypeId = busiCmprSKUDimPrcReqBO.getCommodityTypeId();
        SearchBuilder searchBuilder = SearchBuilder.newBuilder((SearchRequestBuilder)this.searchRequestBuilderAdapter.requestBuilder());
        searchBuilder.setIndexName(String.valueOf(this.prop.getProperty("os.appName")));
        searchBuilder.fetchBuilder().addCol("sku_id").addCol("ext_sku_id").addCol("sku_name").addCol("supplier_name").addCol("market_price").addCol("agreement_price").addCol("properties").addCol("type_id").addCol("supplier_id").addCol("member_price").addCol("sale_price").addCol("picture_url").addCol("sold_number").addCol("on_shelve_time");
        BooleanQueryCondition booleanQueryCondition = new BooleanQueryCondition();
        MatchQueryCondition match_1 = new MatchQueryCondition();
        match_1.setColumnName("id");
        match_1.setValue("'" + skuId + "'");
        booleanQueryCondition.must().add(match_1);
        MatchQueryCondition match_3 = new MatchQueryCondition();
        match_3.setColumnName("sku_status");
        match_3.setValue("'" + Constant.SKU_STATUS_SHELVED + "'");
        booleanQueryCondition.must().add(match_3);
        searchBuilder.queryBuilder().setCondition((QueryCondition)booleanQueryCondition);
        Result result = searchBuilder.build();
        JSONArray skuInfoResultJson = result.getItems();
        if (skuInfoResultJson.length() <= 0) {
            throw new BusinessException("0000", "\u6a21\u7cca\u6bd4\u4ef7\u4e1a\u52a1\u670d\u52a1:[skuId]\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        JSONObject obj = skuInfoResultJson.getJSONObject(0);
        String properties = obj.get("properties").toString();
        log.debug((Object)("properties\uff1a" + properties.toString()));
        BooleanFilterCondition filter = new BooleanFilterCondition();
        for (String temp : temps = properties.split("\t")) {
            String[] mapTemps = temp.split("\\*~~");
            if (mapTemps.length < 2 || "".equals(mapTemps[0]) || null == mapTemps[0]) continue;
            MatchFilterCondition match_0 = new MatchFilterCondition();
            match_0.setColumnName("properties");
            match_0.setValue((Object)("\"" + mapTemps[0] + "*~~" + mapTemps[1] + "\""));
            filter.must().add(match_0);
        }
        int size = filter.must().size();
        log.info((Object)("\u5c5e\u6027\u5927\u5c0f\uff1asize=" + size));
        if (size == 0) {
            bo.setBusiCmprSKUDimPrcRspInfos(busiCmprSKUDimPrcRspInfos);
            return bo;
        }
        searchBuilder.filterBuilder().setFilterCondition((FilterCondition)filter);
        BooleanQueryCondition booleanQueryCondition2 = new BooleanQueryCondition();
        MatchQueryCondition match_2 = new MatchQueryCondition();
        match_2.setColumnName("type_id");
        match_2.setValue("'" + commodityTypeId + "'");
        booleanQueryCondition2.must().add(match_2);
        MatchQueryCondition match_4 = new MatchQueryCondition();
        match_4.setColumnName("sku_status");
        match_4.setValue("'" + Constant.SKU_STATUS_SHELVED + "'");
        booleanQueryCondition2.must().add(match_4);
        searchBuilder.queryBuilder().setCondition((QueryCondition)booleanQueryCondition2);
        searchBuilder.sortBuilder().addCol("sale_price", SearchSortMode.ASC);
        searchBuilder.sortBuilder().addCol("on_shelve_time", SearchSortMode.DESC);
        searchBuilder.sortBuilder().addCol("sold_number", SearchSortMode.DESC);
        searchBuilder.setSize(Integer.parseInt(this.prop.getProperty("os.total_count")));
        result = searchBuilder.build();
        skuInfoResultJson = result.getItems();
        for (int i = 0; i < skuInfoResultJson.length(); ++i) {
            obj = skuInfoResultJson.getJSONObject(i);
            Long currSkuId = obj.getLong("sku_id");
            if (currSkuId.longValue() == skuId.longValue()) continue;
            BusiCmprSKUDimPrcRspInfo busiCmprSKUDimPrcRspInfo = new BusiCmprSKUDimPrcRspInfo();
            busiCmprSKUDimPrcRspInfo.setSkuId(currSkuId);
            busiCmprSKUDimPrcRspInfo.setExtSkuId(obj.getString("ext_sku_id"));
            busiCmprSKUDimPrcRspInfo.setSkuName(obj.getString("sku_name"));
            busiCmprSKUDimPrcRspInfo.setSupplierId(Long.valueOf(obj.getLong("supplier_id")));
            busiCmprSKUDimPrcRspInfo.setSupplierName(obj.getString("supplier_name"));
            try {
                if (obj.get("market_price") != null) {
                    busiCmprSKUDimPrcRspInfo.setMarketPrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(obj.get("market_price")))));
                }
                if (obj.get("agreement_price") != null) {
                    busiCmprSKUDimPrcRspInfo.setAgreementPrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(obj.get("agreement_price")))));
                }
                if (obj.get("member_price") != null) {
                    busiCmprSKUDimPrcRspInfo.setMemberPrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(obj.get("member_price")))));
                }
                if (obj.get("sale_price") != null) {
                    busiCmprSKUDimPrcRspInfo.setSalePrice(MoneyUtils.Long2BigDecimal((Long)Long.parseLong(String.valueOf(obj.get("sale_price")))));
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            busiCmprSKUDimPrcRspInfo.setPriPicAddr(obj.getString("picture_url"));
            busiCmprSKUDimPrcRspInfo.setSoldNumber(new BigDecimal(obj.getDouble("sold_number")));
            if (obj.getLong("on_shelve_time") != 0L) {
                busiCmprSKUDimPrcRspInfo.setOnShelveTime(new Date(obj.getLong("on_shelve_time")));
            }
            busiCmprSKUDimPrcRspInfos.add(busiCmprSKUDimPrcRspInfo);
        }
        bo.setBusiCmprSKUDimPrcRspInfos(busiCmprSKUDimPrcRspInfos);
        return bo;
    }
}

