/*
 * Decompiled with CFR 0.152.
 */
package com.gd.commodity.busi.impl;

import com.gd.commodity.busi.DelSupplierAgreementByIdService;
import com.gd.commodity.dao.AgreementScopeMapper;
import com.gd.commodity.dao.SupplierAgreementAttachMapper;
import com.gd.commodity.dao.SupplierAgreementMapper;
import com.gd.commodity.dao.SupplierAgreementSkuMapper;
import com.ohaotian.plugin.base.bo.RspBusiBaseBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DelSupplierAgreementByIdServiceImpl
implements DelSupplierAgreementByIdService {
    private static final Logger logger = LoggerFactory.getLogger(DelSupplierAgreementByIdServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SupplierAgreementMapper supplierAgreementMapper;
    @Autowired
    private SupplierAgreementSkuMapper supplierAgreementSkuMapper;
    @Autowired
    private SupplierAgreementAttachMapper supplierAgreementAttachMapper;
    @Autowired
    private AgreementScopeMapper agreementScopeMapper;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public RspBusiBaseBO delSupplierAgreement(Long agrId, Long supplierId) {
        RspBusiBaseBO rspBusiBaseBO = new RspBusiBaseBO();
        if (this.isDebugEnabled) {
            logger.debug("\u4fee\u6539\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + agrId + supplierId);
        }
        if (agrId == null) {
            logger.error("agrId\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_DAO_ERROR", "agrId\u4e3a\u7a7a");
        }
        if (supplierId == null) {
            logger.error("supplierId\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_DAO_ERROR", "supplierId\u4e3a\u7a7a");
        }
        try {
            this.supplierAgreementMapper.deleteByPrimaryKey(agrId, supplierId);
            this.supplierAgreementSkuMapper.deleteByAgrid(agrId, supplierId);
            this.supplierAgreementAttachMapper.deleteByAgrId(agrId, supplierId);
            this.agreementScopeMapper.deleteByAgrId(agrId, supplierId);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u534f\u8bae\u5931\u8d25", (Throwable)e);
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u5220\u9664\u534f\u8bae\u5931\u8d25");
        }
        rspBusiBaseBO.setRespCode("0000");
        rspBusiBaseBO.setRespDesc("\u6210\u529f");
        return rspBusiBaseBO;
    }
}

