/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.CheckPurchasableService;
import com.cgd.commodity.busi.QryArgSkuBySkuIdService;
import com.cgd.commodity.busi.bo.CheckPurchasableReqBO;
import com.cgd.commodity.busi.bo.CheckPurchasableRspBO;
import com.cgd.commodity.busi.bo.QryArgSkuBySkuIdRspBO;
import com.cgd.commodity.busi.bo.salearea.QryArgSkuBySkuIdReqBO;
import com.cgd.commodity.busi.vo.QryArgSkuBySkuIdVO;
import com.cgd.commodity.busi.vo.QryArgSkuVO;
import com.cgd.commodity.dao.CommodityMeasureMapper;
import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.dao.SkuPriceMapper;
import com.cgd.commodity.dao.SupplierAgreementMapper;
import com.cgd.commodity.po.CommodityMeasure;
import com.cgd.commodity.po.SupplierAgreement;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class QryArgSkuBySkuIdServiceImpl
implements QryArgSkuBySkuIdService {
    private static final Logger logger = LoggerFactory.getLogger(QryArgSkuBySkuIdServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;
    private SkuPriceMapper skuPriceMapper;
    private SupplierAgreementMapper supplierAgreementMapper;
    private CheckPurchasableService checkPurchasableService;
    @Autowired
    private CommodityMeasureMapper commodityMeasureMapper;

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setSkuPriceMapper(SkuPriceMapper skuPriceMapper) {
        this.skuPriceMapper = skuPriceMapper;
    }

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public void setCheckPurchasableService(CheckPurchasableService checkPurchasableService) {
        this.checkPurchasableService = checkPurchasableService;
    }

    public QryArgSkuBySkuIdRspBO qryArgSkuBySkuId(QryArgSkuBySkuIdReqBO qryArgSkuBySkuIdReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryArgSkuBySkuIdReqBO.toString());
        }
        if (null == qryArgSkuBySkuIdReqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u4f9b\u8d27\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == qryArgSkuBySkuIdReqBO.getSkuId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u4e1a\u52a1\u670d\u52a1SkuId[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == qryArgSkuBySkuIdReqBO.getUserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u4e1a\u52a1\u670d\u52a1UserId[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            List<Long> agreementIds;
            QryArgSkuBySkuIdRspBO qryArgSkuBySkuIdRspBO = new QryArgSkuBySkuIdRspBO();
            if (null != qryArgSkuBySkuIdReqBO.getUserId()) {
                qryArgSkuBySkuIdRspBO.setIsLogin(Boolean.valueOf(true));
            } else {
                qryArgSkuBySkuIdRspBO.setIsLogin(Boolean.valueOf(false));
            }
            CheckPurchasableReqBO checkPurchasableReqBO = new CheckPurchasableReqBO();
            checkPurchasableReqBO.setUserId(qryArgSkuBySkuIdReqBO.getUserId());
            checkPurchasableReqBO.setSkuId(qryArgSkuBySkuIdReqBO.getSkuId());
            checkPurchasableReqBO.setSupplierId(qryArgSkuBySkuIdReqBO.getSupplierId());
            CheckPurchasableRspBO checkPurchasable = this.checkPurchasable(checkPurchasableReqBO);
            if (checkPurchasable != null && checkPurchasable.getPurchasableFlag() != null && checkPurchasable.getPurchasableFlag() == 1 && (agreementIds = this.skuPriceMapper.selectBySkuIdAndsupplierId(qryArgSkuBySkuIdReqBO.getSkuId(), qryArgSkuBySkuIdReqBO.getSupplierId())) != null && agreementIds.size() > 0) {
                Long agreementId = agreementIds.get(0);
                SupplierAgreement supplierAgreement = this.supplierAgreementMapper.selectByPrimaryKey(agreementId);
                if (supplierAgreement != null) {
                    qryArgSkuBySkuIdRspBO.setPlaAgreementCode(supplierAgreement.getPlaAgreementCode());
                    qryArgSkuBySkuIdRspBO.setAgreementName(supplierAgreement.getAgreementName());
                }
                Page page = new Page(qryArgSkuBySkuIdReqBO.getPageNo(), qryArgSkuBySkuIdReqBO.getPageSize());
                List<QryArgSkuBySkuIdVO> qryArgSkuBySkuIdVOs = this.skuMapper.qryArgSkuBySkuId((Page<QryArgSkuBySkuIdReqBO>)page, agreementId, qryArgSkuBySkuIdReqBO.getSupplierId(), qryArgSkuBySkuIdReqBO.getSkuId());
                ArrayList<QryArgSkuVO> qryArgSkuVOs = new ArrayList<QryArgSkuVO>();
                if (qryArgSkuBySkuIdVOs != null && qryArgSkuBySkuIdVOs.size() > 0) {
                    qryArgSkuBySkuIdRspBO.setRespCode("0000");
                    qryArgSkuBySkuIdRspBO.setRespDesc("\u6210\u529f");
                    HashMap<String, CommodityMeasure> commodityMeasureMap = new HashMap<String, CommodityMeasure>();
                    ArrayList<String> measureNameList = new ArrayList<String>();
                    for (QryArgSkuBySkuIdVO qryArgSkuBySkuIdVO : qryArgSkuBySkuIdVOs) {
                        if (measureNameList.contains(qryArgSkuBySkuIdVO.getMeasureName())) continue;
                        measureNameList.add(qryArgSkuBySkuIdVO.getMeasureName());
                    }
                    if (measureNameList.size() > 0) {
                        List<CommodityMeasure> commodityMeasures = this.commodityMeasureMapper.selectByMeasureNames(measureNameList);
                        for (CommodityMeasure commodityMeasure : commodityMeasures) {
                            commodityMeasureMap.put(commodityMeasure.getMeasureName(), commodityMeasure);
                        }
                    }
                    for (QryArgSkuBySkuIdVO qryArgSkuBySkuIdVO : qryArgSkuBySkuIdVOs) {
                        QryArgSkuVO qryArgSkuVO = new QryArgSkuVO();
                        if (qryArgSkuBySkuIdVO.getSalePrice() != null) {
                            Long salePrice = qryArgSkuBySkuIdVO.getSalePrice();
                            BigDecimal sp = MoneyUtils.Long2BigDecimal((Long)salePrice);
                            qryArgSkuVO.setSalePrice(sp);
                        }
                        if (qryArgSkuBySkuIdVO.getSalePriceSum() != null) {
                            Long salePriceSum = qryArgSkuBySkuIdVO.getSalePriceSum();
                            BigDecimal spm = MoneyUtils.Long2BigDecimal((Long)salePriceSum);
                            qryArgSkuVO.setSalePriceSum(spm);
                        }
                        qryArgSkuVO.setBrandName(qryArgSkuBySkuIdVO.getBrandName());
                        qryArgSkuVO.setFigure(qryArgSkuBySkuIdVO.getFigure());
                        qryArgSkuVO.setManufacturer(qryArgSkuBySkuIdVO.getManufacturer());
                        qryArgSkuVO.setMaterialId(qryArgSkuBySkuIdVO.getMaterialId());
                        qryArgSkuVO.setMeasureName(qryArgSkuBySkuIdVO.getMeasureName());
                        qryArgSkuVO.setModel(qryArgSkuBySkuIdVO.getModel());
                        qryArgSkuVO.setSkuId(qryArgSkuBySkuIdVO.getSkuId());
                        qryArgSkuVO.setSkuName(qryArgSkuBySkuIdVO.getSkuName());
                        qryArgSkuVO.setSpec(qryArgSkuBySkuIdVO.getSpec());
                        qryArgSkuVO.setSaleunit(qryArgSkuBySkuIdVO.getSaleunit());
                        qryArgSkuVO.setSettlerate(qryArgSkuBySkuIdVO.getSettlerate());
                        qryArgSkuVO.setSettleunit(qryArgSkuBySkuIdVO.getSettleunit());
                        qryArgSkuVO.setWarenum(qryArgSkuBySkuIdVO.getWarenum());
                        qryArgSkuVO.setIsShowSpec(qryArgSkuBySkuIdVO.getIsShowSpec());
                        if (commodityMeasureMap.size() > 0 && commodityMeasureMap.get(qryArgSkuBySkuIdVO.getMeasureName()) != null) {
                            qryArgSkuVO.setMeasureType(((CommodityMeasure)commodityMeasureMap.get(qryArgSkuBySkuIdVO.getMeasureName())).getMeasureType());
                        }
                        qryArgSkuVOs.add(qryArgSkuVO);
                    }
                    qryArgSkuBySkuIdRspBO.setQryArgSkuVOs(qryArgSkuVOs);
                    qryArgSkuBySkuIdRspBO.setPageNo(page.getPageNo());
                    qryArgSkuBySkuIdRspBO.setRecordsTotal(page.getTotalCount());
                    qryArgSkuBySkuIdRspBO.setTotal(page.getTotalPages());
                }
            }
            return qryArgSkuBySkuIdRspBO;
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff1a" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)e).getMsgCode();
                throw new BusinessException(resultCode, e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u534f\u8bae\u67e5\u8be2\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private CheckPurchasableRspBO checkPurchasable(CheckPurchasableReqBO checkPurchasableReqBO) {
        try {
            CheckPurchasableRspBO checkPurchasableRspBO = this.checkPurchasableService.checkPurchasable(checkPurchasableReqBO);
            return checkPurchasableRspBO;
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5546\u54c1\u662f\u5426\u53ef\u8d2d\u4e70\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u8c03\u7528\u5546\u54c1\u662f\u5426\u53ef\u8d2d\u4e70\u670d\u52a1\u5931\u8d25");
        }
    }
}

