/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.UpdateEcommerceCatalogService;
import com.cgd.commodity.busi.bo.EcommerceCatalogBO;
import com.cgd.commodity.dao.EcommerceCatalogMapper;
import com.cgd.commodity.dao.PriceFactorConfigurationHistoryMapper;
import com.cgd.commodity.po.EcommerceCatalog;
import com.cgd.commodity.po.PriceFactorConfigurationHistoryPO;
import com.cgd.manage.intfce.user.bo.UserRspBo;
import com.cgd.user.userInfo.busi.QryUserInfoByIdBusinService;
import com.cgd.user.userInfo.busi.bo.QryUserInfoByIdReqBO;
import com.ohaotian.base.common.bo.RspBusiBaseBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UpdateEcommerceCatalogServiceImpl
implements UpdateEcommerceCatalogService {
    private static final Logger logger = LoggerFactory.getLogger(UpdateEcommerceCatalogServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private PriceFactorConfigurationHistoryMapper priceFactorConfigurationHistoryMapper;
    @Autowired
    private EcommerceCatalogMapper ecommerceCatalogMapper;
    @Autowired
    private QryUserInfoByIdBusinService qryUserInfoByIdBusinService;

    public RspBusiBaseBO updateEcommerceCatalogs(EcommerceCatalogBO ecommerceCatalogBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u8bbe\u7f6e\u52a0\u4ef7\u6bd4\u7387\u4e1a\u52a1\u670d\u52a1\uff08\u6279\u91cf\uff09\u5165\u53c2\uff1a" + ecommerceCatalogBO.toString() + ecommerceCatalogBO.getUserId());
        }
        if (ecommerceCatalogBO.getCatalogIds() == null || ecommerceCatalogBO.getCatalogIds().size() == 0) {
            logger.error("UpdateEcommerceCatalogServiceImpl===>\u8bbe\u7f6e\u52a0\u4ef7\u6bd4\u7387\u4e1a\u52a1\u670d\u52a1\uff08\u6279\u91cf\uff09\u4e1a\u52a1\u670d\u52a1\u5165\u53c2CatalogIds\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8bbe\u7f6e\u52a0\u4ef7\u6bd4\u7387\u4e1a\u52a1\u670d\u52a1\uff08\u6279\u91cf\uff09\u4e1a\u52a1\u670d\u52a1\u5165\u53c2CatalogIds\u4e3a\u7a7a");
        }
        RspBusiBaseBO rspBusiBaseBO = new RspBusiBaseBO();
        try {
            HashMap<Long, EcommerceCatalog> ecommerceCatalogMap = new HashMap<Long, EcommerceCatalog>();
            ArrayList<PriceFactorConfigurationHistoryPO> priceFactorConfigurationHistoryPOs = new ArrayList<PriceFactorConfigurationHistoryPO>();
            List<EcommerceCatalog> ecommerceCatalogs = this.ecommerceCatalogMapper.selectEcommerceCatalogByIds(ecommerceCatalogBO.getCatalogIds());
            for (EcommerceCatalog ecommerceCatalog : ecommerceCatalogs) {
                ecommerceCatalogMap.put(ecommerceCatalog.getCatalogId(), ecommerceCatalog);
            }
            EcommerceCatalog ecommerceCatalog = new EcommerceCatalog();
            ecommerceCatalog.setIsAllow(ecommerceCatalogBO.getIsAllow());
            ecommerceCatalog.setPriceFactor(ecommerceCatalogBO.getPriceFactor());
            ecommerceCatalog.setAdjustTime(new Date());
            this.ecommerceCatalogMapper.updateByIdsSelective(ecommerceCatalog, ecommerceCatalogBO.getCatalogIds());
            QryUserInfoByIdReqBO qryUserInfoByIdReqBO = new QryUserInfoByIdReqBO();
            qryUserInfoByIdReqBO.setUserIdParam(ecommerceCatalogBO.getUserId());
            UserRspBo userRspBo = this.qryUserInfoByIdBusinService.qryUserInfoById(qryUserInfoByIdReqBO);
            logger.debug("userRspBo===>" + userRspBo);
            for (Long catalogId : ecommerceCatalogBO.getCatalogIds()) {
                PriceFactorConfigurationHistoryPO priceFactorConfigurationHistoryPO = new PriceFactorConfigurationHistoryPO();
                priceFactorConfigurationHistoryPO.setCatalogId(catalogId);
                priceFactorConfigurationHistoryPO.setCreateTime(new Date());
                priceFactorConfigurationHistoryPO.setCreateUserId(userRspBo.getLoginname());
                priceFactorConfigurationHistoryPO.setCreateUserName(userRspBo.getName());
                if (ecommerceCatalogMap.get(catalogId) != null) {
                    priceFactorConfigurationHistoryPO.setEffectTime(((EcommerceCatalog)ecommerceCatalogMap.get(catalogId)).getAdjustTime());
                }
                priceFactorConfigurationHistoryPO.setEfficacyTime(new Date());
                priceFactorConfigurationHistoryPO.setIsAllow(ecommerceCatalogBO.getIsAllow());
                priceFactorConfigurationHistoryPO.setPriceFactor(((EcommerceCatalog)ecommerceCatalogMap.get(catalogId)).getPriceFactor());
                priceFactorConfigurationHistoryPOs.add(priceFactorConfigurationHistoryPO);
            }
            this.priceFactorConfigurationHistoryMapper.insertBatchSelective(priceFactorConfigurationHistoryPOs);
            rspBusiBaseBO.setRespCode("0000");
            rspBusiBaseBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("UpdateEcommerceCatalogServiceImpl===>\u8bbe\u7f6e\u52a0\u4ef7\u6bd4\u7387\u4e1a\u52a1\u670d\u52a1\uff08\u6279\u91cf\uff09\u4e1a\u52a1\u670d\u52a1\u5931\u8d25", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8bbe\u7f6e\u52a0\u4ef7\u6bd4\u7387\u4e1a\u52a1\u670d\u52a1\uff08\u6279\u91cf\uff09\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
        return rspBusiBaseBO;
    }
}

