/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.aop;

import com.alibaba.dubbo.rpc.RpcContext;
import com.ohaotian.plugin.base.annotation.BusiRequest;
import com.ohaotian.plugin.base.bo.RspBusiBaseBO;
import com.ohaotian.plugin.base.bo.RspInfoBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.cache.CacheExecuterService;
import com.ohaotian.plugin.cache.CacheService;
import com.taobao.eagleeye.EagleEye;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.Ordered;

public class BusiAopAdvisor
implements Ordered {
    private static final Log log = LogFactory.getLog(BusiAopAdvisor.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private CacheExecuterService<Map<String, String>> exceptionInfoService;
    private CacheService cacheService;

    public int getOrder() {
        return 0;
    }

    public Object throwAopTreat(ProceedingJoinPoint pjp) throws Throwable {
        RpcContext rpcContext = RpcContext.getContext();
        Map hiddenParm = rpcContext.getAttachments();
        String traceId = "";
        if (hiddenParm.containsKey("traceId")) {
            traceId = (String)hiddenParm.get("traceId");
        } else {
            traceId = EagleEye.getTraceId();
            hiddenParm.put("traceId", traceId);
        }
        MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
        Method method = methodSignature.getMethod();
        Class<?> rspClass = method.getReturnType();
        Object rspObj = null;
        try {
            rspObj = pjp.proceed();
            this.putCodeToRsp(rspObj, "0000", "\u6210\u529f");
        }
        catch (BusinessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            rspObj = rspClass.newInstance();
            String msgCode = e.getMsgCode();
            String desc = e.getMessage();
            if (msgCode != null && !"".equals(msgCode)) {
                Map innerCodeMap = this.cacheService.getInnerCodeByKey(this.exceptionInfoService, new String[]{msgCode});
                String string = msgCode = innerCodeMap.get("innerCode") == null ? e.getMsgCode() : (String)innerCodeMap.get("innerCode");
            }
            if (msgCode == null || "".equals(msgCode)) {
                if (e.getCause() instanceof BusinessException) {
                    msgCode = e.getMsgCode();
                }
                if (msgCode == null || "".equals(msgCode)) {
                    msgCode = "8888";
                }
            }
            this.putCodeToRsp(rspObj, msgCode, desc);
        }
        catch (Throwable e) {
            log.error((Object)"\u7cfb\u7edf\u5f02\u5e38  ", e);
            rspObj = rspClass.newInstance();
            this.putCodeToRsp(rspObj, "8888", "\u5931\u8d25");
        }
        return rspObj;
    }

    private void putCodeToRsp(Object object, String code, String desc) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        this.putCodeToRsp(object, code, desc, false);
    }

    private void putCodeToRsp(Object object, String code, String desc, boolean fource) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field;
        if (object instanceof RspBusiBaseBO) {
            field = RspBusiBaseBO.class.getDeclaredField("respCode");
            field.setAccessible(true);
            if (!fource && field.get(object) == null) {
                field.set(object, code);
                field = RspBusiBaseBO.class.getDeclaredField("respDesc");
                field.setAccessible(true);
                field.set(object, desc);
            } else if (fource && field.get(object) == null) {
                field.set(object, code);
                field = RspBusiBaseBO.class.getDeclaredField("respDesc");
                field.setAccessible(true);
                field.set(object, desc);
            }
        }
        if (object instanceof RspInfoBO) {
            field = RspInfoBO.class.getDeclaredField("respCode");
            field.setAccessible(true);
            if (!fource && field.get(object) == null) {
                field.set(object, code);
                field = RspInfoBO.class.getDeclaredField("respDesc");
                field.setAccessible(true);
                field.set(object, desc);
            } else if (fource && field.get(object) == null) {
                field.set(object, code);
                field = RspInfoBO.class.getDeclaredField("respDesc");
                field.setAccessible(true);
                field.set(object, desc);
            }
        }
    }

    public Object bulidRspObj(BusiRequest br, Class<?> resClass) throws Exception {
        Object rspObj = null;
        String key = br.key();
        String desc = br.desc();
        Map innerCodeMap = this.cacheService.getInnerCodeByKey(this.exceptionInfoService, new String[]{key});
        key = innerCodeMap.get("innerCode") == null ? key : (String)innerCodeMap.get("innerCode");
        desc = innerCodeMap.get("innerCodeDesc") == null || "".equals(innerCodeMap.get("innerCodeDesc")) ? desc : (String)innerCodeMap.get("innerCodeDesc");
        rspObj = resClass.newInstance();
        this.putCodeToRsp(rspObj, key, desc);
        return rspObj;
    }

    public void put(String key, String value, Map<String, String> hiddenParm) {
        if (hiddenParm.get(key) == null) {
            hiddenParm.put(key, value);
        }
    }

    public void setExceptionInfoService(CacheExecuterService<Map<String, String>> exceptionInfoService) {
        this.exceptionInfoService = exceptionInfoService;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }
}

