/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QrySkuApproveLogListService;
import com.cgd.commodity.busi.bo.supply.BusiQrySkuApproveLogListReqBO;
import com.cgd.commodity.busi.bo.supply.BusiQrySkuApproveLogListRspBO;
import com.cgd.commodity.dao.SkuChangeInfoMapper;
import com.cgd.commodity.dao.SkuOnShelveLogMapper;
import com.cgd.commodity.dao.SkuPicChangeMapper;
import com.cgd.commodity.po.SkuInfoChange;
import com.cgd.commodity.po.SkuPicChange;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class QrySkuApproveLogListServiceImpl
implements QrySkuApproveLogListService {
    private static final Logger logger = LoggerFactory.getLogger(QrySkuApproveLogListServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuOnShelveLogMapper skuOnShelveLogMapper;
    @Autowired
    private SkuChangeInfoMapper skuChangeInfoMapper;
    @Autowired
    private SkuPicChangeMapper skuPicChangeMapper;

    public RspPageBO<BusiQrySkuApproveLogListRspBO> qrySkuApproveLogList(BusiQrySkuApproveLogListReqBO busiQrySkuApproveLogListReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5546\u54c1\u5ba1\u6279\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5b9e\u73b0\u5165\u53c2\uff1a" + busiQrySkuApproveLogListReqBO.toString());
        }
        RspPageBO rsp = new RspPageBO();
        try {
            Long supplierId = busiQrySkuApproveLogListReqBO.getSupplierId();
            List<Object> list = new ArrayList();
            Page page = new Page(busiQrySkuApproveLogListReqBO.getPageNo(), busiQrySkuApproveLogListReqBO.getPageSize());
            list = this.skuOnShelveLogMapper.selectBySkuApproveLog((Page<Map<String, Object>>)page, busiQrySkuApproveLogListReqBO, supplierId);
            ArrayList<Long> skuIdList = new ArrayList<Long>();
            for (BusiQrySkuApproveLogListRspBO busiQrySkuApproveLogListRspBO : list) {
                skuIdList.add(busiQrySkuApproveLogListRspBO.getSkuId());
            }
            List<SkuInfoChange> skuChangeInfoList = this.skuChangeInfoMapper.queryAllChangeInfo(busiQrySkuApproveLogListReqBO.getAgreementId(), supplierId, skuIdList);
            List<SkuPicChange> list2 = this.skuPicChangeMapper.queryBySupplierId(supplierId, skuIdList);
            list = this.replaceSkuChangeInfo(list, skuChangeInfoList, list2);
            rsp.setRecordsTotal(page.getTotalCount());
            rsp.setTotal(page.getTotalPages());
            rsp.setRows(list);
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u5ba1\u6279\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u5ba1\u6279\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return rsp;
    }

    private List<BusiQrySkuApproveLogListRspBO> replaceSkuChangeInfo(List<BusiQrySkuApproveLogListRspBO> list, List<SkuInfoChange> skuChangeInfoList, List<SkuPicChange> skuPicChangeList) {
        HashMap<Long, SkuInfoChange> map = new HashMap<Long, SkuInfoChange>();
        if (skuChangeInfoList != null && skuChangeInfoList.size() > 0) {
            for (SkuInfoChange skuInfoChange : skuChangeInfoList) {
                map.put(skuInfoChange.getSkuId(), skuInfoChange);
            }
        }
        HashMap<Long, SkuPicChange> picMap = new HashMap<Long, SkuPicChange>();
        if (skuPicChangeList != null && skuPicChangeList.size() > 0) {
            for (SkuPicChange skuPicChange : skuPicChangeList) {
                picMap.put(skuPicChange.getSkuId(), skuPicChange);
            }
        }
        for (BusiQrySkuApproveLogListRspBO busiQrySkuApproveLogListRspBO : list) {
            SkuInfoChange skuInfoChange = (SkuInfoChange)map.get(busiQrySkuApproveLogListRspBO.getSkuId());
            if (skuInfoChange == null) continue;
            busiQrySkuApproveLogListRspBO.setSkuName(skuInfoChange.getSkuName());
            busiQrySkuApproveLogListRspBO.setInfoChangeId(skuInfoChange.getChangeId());
        }
        return list;
    }

    public void setSkuOnShelveLogMapper(SkuOnShelveLogMapper skuOnShelveLogMapper) {
        this.skuOnShelveLogMapper = skuOnShelveLogMapper;
    }
}

