/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.AddCommodityCatalogService;
import com.cgd.commodity.busi.bo.catalog.BusiAddCommodityCatalogReqBO;
import com.cgd.commodity.busi.bo.catalog.BusiAddCommodityCatalogRspBO;
import com.cgd.commodity.busi.impl.QryCommodityTypeServiceImpl;
import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.cgd.commodity.po.CommodityGuideCatalogPO;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddCommodityCatalogServiceImpl
implements AddCommodityCatalogService {
    private static final Logger logger = LoggerFactory.getLogger(QryCommodityTypeServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;

    public BusiAddCommodityCatalogRspBO addCommodityCatalog(BusiAddCommodityCatalogReqBO busiAddCommodityCatalogReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u7c7b\u76ee\u65b0\u589e\u4e1a\u52a1\u670d\u52a1\uff1a" + busiAddCommodityCatalogReqBO.toString());
        }
        BusiAddCommodityCatalogRspBO rsp = new BusiAddCommodityCatalogRspBO();
        try {
            int count = this.commodityGuideCatalogMapper.isHaveTheCatalogName(busiAddCommodityCatalogReqBO);
            if (count > 0) {
                rsp.setResultMsg("\u8be5\u9891\u9053\u540c\u7ea7\u7c7b\u76ee\u4e0b\u5df2\u5b58\u5728\u6b64\u7c7b\u76ee\u540d");
                rsp.setSuccess(false);
                throw new BusinessException("RSP_CODE_CATALOG_CONFLICT", "\u8be5\u9891\u9053\u540c\u7ea7\u7c7b\u76ee\u4e0b\u5df2\u5b58\u5728\u6b64\u7c7b\u76ee\u540d");
            }
        }
        catch (Exception e) {
            logger.error("\u7c7b\u76ee\u65b0\u589e\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_CATALOG_CONFLICT", "\u8be5\u9891\u9053\u540c\u7ea7\u7c7b\u76ee\u4e0b\u5df2\u5b58\u5728\u6b64\u7c7b\u76ee\u540d");
        }
        try {
            CommodityGuideCatalogPO confCatalog = this.commodityGuideCatalogMapper.selectConfCatalog(busiAddCommodityCatalogReqBO);
            this.commodityGuideCatalogMapper.insertByCatalogReqBO(busiAddCommodityCatalogReqBO);
            List commodityTypeIds = busiAddCommodityCatalogReqBO.getCommodityTypeIds();
            if (busiAddCommodityCatalogReqBO.getCatalogLevel() == 3 && commodityTypeIds.size() > 0) {
                Long guideCatalogId = busiAddCommodityCatalogReqBO.getGuideCatalogId();
                this.commodityGuideCatalogMapper.insertCatalogTypeRelWithId(guideCatalogId, commodityTypeIds, busiAddCommodityCatalogReqBO.getChannelId());
            }
            if (confCatalog != null && busiAddCommodityCatalogReqBO.getOrderConfSolution() != null) {
                if (busiAddCommodityCatalogReqBO.getOrderConfSolution() == 0) {
                    this.commodityGuideCatalogMapper.updateConfCatalog(confCatalog.getGuideCatalogId(), busiAddCommodityCatalogReqBO.getCatalogLevel(), busiAddCommodityCatalogReqBO.getChannelId(), busiAddCommodityCatalogReqBO.getUpperCatalogId());
                } else {
                    this.commodityGuideCatalogMapper.updateCataLogViewOrder(busiAddCommodityCatalogReqBO);
                }
            }
            rsp.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("\u7c7b\u76ee\u65b0\u589e\u4e1a\u52a1\u670d\u52a1\u51fa\u9519" + e);
            rsp.setResultMsg("\u7c7b\u76ee\u65b0\u589e\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7c7b\u76ee\u65b0\u589e\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        return rsp;
    }

    public void setCommodityGuideCatalogMapper(CommodityGuideCatalogMapper commodityGuideCatalogMapper) {
        this.commodityGuideCatalogMapper = commodityGuideCatalogMapper;
    }
}

