/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryCatalogNameService;
import com.cgd.commodity.busi.bo.QryCatalogNameReqBo;
import com.cgd.commodity.busi.bo.QryCatalogNameRspBO;
import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class QryCatalogNameServiceImpl
implements QryCatalogNameService {
    private static final Logger logger = LoggerFactory.getLogger(QryCatalogNameServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;

    public void setCommodityGuideCatalogMapper(CommodityGuideCatalogMapper commodityGuideCatalogMapper) {
        this.commodityGuideCatalogMapper = commodityGuideCatalogMapper;
    }

    public QryCatalogNameRspBO qryCatalogNameByCatalogId(QryCatalogNameReqBo qryCatalogNameReqBo) {
        if (this.isDebugEnabled) {
            logger.debug("\u6839\u636e\u4e09\u7ea7\u7c7b\u76eeId\u67e5\u8be2\u7c7b\u76ee\u5168\u8def\u5f84\u670d\u52a1\u5165\u53c2\uff1a" + qryCatalogNameReqBo.toString());
        }
        if (null == qryCatalogNameReqBo.getGuideCatalogId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636e\u4e09\u7ea7\u7c7b\u76eeId\u67e5\u8be2\u7c7b\u76ee\u5168\u8def\u5f84\u670d\u52a1\u5bfc\u822a\u7c7b\u76eeID[guideCatalogId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            QryCatalogNameRspBO qryCatalogNameRspBO = new QryCatalogNameRspBO();
            List<Map<String, Object>> catalogMaps = this.commodityGuideCatalogMapper.selectCatalogNameByGuideCatalogId(qryCatalogNameReqBo.getGuideCatalogId());
            if (!catalogMaps.isEmpty()) {
                Iterator<Map<String, Object>> iterator = catalogMaps.iterator();
                if (iterator.hasNext()) {
                    Map<String, Object> map = iterator.next();
                    qryCatalogNameRspBO.setFirstCatalogName((String)map.get("firstCatalogName"));
                    qryCatalogNameRspBO.setSecondCatalogName((String)map.get("secondCatalogName"));
                    qryCatalogNameRspBO.setThirdCatalogName((String)map.get("thirdCatalogName"));
                }
            } else {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u4e09\u7ea7\u7c7b\u76eeId\u67e5\u8be2\u4e09\u7ea7\u7c7b\u76ee\u540d\u79f0\u4e0d\u5b58\u5728");
            }
            return qryCatalogNameRspBO;
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u4e09\u7ea7\u7c7b\u76eeId\u67e5\u8be2\u7c7b\u76ee\u5168\u8def\u5f84\u670d\u52a1\u5931\u8d25\uff1a" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)((Object)e)).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)((Object)e)).getMsgCode();
                throw new BusinessException(resultCode, e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u4e09\u7ea7\u7c7b\u76eeId\u67e5\u8be2\u7c7b\u76ee\u5168\u8def\u5f84\u670d\u52a1\u5931\u8d25");
        }
    }
}

