/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QryHasOffShelveSkuLogAgrService;
import com.cgd.commodity.busi.bo.supply.QryHasOffShelveSkuLogAgrReqBO;
import com.cgd.commodity.busi.bo.supply.QryHasOffShelveSkuLogAgrRspBO;
import com.cgd.commodity.dao.SkuOffShelveLogMapper;
import com.cgd.commodity.dao.SupplierAgreementMapper;
import com.cgd.commodity.po.SupplierAgreement;
import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdAndCompIdBusiService;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdAndCompIdReqBO;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdAndCompIdRspBO;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QryHasOffShelveSkuLogAgrServiceImpl
implements QryHasOffShelveSkuLogAgrService {
    private static final Logger logger = LoggerFactory.getLogger(QryHasOffShelveSkuLogAgrServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SelectUserInfoByUserIdAndCompIdBusiService selectUserInfoByUserIdAndCompIdBusiService;
    private SupplierAgreementMapper supplierAgreementMapper;
    private SkuOffShelveLogMapper skuOffShelveLogMapper;

    public void setSelectUserInfoByUserIdAndCompIdBusiService(SelectUserInfoByUserIdAndCompIdBusiService selectUserInfoByUserIdAndCompIdBusiService) {
        this.selectUserInfoByUserIdAndCompIdBusiService = selectUserInfoByUserIdAndCompIdBusiService;
    }

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public void setSkuOffShelveLogMapper(SkuOffShelveLogMapper skuOffShelveLogMapper) {
        this.skuOffShelveLogMapper = skuOffShelveLogMapper;
    }

    public RspPageBO<QryHasOffShelveSkuLogAgrRspBO> qryHasOffShelveSkuLogAgr(QryHasOffShelveSkuLogAgrReqBO qryHasOffShelveSkuLogAgrReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5305\u542b\u4e0b\u67b6\u5546\u54c1\u8bb0\u5f55\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qryHasOffShelveSkuLogAgrReqBO.toString());
        }
        if (null == qryHasOffShelveSkuLogAgrReqBO.getUserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7528\u6237ID[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SelectUserInfoByUserIdAndCompIdReqBO selectUserInfoAndCompIdReqBO = new SelectUserInfoByUserIdAndCompIdReqBO();
        selectUserInfoAndCompIdReqBO.setUserId(qryHasOffShelveSkuLogAgrReqBO.getUserId());
        SelectUserInfoByUserIdAndCompIdRspBO selectUserInfoByUserIdAndCompIdRspBO = this.selectUserInfoByUserIdAndCompIdBusiService.selectUserInfoByUserIdAndCompId(selectUserInfoAndCompIdReqBO);
        qryHasOffShelveSkuLogAgrReqBO.setOrgId(selectUserInfoByUserIdAndCompIdRspBO.getOrgId());
        try {
            Long supplierId = null;
            supplierId = "0".equals(qryHasOffShelveSkuLogAgrReqBO.getIsprofess()) ? qryHasOffShelveSkuLogAgrReqBO.getCompanyId() : this.getUserSupplierId(qryHasOffShelveSkuLogAgrReqBO.getUserId()).getCompId();
            List<SupplierAgreement> allSupplierAgreement = this.supplierAgreementMapper.qryAgrByProducerIdAndSupplierIdAndOrgId(supplierId, qryHasOffShelveSkuLogAgrReqBO.getUserId(), qryHasOffShelveSkuLogAgrReqBO.getOrgId());
            Page page = new Page(qryHasOffShelveSkuLogAgrReqBO.getPageNo(), qryHasOffShelveSkuLogAgrReqBO.getPageSize());
            RspPageBO rspPageBO = new RspPageBO();
            if (!allSupplierAgreement.isEmpty()) {
                List<Long> agreementIds = new ArrayList<Long>();
                for (SupplierAgreement supplierAgreement : allSupplierAgreement) {
                    agreementIds.add(supplierAgreement.getAgreementId());
                }
                if (!agreementIds.isEmpty() && !(agreementIds = null != allSupplierAgreement.get(0) ? this.skuOffShelveLogMapper.selectByAgrIds(agreementIds, allSupplierAgreement.get(0).getSupplierId()) : this.skuOffShelveLogMapper.selectByAgrIds(agreementIds, supplierId)).isEmpty()) {
                    List<SupplierAgreement> supplierAgreements = this.supplierAgreementMapper.qryHasOffShelveSkuAgrs((Page<QryHasOffShelveSkuLogAgrReqBO>)page, qryHasOffShelveSkuLogAgrReqBO, agreementIds, supplierId, qryHasOffShelveSkuLogAgrReqBO.getOrgId());
                    List<QryHasOffShelveSkuLogAgrRspBO> result = this.resolveRsp(supplierAgreements);
                    rspPageBO.setRows(result);
                }
            }
            rspPageBO.setRecordsTotal(page.getTotalCount());
            rspPageBO.setTotal(page.getTotalPages());
            rspPageBO.setPageNo(qryHasOffShelveSkuLogAgrReqBO.getPageNo());
            return rspPageBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5305\u542b\u4e0b\u67b6\u5546\u54c1\u8bb0\u5f55\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u5305\u542b\u4e0b\u67b6\u5546\u54c1\u8bb0\u5f55\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private SelectUserInfoByUserIdAndCompIdRspBO getUserSupplierId(Long userId) {
        try {
            SelectUserInfoByUserIdAndCompIdReqBO selectUserInfoAndCompIdReqBO = new SelectUserInfoByUserIdAndCompIdReqBO();
            selectUserInfoAndCompIdReqBO.setUserId(userId);
            SelectUserInfoByUserIdAndCompIdRspBO selectUserInfoByUserIdAndCompIdRspBO = this.selectUserInfoByUserIdAndCompIdBusiService.selectUserInfoByUserIdAndCompId(selectUserInfoAndCompIdReqBO);
            if ("0000".equals(selectUserInfoByUserIdAndCompIdRspBO.getRespCode())) {
                return selectUserInfoByUserIdAndCompIdRspBO;
            }
            return null;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u542f\u7528\u534f\u8bae\u4e1a\u52a1\u670d\u52a1\u6839\u636e\u7528\u6237\u67e5\u94fa\u8d27\u5355\u4f4d\u4fe1\u606f\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u6839\u636e\u7528\u6237\u67e5\u94fa\u8d27\u5355\u4f4d\u4fe1\u606f\u5931\u8d25");
        }
    }

    private List<QryHasOffShelveSkuLogAgrRspBO> resolveRsp(List<SupplierAgreement> supplierAgreements) {
        try {
            ArrayList<QryHasOffShelveSkuLogAgrRspBO> qryHasOffShelveSkuLogAgrRspBOs = new ArrayList<QryHasOffShelveSkuLogAgrRspBO>();
            if (!supplierAgreements.isEmpty()) {
                for (SupplierAgreement supplierAgreement : supplierAgreements) {
                    Map<String, Long> skuNumMap = this.skuOffShelveLogMapper.qrySkuNumsByAgrId(supplierAgreement.getAgreementId(), supplierAgreement.getSupplierId());
                    QryHasOffShelveSkuLogAgrRspBO qryHasOffShelveSkuLogAgrRspBO = new QryHasOffShelveSkuLogAgrRspBO();
                    qryHasOffShelveSkuLogAgrRspBO.setAgreementId(supplierAgreement.getAgreementId());
                    qryHasOffShelveSkuLogAgrRspBO.setAgreementName(supplierAgreement.getAgreementName());
                    qryHasOffShelveSkuLogAgrRspBO.setAgreementType(supplierAgreement.getAgreementType());
                    qryHasOffShelveSkuLogAgrRspBO.setEntAgreementCode(supplierAgreement.getEntAgreementCode());
                    qryHasOffShelveSkuLogAgrRspBO.setPlaAgreementCode(supplierAgreement.getPlaAgreementCode());
                    qryHasOffShelveSkuLogAgrRspBO.setSupplierId(supplierAgreement.getSupplierId());
                    qryHasOffShelveSkuLogAgrRspBO.setProducerName(supplierAgreement.getProducerName());
                    qryHasOffShelveSkuLogAgrRspBO.setIsDispatch(supplierAgreement.getIsDispatch());
                    qryHasOffShelveSkuLogAgrRspBO.setSignTime(supplierAgreement.getSignTime());
                    qryHasOffShelveSkuLogAgrRspBO.setVendorId(supplierAgreement.getVendorId());
                    qryHasOffShelveSkuLogAgrRspBO.setVendorName(supplierAgreement.getVendorName());
                    qryHasOffShelveSkuLogAgrRspBO.setAgrLocation(supplierAgreement.getAgrLocation());
                    qryHasOffShelveSkuLogAgrRspBO.setUnitAccountId(supplierAgreement.getUnitAccountId());
                    qryHasOffShelveSkuLogAgrRspBO.setUnitAccountName(supplierAgreement.getUnitAccountName());
                    qryHasOffShelveSkuLogAgrRspBO.setVendorDepartmentId(supplierAgreement.getVendorDepartmentId());
                    qryHasOffShelveSkuLogAgrRspBO.setVendorDepartmentName(supplierAgreement.getVendorDepartmentName());
                    if (!skuNumMap.isEmpty()) {
                        qryHasOffShelveSkuLogAgrRspBO.setOffShelveSkuNum(skuNumMap.get("OFF_SHELVE_SKU_NUM"));
                    }
                    qryHasOffShelveSkuLogAgrRspBOs.add(qryHasOffShelveSkuLogAgrRspBO);
                }
                return qryHasOffShelveSkuLogAgrRspBOs;
            }
            return null;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5305\u542b\u4e0b\u67b6\u5546\u54c1\u8bb0\u5f55\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u7edf\u8ba1\u5546\u54c1\u5404\u72b6\u6001\u6570\u91cf-\u5c01\u88c5\u54cd\u5e94\u6570\u636e\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u7edf\u8ba1\u5546\u54c1\u5404\u72b6\u6001\u6570\u91cf-\u5c01\u88c5\u54cd\u5e94\u6570\u636e\u5931\u8d25");
        }
    }
}

