/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.commodity.busi.impl;

import com.cgd.commodity.busi.QrySkuAgrService;
import com.cgd.commodity.busi.bo.QrySkuAgrReqBO;
import com.cgd.commodity.busi.bo.QrySkuAgrRspBO;
import com.cgd.commodity.dao.SupplierAgreementMapper;
import com.cgd.commodity.dao.SupplierAgreementSkuMapper;
import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdBusiService;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdReqBO;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdRspBO;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class QrySkuAgrServiceImpl
implements QrySkuAgrService {
    private static final Logger logger = LoggerFactory.getLogger(QrySkuAgrServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService;
    private SupplierAgreementMapper supplierAgreementMapper;
    private SupplierAgreementSkuMapper supplierAgreementSkuMapper;

    public void setSelectUserInfoByUserIdBusiService(SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService) {
        this.selectUserInfoByUserIdBusiService = selectUserInfoByUserIdBusiService;
    }

    public void setSupplierAgreementMapper(SupplierAgreementMapper supplierAgreementMapper) {
        this.supplierAgreementMapper = supplierAgreementMapper;
    }

    public void setSupplierAgreementSkuMapper(SupplierAgreementSkuMapper supplierAgreementSkuMapper) {
        this.supplierAgreementSkuMapper = supplierAgreementSkuMapper;
    }

    public RspPageBO<QrySkuAgrRspBO> qrySkuAgreement(QrySkuAgrReqBO qrySkuAgrReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5546\u54c1\u67e5\u8be2\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + qrySkuAgrReqBO.toString());
        }
        if (null == qrySkuAgrReqBO.getUserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7528\u6237ID[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.isEmpty((Object)qrySkuAgrReqBO.getPlaAgreementCode())) {
            qrySkuAgrReqBO.setPlaAgreementCode(qrySkuAgrReqBO.getPlaAgreementCode().replaceAll(" ", ""));
        }
        if (!StringUtils.isEmpty((Object)qrySkuAgrReqBO.getEntAgreementCode())) {
            qrySkuAgrReqBO.setEntAgreementCode(qrySkuAgrReqBO.getEntAgreementCode().replaceAll(" ", ""));
        }
        if (!StringUtils.isEmpty((Object)qrySkuAgrReqBO.getAgreementName())) {
            qrySkuAgrReqBO.setAgreementName(qrySkuAgrReqBO.getAgreementName().replaceAll(" ", ""));
        }
        if (!StringUtils.isEmpty((Object)qrySkuAgrReqBO.getProducerName())) {
            qrySkuAgrReqBO.setProducerName(qrySkuAgrReqBO.getProducerName().replaceAll(" ", ""));
        }
        if (!StringUtils.isEmpty((Object)qrySkuAgrReqBO.getVendorName())) {
            qrySkuAgrReqBO.setVendorName(qrySkuAgrReqBO.getVendorName().replaceAll(" ", ""));
        }
        RspPageBO rspPageBO = new RspPageBO();
        try {
            SelectUserInfoByUserIdReqBO selectUserInfoReqBO = new SelectUserInfoByUserIdReqBO();
            selectUserInfoReqBO.setUserId(qrySkuAgrReqBO.getUserId());
            SelectUserInfoByUserIdRspBO selectUserInfoByUserIdBusi = this.selectUserInfoByUserIdBusi(selectUserInfoReqBO);
            if (selectUserInfoByUserIdBusi != null && selectUserInfoByUserIdBusi.getCompId() != null) {
                qrySkuAgrReqBO.setSupplierId(selectUserInfoByUserIdBusi.getCompId());
                Page page = new Page(qrySkuAgrReqBO.getPageNo(), qrySkuAgrReqBO.getPageSize());
                List<Object> results = new ArrayList();
                ArrayList<QrySkuAgrRspBO> rows = new ArrayList<QrySkuAgrRspBO>();
                results = this.supplierAgreementMapper.qrySkuAgreement((Page<Map<String, Object>>)page, qrySkuAgrReqBO, qrySkuAgrReqBO.getAgrLocation());
                if (results != null && results.size() > 0) {
                    for (QrySkuAgrRspBO qrySkuAgrRspBO : results) {
                        int selectCountByAgreementId = this.supplierAgreementSkuMapper.selectCountByAgreementIdAndSku(qrySkuAgrRspBO.getAgreementId(), qrySkuAgrRspBO.getSupplierId(), qrySkuAgrRspBO.getAgrLocation());
                        QrySkuAgrRspBO row = new QrySkuAgrRspBO();
                        BigDecimal buyNumber = new BigDecimal(selectCountByAgreementId);
                        row.setAgreementId(qrySkuAgrRspBO.getAgreementId());
                        row.setSupplierId(qrySkuAgrRspBO.getSupplierId());
                        row.setAgreementName(qrySkuAgrRspBO.getAgreementName());
                        row.setAgreementType(qrySkuAgrRspBO.getAgreementType());
                        row.setEntAgreementCode(qrySkuAgrRspBO.getEntAgreementCode());
                        row.setIsDispatch(qrySkuAgrRspBO.getIsDispatch());
                        row.setSkuNumber(buyNumber);
                        row.setPlaAgreementCode(qrySkuAgrRspBO.getPlaAgreementCode());
                        row.setProducerName(qrySkuAgrRspBO.getProducerName());
                        row.setVendorName(qrySkuAgrRspBO.getVendorName());
                        row.setSignTime(qrySkuAgrRspBO.getSignTime());
                        row.setAgrLocation(qrySkuAgrRspBO.getAgrLocation());
                        row.setUnitAccountId(qrySkuAgrRspBO.getUnitAccountId());
                        row.setUnitAccountName(qrySkuAgrRspBO.getUnitAccountName());
                        row.setVendorDepartmentId(qrySkuAgrRspBO.getVendorDepartmentId());
                        row.setVendorDepartmentName(qrySkuAgrRspBO.getVendorDepartmentName());
                        rows.add(row);
                    }
                    rspPageBO.setRecordsTotal(page.getTotalCount());
                    rspPageBO.setTotal(page.getTotalPages());
                    rspPageBO.setPageNo(qrySkuAgrReqBO.getPageNo());
                    rspPageBO.setRows(rows);
                }
                return rspPageBO;
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636euserid\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u670d\u52a1CompId\u4e3a\u7a7a");
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u67e5\u8be2\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + e);
            String resultCode = "";
            if (e instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)e).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)e).getMsgCode();
                throw new BusinessException(resultCode, e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u67e5\u8be2\u534f\u8bae\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
        }
    }

    private SelectUserInfoByUserIdRspBO selectUserInfoByUserIdBusi(SelectUserInfoByUserIdReqBO selectUserInfoReqBO) {
        try {
            SelectUserInfoByUserIdRspBO selectUserInfoByUserIdRspBO = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(selectUserInfoReqBO);
            return selectUserInfoByUserIdRspBO;
        }
        catch (Exception e) {
            logger.error("\u6839\u636euserid\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u670d\u52a1\u5931\u8d25" + e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u6839\u636euserid\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u670d\u52a1\u5931\u8d25");
        }
    }
}

